/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter;

import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.html.LineFormattingAppendable;
import com.vladsch.flexmark.util.html.LineFormattingAppendableImpl;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;

public class MarkdownWriter
implements LineFormattingAppendable {
    private final LineFormattingAppendable myAppendable;
    private NodeFormatterContext context;

    public MarkdownWriter() {
        this(0);
    }

    public String toString() {
        return this.myAppendable.toString();
    }

    public MarkdownWriter(int formatOptions) {
        this.myAppendable = new LineFormattingAppendableImpl(formatOptions);
        this.myAppendable.setOptions(this.myAppendable.getOptions() | 0x80);
    }

    public void setContext(NodeFormatterContext context) {
        this.context = context;
    }

    public NodeFormatterContext getContext() {
        return this.context;
    }

    public MarkdownWriter tailBlankLine() {
        return this.tailBlankLine(1);
    }

    public boolean isLastBlockQuoteChild(Node node) {
        Node parent = node.getParent();
        return parent instanceof BlockQuote && parent.getLastChild() == node;
    }

    public MarkdownWriter tailBlankLine(int count) {
        Node node = this.context.getCurrentNode();
        if (this.isLastBlockQuoteChild(node)) {
            CharSequence prefix = this.getPrefix();
            this.popPrefix();
            this.blankLine(count);
            this.pushPrefix();
            this.setPrefix(prefix, false);
        } else {
            this.blankLine(count);
        }
        return this;
    }

    public MarkdownWriter appendNonTranslating(CharSequence csq) {
        return this.appendNonTranslating(null, csq, null, null);
    }

    public MarkdownWriter appendNonTranslating(CharSequence prefix, CharSequence csq) {
        return this.appendNonTranslating(prefix, csq, null, null);
    }

    public MarkdownWriter appendNonTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix) {
        return this.appendNonTranslating(prefix, csq, suffix, null);
    }

    public MarkdownWriter appendNonTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix, CharSequence suffix2) {
        if (this.context.isTransformingText()) {
            this.append(this.context.transformNonTranslating(prefix, csq, suffix, suffix2));
        } else {
            this.append(csq);
        }
        return this;
    }

    public MarkdownWriter appendNonTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix, CharSequence suffix2, Consumer<String> placeholderConsumer) {
        if (this.context.isTransformingText()) {
            this.append(this.context.transformNonTranslating(prefix, csq, suffix, suffix2));
        } else {
            this.append(csq);
        }
        return this;
    }

    public MarkdownWriter appendTranslating(CharSequence csq) {
        return this.appendTranslating(null, csq, null, null);
    }

    public MarkdownWriter appendTranslating(CharSequence prefix, CharSequence csq) {
        return this.appendTranslating(prefix, csq, null, null);
    }

    public MarkdownWriter appendTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix) {
        return this.appendTranslating(prefix, csq, suffix, null);
    }

    public MarkdownWriter appendTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix, CharSequence suffix2) {
        if (this.context.isTransformingText()) {
            this.append(this.context.transformTranslating(prefix, csq, suffix, suffix2));
        } else {
            if (prefix != null) {
                this.append(prefix);
            }
            this.append(csq);
            if (suffix != null) {
                this.append(suffix);
            }
        }
        return this;
    }

    @Override
    public boolean isPendingSpace() {
        return this.myAppendable.isPendingSpace();
    }

    @Override
    public boolean isPreFormatted() {
        return this.myAppendable.isPreFormatted();
    }

    @Override
    public boolean isPreFormattedLine(int line) {
        return this.myAppendable.isPreFormattedLine(line);
    }

    @Override
    public CharSequence getIndentPrefix() {
        return this.myAppendable.getIndentPrefix();
    }

    @Override
    public CharSequence getPrefix() {
        return this.myAppendable.getPrefix();
    }

    @Override
    public int column() {
        return this.myAppendable.column();
    }

    @Override
    public int getLineCount() {
        return this.myAppendable.getLineCount();
    }

    @Override
    public int getOptions() {
        return this.myAppendable.getOptions();
    }

    @Override
    public int getPendingEOL() {
        return this.myAppendable.getPendingEOL();
    }

    @Override
    public int getPendingSpace() {
        return this.myAppendable.getPendingSpace();
    }

    @Override
    public int offset() {
        return this.myAppendable.offset();
    }

    @Override
    public int offsetWithPending() {
        return this.myAppendable.offsetWithPending();
    }

    @Override
    public int textOnlyOffset() {
        return this.myAppendable.textOnlyOffset();
    }

    @Override
    public int textOnlyOffsetWithPending() {
        return this.myAppendable.textOnlyOffsetWithPending();
    }

    @Override
    public List<BasedSequence> getLinePrefixes(int startLine, int endLine) {
        return this.myAppendable.getLinePrefixes(startLine, endLine);
    }

    @Override
    public List<CharSequence> getLineContents(int startLine, int endLine) {
        return this.myAppendable.getLineContents(startLine, endLine);
    }

    @Override
    public List<CharSequence> getLines(int startLine, int endLine) {
        return this.myAppendable.getLines(startLine, endLine);
    }

    @Override
    public MarkdownWriter addIndentOnFirstEOL(Runnable runnable) {
        this.myAppendable.addIndentOnFirstEOL(runnable);
        return this;
    }

    @Override
    public MarkdownWriter addLine() {
        this.myAppendable.addLine();
        return this;
    }

    @Override
    public MarkdownWriter addPrefix(CharSequence prefix) {
        this.myAppendable.addPrefix(prefix);
        return this;
    }

    @Override
    public MarkdownWriter addPrefix(CharSequence prefix, boolean afterEol) {
        this.myAppendable.addPrefix(prefix, afterEol);
        return this;
    }

    @Override
    public MarkdownWriter append(char c) {
        this.myAppendable.append(c);
        return this;
    }

    @Override
    public MarkdownWriter append(CharSequence csq) {
        this.myAppendable.append(csq);
        return this;
    }

    @Override
    public MarkdownWriter append(CharSequence csq, int start, int end) {
        this.myAppendable.append(csq, start, end);
        return this;
    }

    @Override
    public MarkdownWriter append(LineFormattingAppendable lineAppendable, int startLine, int endLine) {
        this.myAppendable.append(lineAppendable, startLine, endLine);
        return this;
    }

    @Override
    public MarkdownWriter appendTo(Appendable out, int maxBlankLines, CharSequence prefix, int startLine, int endLine) throws IOException {
        this.myAppendable.appendTo(out, maxBlankLines, prefix, startLine, endLine);
        return this;
    }

    @Override
    public MarkdownWriter blankLine() {
        this.myAppendable.blankLine();
        return this;
    }

    @Override
    public MarkdownWriter blankLine(int count) {
        this.myAppendable.blankLine(count);
        return this;
    }

    @Override
    public MarkdownWriter blankLineIf(boolean predicate) {
        this.myAppendable.blankLineIf(predicate);
        return this;
    }

    @Override
    public MarkdownWriter closePreFormatted() {
        this.myAppendable.closePreFormatted();
        return this;
    }

    @Override
    public MarkdownWriter indent() {
        this.myAppendable.indent();
        return this;
    }

    @Override
    public MarkdownWriter line() {
        this.myAppendable.line();
        return this;
    }

    @Override
    public MarkdownWriter lineIf(boolean predicate) {
        this.myAppendable.lineIf(predicate);
        return this;
    }

    @Override
    public MarkdownWriter lineOnFirstText(boolean value) {
        this.myAppendable.lineOnFirstText(value);
        return this;
    }

    @Override
    public MarkdownWriter lineWithTrailingSpaces(int count) {
        this.myAppendable.lineWithTrailingSpaces(count);
        return this;
    }

    @Override
    public MarkdownWriter openPreFormatted(boolean keepIndent) {
        this.myAppendable.openPreFormatted(keepIndent);
        return this;
    }

    @Override
    public MarkdownWriter popPrefix() {
        this.myAppendable.popPrefix();
        return this;
    }

    @Override
    public MarkdownWriter popPrefix(boolean afterEol) {
        this.myAppendable.popPrefix(afterEol);
        return this;
    }

    @Override
    public MarkdownWriter prefixLines(CharSequence prefix, boolean addAfterLinePrefix, int startLine, int endLine) {
        this.myAppendable.prefixLines(prefix, addAfterLinePrefix, startLine, endLine);
        return this;
    }

    @Override
    public MarkdownWriter pushPrefix() {
        this.myAppendable.pushPrefix();
        return this;
    }

    @Override
    public MarkdownWriter removeIndentOnFirstEOL(Runnable runnable) {
        this.myAppendable.removeIndentOnFirstEOL(runnable);
        return this;
    }

    @Override
    public MarkdownWriter removeLines(int startLine, int endLine) {
        this.myAppendable.removeLines(startLine, endLine);
        return this;
    }

    @Override
    public MarkdownWriter repeat(char c, int count) {
        this.myAppendable.repeat(c, count);
        return this;
    }

    @Override
    public MarkdownWriter repeat(CharSequence csq, int count) {
        this.myAppendable.repeat(csq, count);
        return this;
    }

    @Override
    public MarkdownWriter repeat(CharSequence csq, int start, int end, int count) {
        this.myAppendable.repeat(csq, start, end, count);
        return this;
    }

    @Override
    public MarkdownWriter setIndentPrefix(CharSequence prefix) {
        this.myAppendable.setIndentPrefix(prefix);
        return this;
    }

    @Override
    public MarkdownWriter setOptions(int options) {
        this.myAppendable.setOptions(options);
        return this;
    }

    @Override
    public MarkdownWriter setPrefix(CharSequence prefix) {
        this.myAppendable.setPrefix(prefix);
        return this;
    }

    @Override
    public MarkdownWriter setPrefix(CharSequence prefix, boolean afterEol) {
        this.myAppendable.setPrefix(prefix, afterEol);
        return this;
    }

    @Override
    public MarkdownWriter unIndent() {
        this.myAppendable.unIndent();
        return this;
    }

    @Override
    public MarkdownWriter unIndentNoEol() {
        this.myAppendable.unIndentNoEol();
        return this;
    }

    @Override
    public String toString(int maxBlankLines) {
        return this.myAppendable.toString(maxBlankLines);
    }
}

