/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.admonition;

import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.List;

public class AdmonitionBlock
extends Block {
    private BasedSequence openingMarker = BasedSequence.NULL;
    private BasedSequence info = BasedSequence.NULL;
    protected BasedSequence titleOpeningMarker = BasedSequence.NULL;
    protected BasedSequence title = BasedSequence.NULL;
    protected BasedSequence titleClosingMarker = BasedSequence.NULL;

    @Override
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.info, this.titleOpeningMarker, this.title, this.titleClosingMarker};
    }

    @Override
    public BasedSequence[] getSegmentsForChars() {
        return new BasedSequence[]{this.openingMarker, this.info, this.titleOpeningMarker, this.title, this.titleClosingMarker};
    }

    @Override
    public void getAstExtra(StringBuilder out) {
        BasedSequence content = this.getContentChars();
        int lines = this.getContentLines().size();
        AdmonitionBlock.segmentSpanChars(out, this.openingMarker, "open");
        AdmonitionBlock.segmentSpanChars(out, this.info, "info");
        AdmonitionBlock.delimitedSegmentSpanChars(out, this.titleOpeningMarker, this.title, this.titleClosingMarker, "title");
    }

    public AdmonitionBlock() {
    }

    public AdmonitionBlock(BasedSequence chars) {
        super(chars);
    }

    public AdmonitionBlock(BasedSequence chars, BasedSequence openingMarker, BasedSequence info, List<BasedSequence> segments) {
        super(chars, segments);
        this.openingMarker = openingMarker;
        this.info = info;
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    public void setInfo(BasedSequence info) {
        this.info = info;
    }

    public BasedSequence getInfo() {
        return this.info;
    }

    public BasedSequence getTitle() {
        return this.title;
    }

    public BasedSequence getTitleOpeningMarker() {
        return this.titleOpeningMarker;
    }

    public void setTitleOpeningMarker(BasedSequence titleOpeningMarker) {
        this.titleOpeningMarker = titleOpeningMarker;
    }

    public void setTitle(BasedSequence title) {
        this.title = title;
    }

    public BasedSequence getTitleClosingMarker() {
        return this.titleClosingMarker;
    }

    public void setTitleClosingMarker(BasedSequence titleClosingMarker) {
        this.titleClosingMarker = titleClosingMarker;
    }

    public BasedSequence getTitleChars() {
        return AdmonitionBlock.spanningChars(this.titleOpeningMarker, this.title, this.titleClosingMarker);
    }

    public void setTitleChars(BasedSequence titleChars) {
        if (titleChars != null && titleChars != BasedSequence.NULL) {
            int titleCharsLength = titleChars.length();
            this.titleOpeningMarker = titleChars.subSequence(0, 1);
            this.title = titleChars.subSequence(1, titleCharsLength - 1);
            this.titleClosingMarker = titleChars.subSequence(titleCharsLength - 1, titleCharsLength);
        } else {
            this.titleOpeningMarker = BasedSequence.NULL;
            this.title = BasedSequence.NULL;
            this.titleClosingMarker = BasedSequence.NULL;
        }
    }
}

