/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.wikilink.internal;

import com.vladsch.flexmark.ast.util.TextCollectingVisitor;
import com.vladsch.flexmark.ext.wikilink.WikiImage;
import com.vladsch.flexmark.ext.wikilink.WikiLink;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.ext.wikilink.WikiNode;
import com.vladsch.flexmark.ext.wikilink.internal.WikiLinkOptions;
import com.vladsch.flexmark.parser.LinkRefProcessor;
import com.vladsch.flexmark.parser.LinkRefProcessorFactory;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class WikiLinkLinkRefProcessor
implements LinkRefProcessor {
    static final int BRACKET_NESTING_LEVEL = 1;
    private final WikiLinkOptions options;

    public WikiLinkLinkRefProcessor(Document document) {
        this.options = new WikiLinkOptions(document);
    }

    @Override
    public boolean getWantExclamationPrefix() {
        return this.options.imageLinks;
    }

    @Override
    public int getBracketNestingLevel() {
        return 1;
    }

    @Override
    public boolean isMatch(BasedSequence nodeChars) {
        int length = nodeChars.length();
        if (this.options.imageLinks) {
            if (length >= 5 && nodeChars.charAt(0) == '!') {
                return nodeChars.charAt(1) == '[' && nodeChars.charAt(2) == '[' && nodeChars.endCharAt(1) == ']' && nodeChars.endCharAt(2) == ']';
            }
            if (length >= 4) {
                return nodeChars.charAt(0) == '[' && nodeChars.charAt(1) == '[' && nodeChars.endCharAt(1) == ']' && nodeChars.endCharAt(2) == ']';
            }
        } else if (length >= 4) {
            return nodeChars.charAt(0) == '[' && nodeChars.charAt(1) == '[' && nodeChars.endCharAt(1) == ']' && nodeChars.endCharAt(2) == ']';
        }
        return false;
    }

    @Override
    public BasedSequence adjustInlineText(Document document, Node node) {
        assert (node instanceof WikiNode);
        WikiNode wikiNode = (WikiNode)node;
        return wikiNode.getText().ifNull(wikiNode.getLink());
    }

    @Override
    public boolean allowDelimiters(BasedSequence chars, Document document, Node node) {
        assert (node instanceof WikiNode);
        WikiNode wikiNode = (WikiNode)node;
        return node instanceof WikiLink && WikiLinkExtension.ALLOW_INLINES.getFrom(document) != false && wikiNode.getText().ifNull(wikiNode.getLink()).containsAllOf(chars);
    }

    @Override
    public void updateNodeElements(Document document, Node node) {
        assert (node instanceof WikiNode);
        WikiNode wikiNode = (WikiNode)node;
        if (node instanceof WikiLink && WikiLinkExtension.ALLOW_INLINES.getFrom(document).booleanValue() && wikiNode.getText().isNull()) {
            BasedSequence link = new TextCollectingVisitor(new Class[0]).collectAndGetSequence(node);
            wikiNode.setLink(link, WikiLinkExtension.ALLOW_ANCHORS.getFrom(document), WikiLinkExtension.ALLOW_ANCHOR_ESCAPE.getFrom(document));
        }
    }

    @Override
    public Node createNode(BasedSequence nodeChars) {
        return nodeChars.firstChar() == '!' ? new WikiImage(nodeChars, this.options.linkFirstSyntax, this.options.allowPipeEscape) : new WikiLink(nodeChars, this.options.linkFirstSyntax, this.options.allowAnchors, this.options.allowPipeEscape, this.options.allowAnchorEscape);
    }

    public static class Factory
    implements LinkRefProcessorFactory {
        @Override
        public LinkRefProcessor create(Document document) {
            return new WikiLinkLinkRefProcessor(document);
        }

        @Override
        public boolean getWantExclamationPrefix(DataHolder options) {
            return WikiLinkExtension.IMAGE_LINKS.getFrom(options);
        }

        @Override
        public int getBracketNestingLevel(DataHolder options) {
            return 1;
        }
    }
}

