/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference.internal;

import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedOrdinalRenderer;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBase;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBlock;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRendering;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumeratedReferenceRepository;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashMap;

public class EnumeratedReferences {
    public static final String EMPTY_TYPE = "";
    public static final int[] EMPTY_ORDINALS = new int[0];
    private final EnumeratedReferenceRepository referenceRepository;
    private final HashMap<String, Integer> enumerationCounters;
    private final HashMap<String, int[]> enumeratedReferenceOrdinals;

    public EnumeratedReferences(DataHolder options) {
        this.referenceRepository = EnumeratedReferenceExtension.ENUMERATED_REFERENCES.getFrom(options);
        this.enumerationCounters = new HashMap();
        this.enumeratedReferenceOrdinals = new HashMap();
    }

    public void add(String text) {
        String type = EnumeratedReferenceRepository.getType(text);
        String[] types = type.split(":");
        int[] ordinals = new int[types.length];
        StringBuilder nestedType = new StringBuilder();
        int iMax = types.length;
        for (int i = 0; i < iMax; ++i) {
            int ordinal;
            String typeText = types[i];
            nestedType.append(typeText);
            String nestedTypeKey = nestedType.toString();
            if (i < iMax - 1) {
                Integer ordinalInt = this.enumerationCounters.get(nestedTypeKey);
                int typeOrdinal = ordinalInt == null ? 0 : ordinalInt;
                nestedType.append(':').append(typeOrdinal).append(':');
                ordinals[i] = typeOrdinal;
                continue;
            }
            if (!this.enumerationCounters.containsKey(nestedTypeKey)) {
                this.enumerationCounters.put(nestedTypeKey, 1);
                ordinal = 1;
            } else {
                ordinal = this.enumerationCounters.get(nestedTypeKey) + 1;
                this.enumerationCounters.put(nestedTypeKey, ordinal);
            }
            ordinals[i] = ordinal;
        }
        this.enumeratedReferenceOrdinals.put(text, ordinals);
    }

    @Deprecated
    public int getOrdinal(String text) {
        int[] ordinals = this.enumeratedReferenceOrdinals.get(text);
        return ordinals == null ? 0 : ordinals[ordinals.length - 1];
    }

    @Deprecated
    public Node getFormatNode(String text) {
        String type = EnumeratedReferenceRepository.getType(text);
        return (Node)this.referenceRepository.get(type);
    }

    public EnumeratedReferenceRendering[] getEnumeratedReferenceOrdinals(String text) {
        String type = EnumeratedReferenceRepository.getType(text);
        String[] types = type.split(":");
        EnumeratedReferenceRendering[] renderings = new EnumeratedReferenceRendering[types.length];
        int[] ordinals = this.enumeratedReferenceOrdinals.get(text);
        if (ordinals == null) {
            ordinals = EMPTY_ORDINALS;
        }
        int iMax = types.length;
        for (int i = 0; i < iMax; ++i) {
            String typeText = types[i];
            EnumeratedReferenceBlock referenceFormat = (EnumeratedReferenceBlock)this.referenceRepository.get(typeText);
            int ordinal = i < ordinals.length ? ordinals[i] : 0;
            renderings[i] = new EnumeratedReferenceRendering(referenceFormat, typeText, ordinal);
        }
        return renderings;
    }

    public void renderReferenceOrdinals(String text, String defaultFormat, EnumeratedOrdinalRenderer renderer) {
        EnumeratedReferenceRendering[] renderings = this.getEnumeratedReferenceOrdinals(text);
        EnumeratedReferences.renderReferenceOrdinals(renderings, defaultFormat, renderer);
    }

    public static void renderReferenceOrdinals(EnumeratedReferenceRendering[] renderings, String defaultFormat, EnumeratedOrdinalRenderer renderer) {
        boolean needSeparator = false;
        String useDefaultFormat = defaultFormat == null ? "%s %d" : defaultFormat;
        renderer.startRendering(renderings);
        for (EnumeratedReferenceRendering rendering : renderings) {
            int ordinal = rendering.referenceOrdinal;
            String defaultText = String.format(useDefaultFormat, rendering.referenceType, rendering.referenceOrdinal);
            renderer.render(ordinal, rendering.referenceFormat, defaultText, needSeparator);
            if (rendering.referenceFormat != null) {
                Node lastChild;
                for (lastChild = rendering.referenceFormat.getLastChild(); lastChild != null && !(lastChild instanceof EnumeratedReferenceBase); lastChild = lastChild.getLastChild()) {
                }
                needSeparator = lastChild instanceof EnumeratedReferenceBase && ((EnumeratedReferenceBase)lastChild).getText().isEmpty();
                continue;
            }
            char c = defaultText.charAt(defaultText.length() - 1);
            needSeparator = Character.isUnicodeIdentifierPart(c);
        }
        renderer.endRendering();
    }
}

