/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.ast;

import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeIterator;
import com.vladsch.flexmark.util.collection.Consumer;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterator;
import com.vladsch.flexmark.util.collection.iteration.ReversiblePeekingIterable;
import com.vladsch.flexmark.util.collection.iteration.ReversiblePeekingIterator;

public class NodeIterable
implements ReversiblePeekingIterable<Node> {
    final Node firstNode;
    final Node lastNode;
    final boolean reversed;
    public static final ReversiblePeekingIterable<Node> EMPTY = new ReversiblePeekingIterable<Node>(){

        @Override
        public ReversiblePeekingIterator<Node> iterator() {
            return NodeIterator.EMPTY;
        }

        @Override
        public ReversiblePeekingIterable<Node> reversed() {
            return this;
        }

        @Override
        public void forEach(Consumer<? super Node> consumer) {
        }

        @Override
        public boolean isReversed() {
            return false;
        }

        @Override
        public ReversiblePeekingIterator<Node> reversedIterator() {
            return NodeIterator.EMPTY;
        }
    };

    public NodeIterable(Node firstNode, Node lastNode, boolean reversed) {
        this.firstNode = firstNode;
        this.lastNode = lastNode;
        this.reversed = reversed;
    }

    @Override
    public ReversiblePeekingIterator<Node> iterator() {
        return new NodeIterator(this.firstNode, this.lastNode, this.reversed);
    }

    @Override
    public void forEach(Consumer<? super Node> consumer) {
        ReversibleIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            consumer.accept((Node)iterator.next());
        }
    }

    @Override
    public ReversiblePeekingIterable<Node> reversed() {
        return new NodeIterable(this.firstNode, this.lastNode, !this.reversed);
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public ReversiblePeekingIterator<Node> reversedIterator() {
        return new NodeIterator(this.firstNode, this.lastNode, !this.reversed);
    }
}

