/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.tables.internal;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCaption;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.formatter.CustomNodeFormatter;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.RenderPurpose;
import com.vladsch.flexmark.formatter.TranslatingSpanRender;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.format.MarkdownTable;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.format.TableManipulator;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TableNodeFormatter
implements NodeFormatter {
    private final TableFormatOptions options;
    private final boolean isIntellijDummyIdentifier;
    private final String intellijDummyIdentifier;
    private final boolean parserTrimCellWhiteSpace;
    private MarkdownTable myTable;

    public TableNodeFormatter(DataHolder options) {
        this.options = new TableFormatOptions(options);
        this.isIntellijDummyIdentifier = Parser.INTELLIJ_DUMMY_IDENTIFIER.getFrom(options);
        this.intellijDummyIdentifier = this.isIntellijDummyIdentifier ? "\u001f" : "";
        this.parserTrimCellWhiteSpace = TablesExtension.TRIM_CELL_WHITESPACE.getFrom(options);
    }

    @Override
    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    @Override
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler<TableBlock>(TableBlock.class, new CustomNodeFormatter<TableBlock>(){

            @Override
            public void render(TableBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<TableHead>(TableHead.class, new CustomNodeFormatter<TableHead>(){

            @Override
            public void render(TableHead node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<TableSeparator>(TableSeparator.class, new CustomNodeFormatter<TableSeparator>(){

            @Override
            public void render(TableSeparator node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<TableBody>(TableBody.class, new CustomNodeFormatter<TableBody>(){

            @Override
            public void render(TableBody node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<TableRow>(TableRow.class, new CustomNodeFormatter<TableRow>(){

            @Override
            public void render(TableRow node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<TableCell>(TableCell.class, new CustomNodeFormatter<TableCell>(){

            @Override
            public void render(TableCell node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<TableCaption>(TableCaption.class, new CustomNodeFormatter<TableCaption>(){

            @Override
            public void render(TableCaption node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<Text>(Text.class, new CustomNodeFormatter<Text>(){

            @Override
            public void render(Text node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        })));
    }

    private void render(TableBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable = new MarkdownTable(this.options);
        switch (context.getRenderPurpose()) {
            case TRANSLATION_SPANS: 
            case TRANSLATED_SPANS: 
            case TRANSLATED: {
                markdown.blankLine();
                context.renderChildren(node);
                markdown.blankLine();
                break;
            }
            default: {
                Map<Integer, Integer> offsets;
                context.renderChildren(node);
                if (this.options.tableManipulator != TableManipulator.NULL) {
                    this.myTable.normalize();
                    this.options.tableManipulator.apply(this.myTable, node);
                }
                if (this.myTable.getMaxColumns() <= 0) break;
                markdown.blankLine();
                this.myTable.appendTable(markdown);
                markdown.blankLine();
                if (!this.options.dumpIntellijOffsets || (offsets = this.myTable.getTrackedOffsets()).size() <= 0) break;
                markdown.append("\nTracked Offsets").line();
                String sep = "  ";
                int i = 0;
                for (Map.Entry<Integer, Integer> offset : offsets.entrySet()) {
                    markdown.append(sep).append(String.format("%d:[%d,%d] was:[%d,%d]", ++i, offset.getValue(), offset.getValue() + 1, offset.getKey(), offset.getKey() + 1));
                    sep = " ";
                }
                markdown.append("\n");
            }
        }
        this.myTable = null;
    }

    private void render(TableHead node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable.setSeparator(false);
        this.myTable.setHeader(true);
        context.renderChildren(node);
    }

    private void render(TableSeparator node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable.setSeparator(true);
        context.renderChildren(node);
    }

    private void render(TableBody node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable.setSeparator(false);
        this.myTable.setHeader(false);
        context.renderChildren(node);
    }

    private void render(TableRow node, NodeFormatterContext context, MarkdownWriter markdown) {
        context.renderChildren(node);
        if (context.getRenderPurpose() == RenderPurpose.FORMAT) {
            if (!this.myTable.isSeparator()) {
                this.myTable.nextRow();
            }
        } else {
            markdown.line();
        }
    }

    private void render(TableCaption node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.getRenderPurpose() == RenderPurpose.FORMAT) {
            this.myTable.setCaptionWithMarkers(node.getOpeningMarker(), node.getText(), node.getClosingMarker());
        } else {
            String dummyCaption = node.hasChildren() ? "dummy" : "";
            String formattedCaption = MarkdownTable.formattedCaption(BasedSequenceImpl.of(dummyCaption), this.options);
            if (formattedCaption != null) {
                markdown.line().append(node.getOpeningMarker());
                context.renderChildren(node);
                markdown.append(node.getClosingMarker()).line();
            }
        }
    }

    private void render(final TableCell node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.getRenderPurpose() == RenderPurpose.FORMAT) {
            BasedSequence text = node.getText();
            if (this.options.trimCellWhitespace) {
                text = text.isBlank() && !text.isEmpty() ? text.subSequence(0, 1) : text.trim();
            }
            this.myTable.addCell(new com.vladsch.flexmark.util.format.TableCell(node.getOpeningMarker(), text, node.getClosingMarker(), 1, node.getSpan(), node.getAlignment() == null ? CellAlignment.NONE : node.getAlignment().cellAlignment()));
        } else {
            if (node.getPrevious() == null) {
                if (this.options.leadTrailPipes && node.getOpeningMarker().isEmpty()) {
                    markdown.append('|');
                } else {
                    markdown.append(node.getOpeningMarker());
                }
            } else {
                markdown.append(node.getOpeningMarker());
            }
            if (!this.myTable.isSeparator() && this.options.spaceAroundPipes && (!node.getText().startsWith(" ") || this.parserTrimCellWhiteSpace)) {
                markdown.append(' ');
            }
            final String[] childText = new String[]{""};
            context.translatingSpan(new TranslatingSpanRender(){

                @Override
                public void render(NodeFormatterContext context, MarkdownWriter writer) {
                    context.renderChildren(node);
                    childText[0] = writer.getText();
                }
            });
            if (!this.myTable.isSeparator() && this.options.spaceAroundPipes && (!childText[0].endsWith(" ") || this.parserTrimCellWhiteSpace)) {
                markdown.append(' ');
            }
            if (node.getNext() == null) {
                if (this.options.leadTrailPipes && node.getClosingMarker().isEmpty()) {
                    markdown.append('|');
                } else {
                    markdown.append(node.getClosingMarker());
                }
            } else {
                markdown.append(node.getClosingMarker());
            }
        }
    }

    private void render(Text node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (this.myTable != null && this.myTable.isSeparator()) {
            Node parent = node.getAncestorOfType(Paragraph.class);
            if (parent instanceof Paragraph && ((Paragraph)parent).hasTableSeparator()) {
                markdown.pushPrefix().addPrefix(" ").append(node.getChars()).popPrefix();
            } else {
                markdown.append(node.getChars());
            }
        } else {
            markdown.append(node.getChars());
        }
    }

    public static class Factory
    implements NodeFormatterFactory {
        @Override
        public NodeFormatter create(DataHolder options) {
            return new TableNodeFormatter(options);
        }
    }
}

