/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.admonition.internal;

import com.vladsch.flexmark.ext.admonition.AdmonitionBlock;
import com.vladsch.flexmark.ext.admonition.internal.AdmonitionCollectingVisitor;
import com.vladsch.flexmark.ext.admonition.internal.AdmonitionOptions;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.PhasedNodeRenderer;
import com.vladsch.flexmark.html.renderer.RenderingPhase;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class AdmonitionNodeRenderer
implements PhasedNodeRenderer {
    public static AttributablePart ADMONITION_SVG_OBJECT_PART = new AttributablePart("ADMONITION_SVG_OBJECT_PART");
    public static AttributablePart ADMONITION_HEADING_PART = new AttributablePart("ADMONITION_HEADING_PART");
    public static AttributablePart ADMONITION_ICON_PART = new AttributablePart("ADMONITION_ICON_PART");
    public static AttributablePart ADMONITION_TITLE_PART = new AttributablePart("ADMONITION_TITLE_PART");
    public static AttributablePart ADMONITION_BODY_PART = new AttributablePart("ADMONITION_BODY_PART");
    private final AdmonitionOptions options;

    public AdmonitionNodeRenderer(DataHolder options) {
        this.options = new AdmonitionOptions(options);
    }

    @Override
    public Set<RenderingPhase> getRenderingPhases() {
        LinkedHashSet<RenderingPhase> phaseSet = new LinkedHashSet<RenderingPhase>();
        phaseSet.add(RenderingPhase.BODY_TOP);
        return phaseSet;
    }

    @Override
    public void renderDocument(NodeRendererContext context, HtmlWriter html, Document document, RenderingPhase phase) {
        if (phase == RenderingPhase.BODY_TOP) {
            HashSet<String> resolvedQualifiers = new HashSet<String>();
            Set<String> referencedQualifiers = new AdmonitionCollectingVisitor().collectAndGetQualifiers(document);
            for (String qualifier : referencedQualifiers) {
                String resolvedQualifier = this.options.qualifierTypeMap.get(qualifier);
                if (resolvedQualifier == null) {
                    resolvedQualifier = this.options.unresolvedQualifier;
                }
                resolvedQualifiers.add(resolvedQualifier);
            }
            if (!resolvedQualifiers.isEmpty()) {
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)html.line()).attr("xmlns", "http://www.w3.org/2000/svg")).attr("class", "adm-hidden")).withAttr(ADMONITION_SVG_OBJECT_PART).tag("svg")).indent()).line();
                for (String info : resolvedQualifiers) {
                    String svgContent = this.options.typeSvgMap.get(info);
                    if (svgContent == null || svgContent.isEmpty()) continue;
                    ((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)html.raw("<symbol id=\"adm-")).raw(info)).raw("\">")).indent()).line()).raw(svgContent)).line()).unIndent()).raw("</symbol>")).line();
                }
                ((HtmlWriter)((HtmlWriter)html.unIndent()).closeTag("svg")).line();
            }
        }
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler<AdmonitionBlock>(AdmonitionBlock.class, new CustomNodeRenderer<AdmonitionBlock>(){

            @Override
            public void render(AdmonitionBlock node, NodeRendererContext context, HtmlWriter html) {
                AdmonitionNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(AdmonitionBlock node, NodeRendererContext context, HtmlWriter html) {
        String title;
        String info = node.getInfo().toString().toLowerCase();
        String type = this.options.qualifierTypeMap.get(info);
        if (type == null) {
            type = this.options.unresolvedQualifier;
        }
        if (node.getTitle().isNull()) {
            title = this.options.qualifierTitleMap.get(info);
            if (title == null) {
                title = info.substring(0, 1).toUpperCase() + info.substring(1);
            }
        } else {
            title = node.getTitle().toString();
        }
        String openClose = node.getOpeningMarker().equals("???") ? " adm-collapsed" : (node.getOpeningMarker().equals("???+") ? "adm-open" : null);
        if (title.isEmpty()) {
            ((HtmlWriter)((HtmlWriter)html.srcPos(node.getChars()).withAttr().attr("class", "adm-block")).attr("class", "adm-" + type)).tag("div", false).line();
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.attr("class", "adm-body")).withAttr(ADMONITION_BODY_PART).tag("div")).indent()).line();
            context.renderChildren(node);
            ((HtmlWriter)((HtmlWriter)html.unIndent()).closeTag("div")).line();
            ((HtmlWriter)html.closeTag("div")).line();
        } else {
            ((HtmlWriter)html.srcPos(node.getChars()).attr("class", "adm-block")).attr("class", "adm-" + type);
            if (openClose != null) {
                ((HtmlWriter)html.attr("class", openClose)).attr("class", "adm-" + type);
            }
            html.withAttr().tag("div", false).line();
            ((HtmlWriter)((HtmlWriter)html.attr("class", "adm-heading")).withAttr(ADMONITION_HEADING_PART).tag("div")).line();
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)html.attr("class", "adm-icon")).withAttr(ADMONITION_ICON_PART).tag("svg")).raw("<use xlink:href=\"#adm-")).raw(type)).raw("\" />")).closeTag("svg");
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.withAttr(ADMONITION_TITLE_PART).tag("span")).text(title)).closeTag("span")).line();
            ((HtmlWriter)html.closeTag("div")).line();
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.attr("class", "adm-body")).withAttr(ADMONITION_BODY_PART).tag("div")).indent()).line();
            context.renderChildren(node);
            ((HtmlWriter)((HtmlWriter)html.unIndent()).closeTag("div")).line();
            ((HtmlWriter)html.closeTag("div")).line();
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        public NodeRenderer create(DataHolder options) {
            return new AdmonitionNodeRenderer(options);
        }
    }
}

