/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.autolink.internal;

import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.InlineTextParserExtension;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Range;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AutoLinkInlineParserExtensionBase
implements InlineTextParserExtension {
    public static final Pattern EMAIL_AUTOLINK = Pattern.compile("(?:\\\\?[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-])+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+", 8);
    public static final Pattern AUTOLINK = Pattern.compile("[a-zA-Z][a-zA-Z0-9.+-]{1,31}://[^<>\u0000- ]+", 8);
    public static final Pattern WEBSITE_AUTOLINK = Pattern.compile("www\\.[^<>\u0000- ]+", 8);
    private final Pattern ignoredLinks;

    public AutoLinkInlineParserExtensionBase(InlineParser inlineParser) {
        String ignoreLinks = AutolinkExtension.IGNORE_LINKS.getFrom(inlineParser.getDocument());
        this.ignoredLinks = ignoreLinks.isEmpty() ? null : Pattern.compile(ignoreLinks);
    }

    protected boolean isIgnoredLinkPrefix(CharSequence url) {
        if (this.ignoredLinks != null) {
            Matcher matcher = this.ignoredLinks.matcher(url);
            return matcher.matches();
        }
        return false;
    }

    protected abstract Pattern getPattern();

    protected abstract Node getAutoLinkNode(BasedSequence var1);

    @Override
    public Range getWantedRange(BasedSequence text, int textIndex) {
        Matcher matcher = this.getPattern().matcher(text);
        matcher.region(textIndex, text.length());
        if (matcher.find()) {
            char c;
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            if (startIndex > 0 && (Character.isUnicodeIdentifierPart(c = text.charAt(startIndex - 1)) || c == '-' || c == '.' || c == '@' || c == ':')) {
                return null;
            }
            if (!this.isIgnoredLinkPrefix(text.subSequence(startIndex, endIndex))) {
                int bracketStartOffset = startIndex;
                while (endIndex > startIndex) {
                    char c2 = text.charAt(endIndex - 1);
                    if (c2 == ')' || c2 == '}') {
                        String pending = String.valueOf(c2);
                        ArrayList<Integer> offsets = new ArrayList<Integer>();
                        offsets.add(endIndex);
                        int lastMatchedBracket = bracketStartOffset;
                        for (int pos = endIndex - 1; pos > bracketStartOffset; --pos) {
                            c2 = text.charAt(pos - 1);
                            if (c2 == '(' && pending.charAt(0) == ')' || c2 == '{' && pending.charAt(0) == '}') {
                                pending = pending.substring(1);
                                int removed = (Integer)offsets.remove(0);
                                if (lastMatchedBracket < removed) {
                                    lastMatchedBracket = removed;
                                }
                                if (!pending.isEmpty()) continue;
                                break;
                            }
                            if (c2 == ')' || c2 == '}') {
                                pending = String.format("%s%s", String.valueOf(c2), pending);
                                offsets.add(0, pos);
                                continue;
                            }
                            if (c2 == '.' || c2 == ' ' || c2 == '\t' || c2 == ';' || c2 == ':' || lastMatchedBracket >= pos) continue;
                            lastMatchedBracket = pos;
                        }
                        if (lastMatchedBracket >= endIndex) break;
                        endIndex = lastMatchedBracket;
                        continue;
                    }
                    if (c2 != '.' && c2 != ' ' && c2 != '\t' && c2 != ';' && c2 != ':') break;
                    --endIndex;
                }
                if (endIndex > startIndex) {
                    return Range.of(startIndex, endIndex);
                }
            }
        }
        return null;
    }

    @Override
    public void createNode(Node block, BasedSequence text, Range range) {
        Node linkNode = this.getAutoLinkNode(text);
        linkNode.setCharsFromContent();
        Text contentNode = new Text(text);
        linkNode.appendChild(contentNode);
        block.appendChild(linkNode);
    }
}

