/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.users.internal;

import com.vladsch.flexmark.ext.gfm.users.GfmUser;
import com.vladsch.flexmark.ext.gfm.users.internal.GfmUsersOptions;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashSet;
import java.util.Set;

public class GfmUsersNodeRenderer
implements NodeRenderer {
    private final GfmUsersOptions options;

    public GfmUsersNodeRenderer(DataHolder options) {
        this.options = new GfmUsersOptions(options);
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler<GfmUser>(GfmUser.class, new CustomNodeRenderer<GfmUser>(){

            @Override
            public void render(GfmUser node, NodeRendererContext context, HtmlWriter html) {
                GfmUsersNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(GfmUser node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            html.text(node.getChars());
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(this.options.gitHubIssuesUrlRoot).append(this.options.gitHubIssueUrlPrefix).append(node.getText()).append(this.options.gitHubIssueUrlSuffix);
            ((HtmlWriter)html.srcPos(node.getChars()).attr("href", sb.toString())).withAttr().tag("a");
            html.raw(this.options.gitHubUserTextPrefix);
            html.text(node.getChars());
            html.raw(this.options.gitHubUserTextSuffix);
            html.tag("/a");
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        public NodeRenderer create(DataHolder options) {
            return new GfmUsersNodeRenderer(options);
        }
    }
}

