/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.aside.internal;

import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.ext.aside.AsideBlock;
import com.vladsch.flexmark.ext.aside.AsideExtension;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.core.FencedCodeBlockParser;
import com.vladsch.flexmark.parser.core.HeadingParser;
import com.vladsch.flexmark.parser.core.HtmlBlockParser;
import com.vladsch.flexmark.parser.core.IndentedCodeBlockParser;
import com.vladsch.flexmark.parser.core.ListBlockParser;
import com.vladsch.flexmark.parser.core.ThematicBreakParser;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class AsideBlockParser
extends AbstractBlockParser {
    private final AsideBlock block = new AsideBlock();
    private final boolean continueToBlankLine;
    private final boolean ignoreBlankLine;
    private int lastWasBlankLine = 0;

    public AsideBlockParser(DataHolder options, BasedSequence marker) {
        this.block.setOpeningMarker(marker);
        this.continueToBlankLine = options.get(AsideExtension.EXTEND_TO_BLANK_LINE);
        this.ignoreBlankLine = options.get(AsideExtension.IGNORE_BLANK_LINE);
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean isPropagatingLastBlankLine(BlockParser lastMatchedBlockParser) {
        return false;
    }

    @Override
    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        return true;
    }

    @Override
    public AsideBlock getBlock() {
        return this.block;
    }

    @Override
    public void closeBlock(ParserState state) {
        this.block.setCharsFromContent();
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        int nextNonSpace = state.getNextNonSpaceIndex();
        boolean isMarker = false;
        if (!state.isBlank() && ((isMarker = AsideBlockParser.isMarker(state, nextNonSpace)) || this.continueToBlankLine && this.lastWasBlankLine == 0)) {
            int newColumn = state.getColumn() + state.getIndent();
            this.lastWasBlankLine = 0;
            if (isMarker) {
                ++newColumn;
                if (Parsing.isSpaceOrTab(state.getLine(), nextNonSpace + 1)) {
                    ++newColumn;
                }
            }
            return BlockContinue.atColumn(newColumn);
        }
        if (this.ignoreBlankLine && state.isBlank()) {
            ++this.lastWasBlankLine;
            int newColumn = state.getColumn() + state.getIndent();
            return BlockContinue.atColumn(newColumn);
        }
        return BlockContinue.none();
    }

    static boolean isMarker(ParserState state, int index) {
        BasedSequence line = state.getLine();
        return state.getIndent() < state.getParsing().CODE_BLOCK_INDENT && index < line.length() && line.charAt(index) == '|';
    }

    static boolean endsWithMarker(BasedSequence line) {
        int tailBlanks = line.countTrailing(" \t\r\n\u00a0");
        return tailBlanks + 1 < line.length() && line.charAt(line.length() - tailBlanks - 1) == '|';
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        BlockFactory(DataHolder options) {
            super(options);
        }

        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            int nextNonSpace = state.getNextNonSpaceIndex();
            if (AsideBlockParser.isMarker(state, nextNonSpace) && !AsideBlockParser.endsWithMarker(state.getLine())) {
                int newColumn = state.getColumn() + state.getIndent() + 1;
                if (Parsing.isSpaceOrTab(state.getLine(), nextNonSpace + 1)) {
                    ++newColumn;
                }
                return BlockStart.of(new AsideBlockParser(state.getProperties(), state.getLine().subSequence(nextNonSpace, nextNonSpace + 1))).atColumn(newColumn);
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        @Override
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            HashSet<Class<? extends CustomBlockParserFactory>> set = new HashSet<Class<? extends CustomBlockParserFactory>>();
            return set;
        }

        @Override
        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return new HashSet<Class<? extends CustomBlockParserFactory>>(Arrays.asList(HeadingParser.Factory.class, FencedCodeBlockParser.Factory.class, HtmlBlockParser.Factory.class, ThematicBreakParser.Factory.class, ListBlockParser.Factory.class, IndentedCodeBlockParser.Factory.class));
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        public BlockParserFactory create(DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

