/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference.internal;

import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBase;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBlock;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceLink;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceText;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumeratedReferenceRepository;
import com.vladsch.flexmark.parser.LinkRefProcessor;
import com.vladsch.flexmark.parser.LinkRefProcessorFactory;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class EnumeratedReferenceLinkRefProcessor
implements LinkRefProcessor {
    static final boolean WANT_EXCLAMATION_PREFIX = false;
    static final int BRACKET_NESTING_LEVEL = 0;
    private final EnumeratedReferenceRepository enumeratedReferenceRepository;

    public EnumeratedReferenceLinkRefProcessor(Document document) {
        this.enumeratedReferenceRepository = document.get(EnumeratedReferenceExtension.ENUMERATED_REFERENCES);
    }

    @Override
    public boolean getWantExclamationPrefix() {
        return false;
    }

    @Override
    public int getBracketNestingLevel() {
        return 0;
    }

    @Override
    public boolean isMatch(BasedSequence nodeChars) {
        return !(nodeChars.length() < 3 || nodeChars.charAt(0) != '[' || nodeChars.charAt(1) != '@' && nodeChars.charAt(1) != '#' || nodeChars.endCharAt(1) != ']' || nodeChars.length() != 3 && Character.isDigit(nodeChars.charAt(2)));
    }

    @Override
    public Node createNode(BasedSequence nodeChars) {
        EnumeratedReferenceBlock enumeratedReferenceBlock;
        BasedSequence enumeratedReferenceId = nodeChars.midSequence(2, -1).trim();
        EnumeratedReferenceBlock enumeratedReferenceBlock2 = enumeratedReferenceBlock = enumeratedReferenceId.length() > 0 ? (EnumeratedReferenceBlock)this.enumeratedReferenceRepository.get(enumeratedReferenceId.toString()) : null;
        if (nodeChars.charAt(1) == '@') {
            EnumeratedReferenceLink enumeratedReference = new EnumeratedReferenceLink(nodeChars.subSequence(0, 2), enumeratedReferenceId, nodeChars.endSequence(1));
            enumeratedReference.setEnumeratedReferenceBlock(enumeratedReferenceBlock);
            return enumeratedReference;
        }
        EnumeratedReferenceText enumeratedReferenceText = new EnumeratedReferenceText(nodeChars.subSequence(0, 2), enumeratedReferenceId, nodeChars.endSequence(1));
        enumeratedReferenceText.setEnumeratedReferenceBlock(enumeratedReferenceBlock);
        return enumeratedReferenceText;
    }

    @Override
    public BasedSequence adjustInlineText(Document document, Node node) {
        assert (node instanceof EnumeratedReferenceBase);
        return ((EnumeratedReferenceBase)node).getText();
    }

    @Override
    public boolean allowDelimiters(BasedSequence chars, Document document, Node node) {
        return true;
    }

    @Override
    public void updateNodeElements(Document document, Node node) {
    }

    public static class Factory
    implements LinkRefProcessorFactory {
        @Override
        public LinkRefProcessor create(Document document) {
            return new EnumeratedReferenceLinkRefProcessor(document);
        }

        @Override
        public boolean getWantExclamationPrefix(DataHolder options) {
            return false;
        }

        @Override
        public int getBracketNestingLevel(DataHolder options) {
            return 0;
        }
    }
}

