/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.tasklist;

import com.vladsch.flexmark.ast.BlockContent;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.OrderedListItem;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.List;

public class TaskListItem
extends ListItem {
    protected boolean isOrderedItem = false;

    @Override
    public void getAstExtra(StringBuilder out) {
        super.getAstExtra(out);
        if (this.isOrderedItem) {
            out.append(" isOrderedItem");
        }
        out.append(this.isItemDoneMarker() ? " isDone" : " isNotDone");
    }

    @Override
    public boolean isParagraphWrappingDisabled(Paragraph node, ListOptions listOptions, DataHolder options) {
        Node child;
        assert (node.getParent() == this);
        for (child = this.getFirstChild(); child != null && !(child instanceof Paragraph); child = child.getNext()) {
        }
        return child == node;
    }

    public TaskListItem() {
    }

    public TaskListItem(BasedSequence chars) {
        super(chars);
    }

    public TaskListItem(BasedSequence chars, List<BasedSequence> segments) {
        super(chars, segments);
    }

    public TaskListItem(BlockContent blockContent) {
        super(blockContent);
    }

    public TaskListItem(ListItem block) {
        super(block);
        this.isOrderedItem = block instanceof OrderedListItem;
    }

    @Override
    public void setOpeningMarker(BasedSequence openingMarker) {
        throw new IllegalStateException();
    }

    public boolean isItemDoneMarker() {
        return !this.markerSuffix.matches("[ ]");
    }

    public boolean isOrderedItem() {
        return this.isOrderedItem;
    }

    public void setOrderedItem(boolean orderedItem) {
        this.isOrderedItem = orderedItem;
    }
}

