/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.footnotes;

import com.vladsch.flexmark.ast.CustomBlock;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.ParagraphItemContainer;
import com.vladsch.flexmark.ast.ReferenceNode;
import com.vladsch.flexmark.ext.footnotes.Footnote;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteRepository;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class FootnoteBlock
extends CustomBlock
implements ReferenceNode<FootnoteRepository, FootnoteBlock, Footnote>,
ParagraphItemContainer {
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence text = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;
    protected BasedSequence footnote = BasedSequence.NULL;
    private int footnoteOrdinal = 0;
    private int firstReferenceOffset = Integer.MAX_VALUE;
    private int footnoteReferences = 0;

    @Override
    public int compareTo(FootnoteBlock other) {
        return this.getText().compareTo(other.getText());
    }

    public int getFootnoteReferences() {
        return this.footnoteReferences;
    }

    public void setFootnoteReferences(int footnoteReferences) {
        this.footnoteReferences = footnoteReferences;
    }

    @Override
    public Footnote getReferencingNode(Node node) {
        return node instanceof Footnote ? (Footnote)node : null;
    }

    public int getFirstReferenceOffset() {
        return this.firstReferenceOffset;
    }

    public void setFirstReferenceOffset(int firstReferenceOffset) {
        this.firstReferenceOffset = firstReferenceOffset;
    }

    public void addFirstReferenceOffset(int firstReferenceOffset) {
        if (this.firstReferenceOffset < firstReferenceOffset) {
            this.firstReferenceOffset = firstReferenceOffset;
        }
    }

    public boolean isReferenced() {
        return this.firstReferenceOffset < Integer.MAX_VALUE;
    }

    public int getFootnoteOrdinal() {
        return this.footnoteOrdinal;
    }

    public void setFootnoteOrdinal(int footnoteOrdinal) {
        this.footnoteOrdinal = footnoteOrdinal;
    }

    @Override
    public void getAstExtra(StringBuilder out) {
        out.append(" ordinal: " + this.footnoteOrdinal + " ");
        FootnoteBlock.segmentSpan(out, this.openingMarker, "open");
        FootnoteBlock.segmentSpan(out, this.text, "text");
        FootnoteBlock.segmentSpan(out, this.closingMarker, "close");
        FootnoteBlock.segmentSpan(out, this.footnote, "footnote");
    }

    @Override
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.text, this.closingMarker, this.footnote};
    }

    public FootnoteBlock() {
    }

    public FootnoteBlock(BasedSequence chars) {
        super(chars);
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    public BasedSequence getText() {
        return this.text;
    }

    public void setText(BasedSequence text) {
        this.text = text;
    }

    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }

    public BasedSequence getFootnote() {
        return this.footnote;
    }

    public void setFootnote(BasedSequence footnote) {
        this.footnote = footnote;
    }

    @Override
    public boolean isItemParagraph(Paragraph node) {
        return node == this.getFirstChild();
    }

    @Override
    public boolean isParagraphWrappingDisabled(Paragraph node, ListOptions listOptions, DataHolder options) {
        return false;
    }
}

