/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter;

import com.vladsch.flexmark.formatter.ExplicitAttributeIdProvider;
import com.vladsch.flexmark.formatter.FormattingPhase;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.MergeContext;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormatterSubContext;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.PhasedNodeFormatter;
import com.vladsch.flexmark.formatter.RenderPurpose;
import com.vladsch.flexmark.formatter.TranslatingSpanRender;
import com.vladsch.flexmark.formatter.TranslationHandler;
import com.vladsch.flexmark.formatter.TranslationHandlerFactory;
import com.vladsch.flexmark.formatter.TranslationPlaceholderGenerator;
import com.vladsch.flexmark.formatter.internal.CoreNodeFormatter;
import com.vladsch.flexmark.formatter.internal.FormatterOptions;
import com.vladsch.flexmark.formatter.internal.MergeContextImpl;
import com.vladsch.flexmark.formatter.internal.MergeLinkResolver;
import com.vladsch.flexmark.formatter.internal.TranslationHandlerImpl;
import com.vladsch.flexmark.html.AttributeProviderFactory;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.renderer.HeaderIdGenerator;
import com.vladsch.flexmark.html.renderer.HeaderIdGeneratorFactory;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.html.renderer.HtmlIdGeneratorFactory;
import com.vladsch.flexmark.html.renderer.LinkResolverContext;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.IRender;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeCollectingVisitor;
import com.vladsch.flexmark.util.builder.BuilderBase;
import com.vladsch.flexmark.util.builder.Extension;
import com.vladsch.flexmark.util.collection.SubClassingBag;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.DataSet;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.data.ScopedDataSet;
import com.vladsch.flexmark.util.dependency.DependencyHandler;
import com.vladsch.flexmark.util.dependency.FlatDependencyHandler;
import com.vladsch.flexmark.util.dependency.ResolvedDependencies;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.format.options.BlockQuoteMarker;
import com.vladsch.flexmark.util.format.options.CodeFenceMarker;
import com.vladsch.flexmark.util.format.options.DiscretionaryText;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import com.vladsch.flexmark.util.format.options.EqualizeTrailingMarker;
import com.vladsch.flexmark.util.format.options.ListBulletMarker;
import com.vladsch.flexmark.util.format.options.ListNumberedMarker;
import com.vladsch.flexmark.util.format.options.ListSpacing;
import com.vladsch.flexmark.util.format.options.TableCaptionHandling;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.mappers.CharWidthProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public class Formatter
implements IRender {
    public static final DataKey<Integer> FORMAT_FLAGS = new DataKey("FORMAT_FLAGS", (Object)0);
    public static final int FORMAT_CONVERT_TABS = 1;
    public static final int FORMAT_COLLAPSE_WHITESPACE = 2;
    public static final int FORMAT_SUPPRESS_TRAILING_WHITESPACE = 4;
    public static final int FORMAT_ALL_OPTIONS = 7;
    public static final DataKey<Integer> MAX_BLANK_LINES = new DataKey("MAX_BLANK_LINES", (Object)2);
    public static final DataKey<Integer> MAX_TRAILING_BLANK_LINES = new DataKey("MAX_TRAILING_BLANK_LINES", (Object)1);
    public static final DataKey<DiscretionaryText> SPACE_AFTER_ATX_MARKER = new DataKey("SPACE_AFTER_ATX_MARKER", (Object)DiscretionaryText.ADD);
    public static final DataKey<Boolean> SETEXT_HEADER_EQUALIZE_MARKER = new DataKey("SETEXT_HEADER_EQUALIZE_MARKER", (Object)true);
    public static final DataKey<EqualizeTrailingMarker> ATX_HEADER_TRAILING_MARKER = new DataKey("ATX_HEADER_TRAILING_MARKER", (Object)EqualizeTrailingMarker.AS_IS);
    public static final DataKey<String> THEMATIC_BREAK = new DataKey("THEMATIC_BREAK", (Object)null);
    public static final DataKey<Boolean> BLOCK_QUOTE_BLANK_LINES = new DataKey("BLOCK_QUOTE_BLANK_LINES", (Object)true);
    public static final DataKey<BlockQuoteMarker> BLOCK_QUOTE_MARKERS = new DataKey("BLOCK_QUOTE_MARKERS", (Object)BlockQuoteMarker.ADD_COMPACT_WITH_SPACE);
    public static final DataKey<Boolean> INDENTED_CODE_MINIMIZE_INDENT = new DataKey("INDENTED_CODE_MINIMIZE_INDENT", (Object)true);
    public static final DataKey<Boolean> FENCED_CODE_MINIMIZE_INDENT = new DataKey("FENCED_CODE_MINIMIZE_INDENT", (Object)true);
    public static final DataKey<Boolean> FENCED_CODE_MATCH_CLOSING_MARKER = new DataKey("FENCED_CODE_MATCH_CLOSING_MARKER", (Object)true);
    public static final DataKey<Boolean> FENCED_CODE_SPACE_BEFORE_INFO = new DataKey("FENCED_CODE_SPACE_BEFORE_INFO", (Object)false);
    public static final DataKey<Integer> FENCED_CODE_MARKER_LENGTH = new DataKey("FENCED_CODE_MARKER_LENGTH", (Object)3);
    public static final DataKey<CodeFenceMarker> FENCED_CODE_MARKER_TYPE = new DataKey("FENCED_CODE_MARKER_TYPE", (Object)CodeFenceMarker.ANY);
    public static final DataKey<Boolean> LIST_ADD_BLANK_LINE_BEFORE = new DataKey("LIST_ADD_BLANK_LINE_BEFORE", (Object)false);
    public static final DataKey<Boolean> LIST_RENUMBER_ITEMS = new DataKey("LIST_RENUMBER_ITEMS", (Object)true);
    public static final DataKey<Boolean> LIST_REMOVE_EMPTY_ITEMS = new DataKey("LIST_REMOVE_EMPTY_ITEMS", (Object)false);
    public static final DataKey<ListBulletMarker> LIST_BULLET_MARKER = new DataKey("LIST_BULLET_MARKER", (Object)ListBulletMarker.ANY);
    public static final DataKey<ListNumberedMarker> LIST_NUMBERED_MARKER = new DataKey("LIST_NUMBERED_MARKER", (Object)ListNumberedMarker.ANY);
    public static final DataKey<ListSpacing> LIST_SPACING = new DataKey("LIST_SPACING", (Object)ListSpacing.AS_IS);
    public static final DataKey<ElementPlacement> REFERENCE_PLACEMENT = new DataKey("REFERENCE_PLACEMENT", (Object)ElementPlacement.AS_IS);
    public static final DataKey<ElementPlacementSort> REFERENCE_SORT = new DataKey("REFERENCE_SORT", (Object)ElementPlacementSort.AS_IS);
    public static final DataKey<Boolean> KEEP_IMAGE_LINKS_AT_START = new DataKey("KEEP_IMAGE_LINKS_AT_START", (Object)false);
    public static final DataKey<Boolean> KEEP_EXPLICIT_LINKS_AT_START = new DataKey("KEEP_EXPLICIT_LINKS_AT_START", (Object)false);
    public static final DataKey<Boolean> OPTIMIZED_INLINE_RENDERING = new DataKey("OPTIMIZED_INLINE_RENDERING", (Object)false);
    public static final DataKey<CharWidthProvider> FORMAT_CHAR_WIDTH_PROVIDER = TableFormatOptions.FORMAT_CHAR_WIDTH_PROVIDER;
    @Deprecated
    public static final DataKey<CharWidthProvider> CHAR_WIDTH_PROVIDER = TableFormatOptions.FORMAT_CHAR_WIDTH_PROVIDER;
    public static final DataKey<TableCaptionHandling> FORMAT_TABLE_CAPTION = TableFormatOptions.FORMAT_TABLE_CAPTION;
    public static final DataKey<DiscretionaryText> FORMAT_TABLE_CAPTION_SPACES = TableFormatOptions.FORMAT_TABLE_CAPTION_SPACES;
    public static final DataKey<String> FORMAT_TABLE_INDENT_PREFIX = TableFormatOptions.FORMAT_TABLE_INDENT_PREFIX;
    public static final DataKey<ParserEmulationProfile> FORMATTER_EMULATION_PROFILE = new DataKey("FORMATTER_EMULATION_PROFILE", Parser.PARSER_EMULATION_PROFILE);
    public static final DataKey<String> TRANSLATION_ID_FORMAT = new DataKey("TRANSLATION_ID_FORMAT", (Object)"_%d_");
    public static final DataKey<String> TRANSLATION_HTML_BLOCK_PREFIX = new DataKey("TRANSLATION_HTML_BLOCK_PREFIX", (Object)"_");
    public static final DataKey<String> TRANSLATION_EXCLUDE_PATTERN = new DataKey("TRANSLATION_EXCLUDE_PATTERN", (Object)"^[^\\p{IsAlphabetic}]*$");
    public static final DataKey<String> TRANSLATION_HTML_BLOCK_TAG_PATTERN = Parser.TRANSLATION_HTML_BLOCK_TAG_PATTERN;
    public static final DataKey<String> TRANSLATION_HTML_INLINE_TAG_PATTERN = Parser.TRANSLATION_HTML_INLINE_TAG_PATTERN;
    public static final DataKey<Boolean> KEEP_HARD_LINE_BREAKS = new DataKey("KEEP_HARD_LINE_BREAKS", (Object)true);
    public static final DataKey<Boolean> KEEP_SOFT_LINE_BREAKS = new DataKey("KEEP_SOFT_LINE_BREAKS", (Object)true);
    public static final DataKey<Boolean> APPEND_TRANSFERRED_REFERENCES = new DataKey("APPEND_TRANSFERRED_REFERENCES", (Object)false);
    private static final Document[] EMPTY_DOCUMENTS = new Document[0];
    public static final DataKey<String> DOC_RELATIVE_URL = new DataKey("DOC_RELATIVE_URL", (Object)"");
    public static final DataKey<String> DOC_ROOT_URL = new DataKey("DOC_ROOT_URL", (Object)"");
    public static final DataKey<Boolean> DEFAULT_LINK_RESOLVER = new DataKey("DEFAULT_LINK_RESOLVER", (Object)false);
    final FormatterOptions formatterOptions;
    private final DataHolder options;
    private final Builder builder;
    final List<LinkResolverFactory> linkResolverFactories;
    private final NodeFormatterDependencies nodeFormatterFactories;
    private static final Iterator<? extends Node> NULL_ITERATOR = new Iterator<Node>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Node next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };
    public static final Iterable<? extends Node> NULL_ITERABLE = new Iterable<Node>(){

        @Override
        public Iterator<Node> iterator() {
            return null;
        }
    };

    private Formatter(Builder builder) {
        this.builder = new Builder(builder);
        this.options = new DataSet((DataHolder)builder);
        this.formatterOptions = new FormatterOptions(this.options);
        this.linkResolverFactories = FlatDependencyHandler.computeDependencies(builder.linkResolverFactories);
        this.nodeFormatterFactories = Formatter.calculateBlockPreProcessors(this.options, builder.nodeFormatterFactories);
    }

    public static NodeFormatterDependencies calculateBlockPreProcessors(DataHolder options, List<NodeFormatterFactory> formatterFactories) {
        ArrayList<NodeFormatterFactory> list = new ArrayList<NodeFormatterFactory>(formatterFactories);
        list.add(new CoreNodeFormatter.Factory());
        NodeFormatterDependencyHandler resolver = new NodeFormatterDependencyHandler();
        return (NodeFormatterDependencies)resolver.resolveDependencies(list);
    }

    public TranslationHandler getTranslationHandler(TranslationHandlerFactory translationHandlerFactory, HtmlIdGeneratorFactory idGeneratorFactory) {
        return translationHandlerFactory.create(this.options, this.formatterOptions, idGeneratorFactory);
    }

    public TranslationHandler getTranslationHandler(HtmlIdGeneratorFactory idGeneratorFactory) {
        return new TranslationHandlerImpl(this.options, this.formatterOptions, idGeneratorFactory);
    }

    public TranslationHandler getTranslationHandler() {
        return new TranslationHandlerImpl(this.options, this.formatterOptions, (HtmlIdGeneratorFactory)new HeaderIdGenerator.Factory());
    }

    public DataHolder getOptions() {
        return new DataSet((DataHolder)this.builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataHolder options) {
        return new Builder(options);
    }

    public void render(Node node, Appendable output) {
        MainNodeFormatter renderer = new MainNodeFormatter(this.options, new MarkdownWriter(this.formatterOptions.formatFlags), node.getDocument(), null);
        renderer.render(node);
        renderer.flushTo(output, this.formatterOptions.maxTrailingBlankLines);
    }

    public void render(Node node, Appendable output, int maxTrailingBlankLines) {
        MainNodeFormatter renderer = new MainNodeFormatter(this.options, new MarkdownWriter(this.formatterOptions.formatFlags), node.getDocument(), null);
        renderer.render(node);
        renderer.flushTo(output, maxTrailingBlankLines);
    }

    public String render(Node node) {
        StringBuilder sb = new StringBuilder();
        this.render(node, sb);
        return sb.toString();
    }

    public void translationRender(Node node, Appendable output, TranslationHandler translationHandler, RenderPurpose renderPurpose) {
        this.translationRender(node, output, this.formatterOptions.maxTrailingBlankLines, translationHandler, renderPurpose);
    }

    public String translationRender(Node node, TranslationHandler translationHandler, RenderPurpose renderPurpose) {
        StringBuilder sb = new StringBuilder();
        this.translationRender(node, sb, translationHandler, renderPurpose);
        return sb.toString();
    }

    public void translationRender(Node node, Appendable output, int maxTrailingBlankLines, TranslationHandler translationHandler, RenderPurpose renderPurpose) {
        translationHandler.setRenderPurpose(renderPurpose);
        MainNodeFormatter renderer = new MainNodeFormatter(this.options, new MarkdownWriter(this.formatterOptions.formatFlags), node.getDocument(), translationHandler);
        renderer.render(node);
        renderer.flushTo(output, maxTrailingBlankLines);
    }

    public void mergeRender(Document[] documents, Appendable output, HtmlIdGeneratorFactory idGeneratorFactory) {
        this.mergeRender(documents, output, this.formatterOptions.maxTrailingBlankLines, idGeneratorFactory);
    }

    public String mergeRender(Document[] documents, int maxTrailingBlankLines, HtmlIdGeneratorFactory idGeneratorFactory) {
        StringBuilder sb = new StringBuilder();
        this.mergeRender(documents, sb, maxTrailingBlankLines, idGeneratorFactory);
        return sb.toString();
    }

    public void mergeRender(Document[] documents, Appendable output, int maxTrailingBlankLines, HtmlIdGeneratorFactory idGeneratorFactory) {
        MutableDataSet mergeOptions = new MutableDataSet(this.options);
        TranslationHandler[] translationHandlers = new TranslationHandler[documents.length];
        List[] translationHandlersTexts = new List[documents.length];
        int iMax = documents.length;
        for (int i = 0; i < iMax; ++i) {
            translationHandlers[i] = this.getTranslationHandler((HtmlIdGeneratorFactory)(idGeneratorFactory == null ? new HeaderIdGenerator.Factory() : idGeneratorFactory));
        }
        MergeContextImpl mergeContext = new MergeContextImpl(documents, translationHandlers);
        mergeContext.forEachPrecedingDocument(null, (context, document, index) -> {
            TranslationHandler translationHandler = (TranslationHandler)context;
            translationHandler.setRenderPurpose(RenderPurpose.TRANSLATION_SPANS);
            MainNodeFormatter renderer = new MainNodeFormatter((DataHolder)mergeOptions, new MarkdownWriter(this.formatterOptions.formatFlags), document, translationHandler);
            renderer.render((Node)document);
            translationHandlersTexts[index] = translationHandler.getTranslatingTexts();
        });
        Document[] translatedDocuments = new Document[documents.length];
        mergeContext.forEachPrecedingDocument(null, (context, document, index) -> {
            TranslationHandler translationHandler = (TranslationHandler)context;
            translationHandler.setRenderPurpose(RenderPurpose.TRANSLATED_SPANS);
            translationHandler.setTranslatedTexts(translationHandlersTexts[index]);
            MainNodeFormatter renderer = new MainNodeFormatter((DataHolder)mergeOptions, new MarkdownWriter(this.formatterOptions.formatFlags), document, translationHandler);
            renderer.render((Node)document);
            StringBuilder sb = new StringBuilder();
            renderer.flushTo(sb, maxTrailingBlankLines);
            translatedDocuments[index] = Parser.builder((DataHolder)this.options).build().parse(sb.toString());
        });
        mergeContext.setDocuments(translatedDocuments);
        mergeContext.forEachPrecedingDocument(null, (context, document, index) -> {
            TranslationHandler translationHandler = (TranslationHandler)context;
            translationHandler.setRenderPurpose(RenderPurpose.TRANSLATED);
            MainNodeFormatter renderer = new MainNodeFormatter((DataHolder)mergeOptions, new MarkdownWriter(this.formatterOptions.formatFlags), document, translationHandler);
            renderer.render((Node)document);
            renderer.flushTo(output, maxTrailingBlankLines);
        });
    }

    public Formatter withOptions(DataHolder options) {
        return options == null ? this : new Formatter(new Builder(this.builder, options));
    }

    private class MainNodeFormatter
    extends NodeFormatterSubContext {
        private final Document document;
        private final Map<Class, NodeFormattingHandler<?>> renderers;
        private final SubClassingBag<Node> collectedNodes;
        private final List<PhasedNodeFormatter> phasedFormatters;
        private final Set<FormattingPhase> renderingPhases;
        private final DataHolder options;
        private FormattingPhase phase;
        final TranslationHandler myTranslationHandler;
        private final LinkResolver[] myLinkResolvers;
        private final HashMap<LinkType, HashMap<String, ResolvedLink>> resolvedLinkMap;
        private final ExplicitAttributeIdProvider myExplicitAttributeIdProvider;

        MainNodeFormatter(DataHolder options, MarkdownWriter out, Document document, TranslationHandler translationHandler) {
            super(out);
            this.resolvedLinkMap = new HashMap();
            this.myTranslationHandler = translationHandler;
            this.options = new ScopedDataSet((DataHolder)document, options);
            this.document = document;
            this.renderers = new HashMap(32);
            this.renderingPhases = new HashSet<FormattingPhase>(FormattingPhase.values().length);
            HashSet collectNodeTypes = new HashSet(100);
            Boolean defaultLinkResolver = (Boolean)DEFAULT_LINK_RESOLVER.getFrom(options);
            this.myLinkResolvers = new LinkResolver[Formatter.this.linkResolverFactories.size() + (defaultLinkResolver != false ? 1 : 0)];
            for (int i = 0; i < Formatter.this.linkResolverFactories.size(); ++i) {
                this.myLinkResolvers[i] = Formatter.this.linkResolverFactories.get(i).apply((LinkResolverContext)this);
            }
            if (defaultLinkResolver.booleanValue()) {
                this.myLinkResolvers[Formatter.this.linkResolverFactories.size()] = new MergeLinkResolver.Factory().apply(this);
            }
            out.setContext(this);
            List<NodeFormatterFactory> formatterFactories = Formatter.this.nodeFormatterFactories.getNodeFactories();
            this.phasedFormatters = new ArrayList<PhasedNodeFormatter>(formatterFactories.size());
            ExplicitAttributeIdProvider explicitAttributeIdProvider = null;
            for (int i = formatterFactories.size() - 1; i >= 0; --i) {
                Set<NodeFormattingHandler<?>> formattingHandlers;
                NodeFormatterFactory nodeFormatterFactory = formatterFactories.get(i);
                NodeFormatter nodeFormatter = nodeFormatterFactory.create(this.options);
                if (nodeFormatter instanceof ExplicitAttributeIdProvider) {
                    explicitAttributeIdProvider = (ExplicitAttributeIdProvider)((Object)nodeFormatter);
                }
                if ((formattingHandlers = nodeFormatter.getNodeFormattingHandlers()) == null) continue;
                for (NodeFormattingHandler<?> nodeType : formattingHandlers) {
                    this.renderers.put(nodeType.getNodeType(), nodeType);
                }
                Set<Class<?>> nodeClasses = nodeFormatter.getNodeClasses();
                if (nodeClasses != null) {
                    collectNodeTypes.addAll(nodeClasses);
                }
                if (!(nodeFormatter instanceof PhasedNodeFormatter)) continue;
                Set<FormattingPhase> phases = ((PhasedNodeFormatter)nodeFormatter).getFormattingPhases();
                if (phases != null) {
                    if (phases.isEmpty()) {
                        throw new IllegalStateException("PhasedNodeFormatter with empty Phases");
                    }
                    this.renderingPhases.addAll(phases);
                    this.phasedFormatters.add((PhasedNodeFormatter)nodeFormatter);
                    continue;
                }
                throw new IllegalStateException("PhasedNodeFormatter with null Phases");
            }
            this.myExplicitAttributeIdProvider = explicitAttributeIdProvider;
            if (!collectNodeTypes.isEmpty()) {
                NodeCollectingVisitor collectingVisitor = new NodeCollectingVisitor(collectNodeTypes);
                collectingVisitor.collect((Node)document);
                this.collectedNodes = collectingVisitor.getSubClassingBag();
            } else {
                this.collectedNodes = null;
            }
        }

        public String encodeUrl(CharSequence url) {
            return String.valueOf(url);
        }

        public ResolvedLink resolveLink(LinkType linkType, CharSequence url, Boolean urlEncode) {
            return this.resolveLink(this, linkType, url, null, urlEncode);
        }

        public ResolvedLink resolveLink(LinkType linkType, CharSequence url, Attributes attributes, Boolean urlEncode) {
            return this.resolveLink(this, linkType, url, attributes, urlEncode);
        }

        private ResolvedLink resolveLink(NodeFormatterSubContext context, LinkType linkType, CharSequence url, Attributes attributes, Boolean urlEncode) {
            String urlSeq;
            HashMap resolvedLinks = this.resolvedLinkMap.computeIfAbsent(linkType, k -> new HashMap());
            ResolvedLink resolvedLink = (ResolvedLink)resolvedLinks.get(urlSeq = String.valueOf(url));
            if (resolvedLink == null) {
                resolvedLink = new ResolvedLink(linkType, (CharSequence)urlSeq, attributes);
                if (!urlSeq.isEmpty()) {
                    LinkResolver linkResolver;
                    Node currentNode = context.renderingNode;
                    LinkResolver[] linkResolverArray = this.myLinkResolvers;
                    int n = linkResolverArray.length;
                    for (int i = 0; i < n && (resolvedLink = (linkResolver = linkResolverArray[i]).resolveLink(currentNode, (LinkResolverContext)this, resolvedLink)).getStatus() == LinkStatus.UNKNOWN; ++i) {
                    }
                }
                resolvedLinks.put(urlSeq, resolvedLink);
            }
            return resolvedLink;
        }

        @Override
        public void addExplicitId(Node node, String id, NodeFormatterContext context, MarkdownWriter markdown) {
            if (this.myExplicitAttributeIdProvider != null) {
                this.myExplicitAttributeIdProvider.addExplicitId(node, id, context, markdown);
            }
        }

        @Override
        public RenderPurpose getRenderPurpose() {
            return this.myTranslationHandler == null ? RenderPurpose.FORMAT : this.myTranslationHandler.getRenderPurpose();
        }

        @Override
        public boolean isTransformingText() {
            return this.myTranslationHandler != null && this.myTranslationHandler.isTransformingText();
        }

        @Override
        public CharSequence transformNonTranslating(CharSequence prefix, CharSequence nonTranslatingText, CharSequence suffix, CharSequence suffix2) {
            return this.myTranslationHandler == null ? nonTranslatingText : this.myTranslationHandler.transformNonTranslating(prefix, nonTranslatingText, suffix, suffix2);
        }

        @Override
        public CharSequence transformTranslating(CharSequence prefix, CharSequence translatingText, CharSequence suffix, CharSequence suffix2) {
            return this.myTranslationHandler == null ? translatingText : this.myTranslationHandler.transformTranslating(prefix, translatingText, suffix, suffix2);
        }

        @Override
        public CharSequence transformAnchorRef(CharSequence pageRef, CharSequence anchorRef) {
            return this.myTranslationHandler == null ? anchorRef : this.myTranslationHandler.transformAnchorRef(pageRef, anchorRef);
        }

        @Override
        public void postProcessNonTranslating(Function<String, CharSequence> postProcessor, Runnable scope) {
            if (this.myTranslationHandler != null) {
                this.myTranslationHandler.postProcessNonTranslating(postProcessor, scope);
            } else {
                scope.run();
            }
        }

        @Override
        public <T> T postProcessNonTranslating(Function<String, CharSequence> postProcessor, Supplier<T> scope) {
            if (this.myTranslationHandler != null) {
                return this.myTranslationHandler.postProcessNonTranslating(postProcessor, scope);
            }
            return scope.get();
        }

        @Override
        public boolean isPostProcessingNonTranslating() {
            return this.myTranslationHandler != null && this.myTranslationHandler.isPostProcessingNonTranslating();
        }

        @Override
        public MergeContext getMergeContext() {
            return this.myTranslationHandler == null ? null : this.myTranslationHandler.getMergeContext();
        }

        @Override
        public HtmlIdGenerator getIdGenerator() {
            return this.myTranslationHandler == null ? null : this.myTranslationHandler.getIdGenerator();
        }

        @Override
        public void translatingSpan(TranslatingSpanRender render) {
            if (this.myTranslationHandler != null) {
                this.myTranslationHandler.translatingSpan(render);
            } else {
                render.render(this, this.markdown);
            }
        }

        @Override
        public void nonTranslatingSpan(TranslatingSpanRender render) {
            if (this.myTranslationHandler != null) {
                this.myTranslationHandler.nonTranslatingSpan(render);
            } else {
                render.render(this, this.markdown);
            }
        }

        @Override
        public void translatingRefTargetSpan(Node target, TranslatingSpanRender render) {
            if (this.myTranslationHandler != null) {
                this.myTranslationHandler.translatingRefTargetSpan(target, render);
            } else {
                render.render(this, this.markdown);
            }
        }

        @Override
        public MutableDataHolder getTranslationStore() {
            if (this.myTranslationHandler != null) {
                return this.myTranslationHandler.getTranslationStore();
            }
            return this.document;
        }

        @Override
        public void customPlaceholderFormat(TranslationPlaceholderGenerator generator, TranslatingSpanRender render) {
            if (this.myTranslationHandler != null) {
                this.myTranslationHandler.customPlaceholderFormat(generator, render);
            } else {
                render.render(this, this.markdown);
            }
        }

        public Node getCurrentNode() {
            return this.renderingNode;
        }

        @Override
        public DataHolder getOptions() {
            return this.options;
        }

        @Override
        public FormatterOptions getFormatterOptions() {
            return Formatter.this.formatterOptions;
        }

        @Override
        public Document getDocument() {
            return this.document;
        }

        @Override
        public FormattingPhase getFormattingPhase() {
            return this.phase;
        }

        @Override
        public void render(Node node) {
            this.renderNode(node, this);
        }

        @Override
        public final Iterable<? extends Node> nodesOfType(Class<?>[] classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.itemsOfType(Node.class, (Class[])classes);
        }

        @Override
        public final Iterable<? extends Node> nodesOfType(Collection<Class<?>> classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.itemsOfType(Node.class, classes);
        }

        @Override
        public final Iterable<? extends Node> reversedNodesOfType(Class<?>[] classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.reversedItemsOfType(Node.class, (Class[])classes);
        }

        @Override
        public final Iterable<? extends Node> reversedNodesOfType(Collection<Class<?>> classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.reversedItemsOfType(Node.class, classes);
        }

        public NodeFormatterContext getSubContext() {
            MarkdownWriter writer = new MarkdownWriter(this.getMarkdown().getOptions());
            writer.setContext(this);
            return new SubNodeFormatter(this, writer);
        }

        void renderNode(Node node, NodeFormatterSubContext subContext) {
            if (node instanceof Document) {
                if (this.myTranslationHandler != null) {
                    this.myTranslationHandler.beginRendering((Document)node, subContext, subContext.markdown);
                }
                for (FormattingPhase phase : FormattingPhase.values()) {
                    if (phase != FormattingPhase.DOCUMENT && !this.renderingPhases.contains((Object)phase)) continue;
                    this.phase = phase;
                    if (this.phase == FormattingPhase.DOCUMENT) {
                        NodeFormattingHandler<?> nodeRenderer = this.renderers.get(node.getClass());
                        if (nodeRenderer == null) continue;
                        subContext.renderingNode = node;
                        nodeRenderer.render(node, (NodeFormatterContext)subContext, subContext.markdown);
                        subContext.renderingNode = null;
                        continue;
                    }
                    for (PhasedNodeFormatter phasedFormatter : this.phasedFormatters) {
                        if (!phasedFormatter.getFormattingPhases().contains((Object)phase)) continue;
                        subContext.renderingNode = node;
                        phasedFormatter.renderDocument(subContext, subContext.markdown, (Document)node, phase);
                        subContext.renderingNode = null;
                    }
                }
            } else {
                NodeFormattingHandler<?> nodeRenderer = this.renderers.get(node.getClass());
                if (nodeRenderer == null) {
                    nodeRenderer = this.renderers.get(Node.class);
                }
                if (nodeRenderer != null) {
                    Node oldNode = this.renderingNode;
                    subContext.renderingNode = node;
                    nodeRenderer.render(node, (NodeFormatterContext)subContext, subContext.markdown);
                    subContext.renderingNode = oldNode;
                } else {
                    throw new IllegalStateException("Core Node Formatter should implement generic Node renderer");
                }
            }
        }

        @Override
        public void renderChildren(Node parent) {
            this.renderChildrenNode(parent, this);
        }

        protected void renderChildrenNode(Node parent, NodeFormatterSubContext subContext) {
            Node node = parent.getFirstChild();
            while (node != null) {
                Node next = node.getNext();
                this.renderNode(node, subContext);
                node = next;
            }
        }

        private class SubNodeFormatter
        extends NodeFormatterSubContext
        implements NodeFormatterContext {
            private final MainNodeFormatter myMainNodeRenderer;

            public SubNodeFormatter(MainNodeFormatter mainNodeRenderer, MarkdownWriter out) {
                super(out);
                this.myMainNodeRenderer = mainNodeRenderer;
            }

            @Override
            public MutableDataHolder getTranslationStore() {
                return this.myMainNodeRenderer.getTranslationStore();
            }

            @Override
            public final Iterable<? extends Node> nodesOfType(Class<?>[] classes) {
                return this.myMainNodeRenderer.nodesOfType(classes);
            }

            @Override
            public final Iterable<? extends Node> nodesOfType(Collection<Class<?>> classes) {
                return this.myMainNodeRenderer.nodesOfType(classes);
            }

            @Override
            public final Iterable<? extends Node> reversedNodesOfType(Class<?>[] classes) {
                return this.myMainNodeRenderer.reversedNodesOfType(classes);
            }

            @Override
            public final Iterable<? extends Node> reversedNodesOfType(Collection<Class<?>> classes) {
                return this.myMainNodeRenderer.reversedNodesOfType(classes);
            }

            @Override
            public DataHolder getOptions() {
                return this.myMainNodeRenderer.getOptions();
            }

            @Override
            public FormatterOptions getFormatterOptions() {
                return this.myMainNodeRenderer.getFormatterOptions();
            }

            @Override
            public Document getDocument() {
                return this.myMainNodeRenderer.getDocument();
            }

            @Override
            public FormattingPhase getFormattingPhase() {
                return this.myMainNodeRenderer.getFormattingPhase();
            }

            @Override
            public void render(Node node) {
                this.myMainNodeRenderer.renderNode(node, this);
            }

            public Node getCurrentNode() {
                return this.myMainNodeRenderer.getCurrentNode();
            }

            public NodeFormatterContext getSubContext() {
                MarkdownWriter htmlWriter = new MarkdownWriter(this.markdown.getOptions());
                htmlWriter.setContext(this);
                return new SubNodeFormatter(this.myMainNodeRenderer, htmlWriter);
            }

            @Override
            public void renderChildren(Node parent) {
                this.myMainNodeRenderer.renderChildrenNode(parent, this);
            }

            @Override
            public MarkdownWriter getMarkdown() {
                return this.markdown;
            }

            @Override
            public RenderPurpose getRenderPurpose() {
                return this.myMainNodeRenderer.getRenderPurpose();
            }

            @Override
            public boolean isTransformingText() {
                return this.myMainNodeRenderer.isTransformingText();
            }

            @Override
            public CharSequence transformNonTranslating(CharSequence prefix, CharSequence nonTranslatingText, CharSequence suffix, CharSequence suffix2) {
                return this.myMainNodeRenderer.transformNonTranslating(prefix, nonTranslatingText, suffix, suffix2);
            }

            @Override
            public CharSequence transformTranslating(CharSequence prefix, CharSequence translatingText, CharSequence suffix, CharSequence suffix2) {
                return this.myMainNodeRenderer.transformTranslating(prefix, translatingText, suffix, suffix2);
            }

            @Override
            public CharSequence transformAnchorRef(CharSequence pageRef, CharSequence anchorRef) {
                return this.myMainNodeRenderer.transformAnchorRef(pageRef, anchorRef);
            }

            @Override
            public void translatingSpan(TranslatingSpanRender render) {
                this.myMainNodeRenderer.translatingSpan(render);
            }

            @Override
            public void nonTranslatingSpan(TranslatingSpanRender render) {
                this.myMainNodeRenderer.nonTranslatingSpan(render);
            }

            @Override
            public void translatingRefTargetSpan(Node target, TranslatingSpanRender render) {
                this.myMainNodeRenderer.translatingRefTargetSpan(target, render);
            }

            @Override
            public void customPlaceholderFormat(TranslationPlaceholderGenerator generator, TranslatingSpanRender render) {
                this.myMainNodeRenderer.customPlaceholderFormat(generator, render);
            }

            public String encodeUrl(CharSequence url) {
                return this.myMainNodeRenderer.encodeUrl(url);
            }

            public ResolvedLink resolveLink(LinkType linkType, CharSequence url, Boolean urlEncode) {
                return this.myMainNodeRenderer.resolveLink(this, linkType, url, null, urlEncode);
            }

            public ResolvedLink resolveLink(LinkType linkType, CharSequence url, Attributes attributes, Boolean urlEncode) {
                return this.myMainNodeRenderer.resolveLink(this, linkType, url, attributes, urlEncode);
            }

            @Override
            public void postProcessNonTranslating(Function<String, CharSequence> postProcessor, Runnable scope) {
                this.myMainNodeRenderer.postProcessNonTranslating(postProcessor, scope);
            }

            @Override
            public <T> T postProcessNonTranslating(Function<String, CharSequence> postProcessor, Supplier<T> scope) {
                return this.myMainNodeRenderer.postProcessNonTranslating(postProcessor, scope);
            }

            @Override
            public boolean isPostProcessingNonTranslating() {
                return this.myMainNodeRenderer.isPostProcessingNonTranslating();
            }

            @Override
            public MergeContext getMergeContext() {
                return this.myMainNodeRenderer.getMergeContext();
            }

            @Override
            public void addExplicitId(Node node, String id, NodeFormatterContext context, MarkdownWriter markdown) {
                this.myMainNodeRenderer.addExplicitId(node, id, context, markdown);
            }

            @Override
            public HtmlIdGenerator getIdGenerator() {
                return this.myMainNodeRenderer.getIdGenerator();
            }
        }
    }

    public static interface FormatterExtension
    extends Extension {
        public void rendererOptions(MutableDataHolder var1);

        public void extend(Builder var1);
    }

    public static class Builder
    extends BuilderBase<Builder> {
        List<AttributeProviderFactory> attributeProviderFactories = new ArrayList<AttributeProviderFactory>();
        List<NodeFormatterFactory> nodeFormatterFactories = new ArrayList<NodeFormatterFactory>();
        List<LinkResolverFactory> linkResolverFactories = new ArrayList<LinkResolverFactory>();
        HeaderIdGeneratorFactory htmlIdGeneratorFactory = null;

        public Builder() {
        }

        public Builder(DataHolder options) {
            super(options);
            this.loadExtensions();
        }

        public Builder(Builder other) {
            super((BuilderBase)other);
            this.attributeProviderFactories.addAll(other.attributeProviderFactories);
            this.linkResolverFactories.addAll(other.linkResolverFactories);
        }

        public Builder(Builder other, DataHolder options) {
            this(other);
            this.withOptions(options);
        }

        public Formatter build() {
            return new Formatter(this);
        }

        protected void removeApiPoint(Object apiPoint) {
            if (apiPoint instanceof AttributeProviderFactory) {
                this.attributeProviderFactories.remove(apiPoint.getClass());
            } else if (apiPoint instanceof NodeFormatterFactory) {
                this.nodeFormatterFactories.remove(apiPoint);
            } else if (apiPoint instanceof LinkResolverFactory) {
                this.linkResolverFactories.remove(apiPoint);
            } else if (apiPoint instanceof HeaderIdGeneratorFactory) {
                this.htmlIdGeneratorFactory = null;
            } else {
                throw new IllegalStateException("Unknown data point type: " + apiPoint.getClass().getName());
            }
        }

        protected void preloadExtension(Extension extension) {
            if (extension instanceof FormatterExtension) {
                FormatterExtension formatterExtension = (FormatterExtension)extension;
                formatterExtension.rendererOptions((MutableDataHolder)this);
            }
        }

        protected boolean loadExtension(Extension extension) {
            if (extension instanceof FormatterExtension) {
                FormatterExtension formatterExtension = (FormatterExtension)extension;
                formatterExtension.extend(this);
                return true;
            }
            return false;
        }

        public Builder nodeFormatterFactory(NodeFormatterFactory nodeFormatterFactory) {
            this.nodeFormatterFactories.add(nodeFormatterFactory);
            return this;
        }
    }

    public static class NodeFormatterDependencies
    extends ResolvedDependencies<NodeFormatterDependencyStage> {
        private final List<NodeFormatterFactory> nodeFactories;

        public NodeFormatterDependencies(List<NodeFormatterDependencyStage> dependentStages) {
            super(dependentStages);
            ArrayList<NodeFormatterFactory> nodeFormatterFactories = new ArrayList<NodeFormatterFactory>();
            for (NodeFormatterDependencyStage stage : dependentStages) {
                nodeFormatterFactories.addAll(stage.dependents);
            }
            this.nodeFactories = nodeFormatterFactories;
        }

        public List<NodeFormatterFactory> getNodeFactories() {
            return this.nodeFactories;
        }
    }

    private static class NodeFormatterDependencyHandler
    extends DependencyHandler<NodeFormatterFactory, NodeFormatterDependencyStage, NodeFormatterDependencies> {
        private NodeFormatterDependencyHandler() {
        }

        protected Class<? extends NodeFormatterFactory> getDependentClass(NodeFormatterFactory dependent) {
            return dependent.getClass();
        }

        protected NodeFormatterDependencies createResolvedDependencies(List<NodeFormatterDependencyStage> stages) {
            return new NodeFormatterDependencies(stages);
        }

        protected NodeFormatterDependencyStage createStage(List<NodeFormatterFactory> dependents) {
            return new NodeFormatterDependencyStage(dependents);
        }
    }

    public static class NodeFormatterDependencyStage {
        private final List<NodeFormatterFactory> dependents;

        public NodeFormatterDependencyStage(List<NodeFormatterFactory> dependents) {
            this.dependents = dependents;
        }
    }
}

