/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.wikilink.internal;

import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.wikilink.WikiImage;
import com.vladsch.flexmark.ext.wikilink.WikiLink;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.ext.wikilink.internal.WikiLinkOptions;
import com.vladsch.flexmark.parser.LinkRefProcessor;
import com.vladsch.flexmark.parser.LinkRefProcessorFactory;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class WikiLinkLinkRefProcessor
implements LinkRefProcessor {
    static final int BRACKET_NESTING_LEVEL = 1;
    private final WikiLinkOptions options;

    public WikiLinkLinkRefProcessor(Document document) {
        this.options = new WikiLinkOptions((DataHolder)document);
    }

    public boolean getWantExclamationPrefix() {
        return this.options.imageLinks;
    }

    public int getBracketNestingLevel() {
        return 1;
    }

    public boolean isMatch(BasedSequence nodeChars) {
        int length = nodeChars.length();
        if (this.options.imageLinks) {
            if (length >= 5 && nodeChars.charAt(0) == '!') {
                return nodeChars.charAt(1) == '[' && nodeChars.charAt(2) == '[' && nodeChars.endCharAt(1) == ']' && nodeChars.endCharAt(2) == ']';
            }
            if (length >= 4) {
                return nodeChars.charAt(0) == '[' && nodeChars.charAt(1) == '[' && nodeChars.endCharAt(1) == ']' && nodeChars.endCharAt(2) == ']';
            }
        } else if (length >= 4) {
            return nodeChars.charAt(0) == '[' && nodeChars.charAt(1) == '[' && nodeChars.endCharAt(1) == ']' && nodeChars.endCharAt(2) == ']';
        }
        return false;
    }

    public void adjustInlineText(Node node) {
    }

    public Node createNode(BasedSequence nodeChars) {
        return nodeChars.firstChar() == '!' ? new WikiImage(nodeChars, this.options.linkFirstSyntax) : new WikiLink(nodeChars, this.options.linkFirstSyntax);
    }

    public static class Factory
    implements LinkRefProcessorFactory {
        public LinkRefProcessor create(Document document) {
            return new WikiLinkLinkRefProcessor(document);
        }

        public boolean getWantExclamationPrefix(DataHolder options) {
            return (Boolean)WikiLinkExtension.IMAGE_LINKS.getFrom(options);
        }

        public int getBracketNestingLevel(DataHolder options) {
            return 1;
        }
    }
}

