/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.tasklist.internal;

import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.BulletListItem;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListExtension;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListItem;
import com.vladsch.flexmark.internal.ReferencePreProcessorFactory;
import com.vladsch.flexmark.parser.block.ParagraphPreProcessor;
import com.vladsch.flexmark.parser.block.ParagraphPreProcessorFactory;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class TaskListParagraphPreProcessor
implements ParagraphPreProcessor {
    private final TaskListParsing myParsing;
    private final boolean convertOrderedListItems;

    TaskListParagraphPreProcessor(DataHolder options) {
        this.myParsing = new TaskListParsing(options);
        this.convertOrderedListItems = (Boolean)options.get(TaskListExtension.CONVERT_ORDERED_LIST_ITEMS);
    }

    public int preProcessBlock(Paragraph block, ParserState state) {
        BasedSequence chars;
        Block listItem = block.getParent();
        if ((listItem instanceof BulletListItem || listItem instanceof ListItem && this.convertOrderedListItems) && block.getPrevious() == null && this.myParsing.TASK_LIST_MARKER.matcher((CharSequence)(chars = block.getChars())).find()) {
            TaskListItem taskListItem = new TaskListItem((ListItem)listItem);
            taskListItem.setTight(((ListItem)listItem).isTight());
            BasedSequence taskOpeningMarker = chars.subSequence(0, 3);
            taskListItem.setTaskOpeningMarker(taskOpeningMarker);
            listItem.insertBefore((Node)taskListItem);
            listItem.unlink();
            return 3 + chars.countChars((CharSequence)" \t\r\n", 3, chars.length());
        }
        return 0;
    }

    public static class Factory
    implements ParagraphPreProcessorFactory {
        public Set<Class<? extends ParagraphPreProcessorFactory>> getAfterDependents() {
            return null;
        }

        public Set<Class<? extends ParagraphPreProcessorFactory>> getBeforeDependents() {
            HashSet<Class<? extends ParagraphPreProcessorFactory>> set = new HashSet<Class<? extends ParagraphPreProcessorFactory>>();
            set.add(ReferencePreProcessorFactory.class);
            return set;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        public ParagraphPreProcessor create(ParserState state) {
            return new TaskListParagraphPreProcessor((DataHolder)state.getProperties());
        }
    }

    static class TaskListParsing
    extends Parsing {
        final Pattern TASK_LIST_MARKER = Pattern.compile("^\\[" + super.ADDITIONAL_CHARS_SET("?") + "[ xX]\\](?: |\t|\r|\n|$)");

        TaskListParsing(DataHolder options) {
            super(options);
        }
    }
}

