/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.tasklist;

import com.vladsch.flexmark.ext.gfm.tasklist.TaskListItemCase;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListItemPlacement;
import com.vladsch.flexmark.ext.gfm.tasklist.internal.TaskListItemBlockPreProcessor;
import com.vladsch.flexmark.ext.gfm.tasklist.internal.TaskListNodeFormatter;
import com.vladsch.flexmark.ext.gfm.tasklist.internal.TaskListNodeRenderer;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.BlockPreProcessorFactory;
import com.vladsch.flexmark.util.builder.Extension;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataHolder;

public class TaskListExtension
implements Parser.ParserExtension,
HtmlRenderer.HtmlRendererExtension,
Formatter.FormatterExtension {
    public static final DataKey<String> ITEM_DONE_MARKER = new DataKey("ITEM_DONE_MARKER", (Object)"<input type=\"checkbox\" class=\"task-list-item-checkbox\" checked=\"checked\" disabled=\"disabled\" readonly=\"readonly\" />&nbsp;");
    public static final DataKey<String> ITEM_NOT_DONE_MARKER = new DataKey("ITEM_NOT_DONE_MARKER", (Object)"<input type=\"checkbox\" class=\"task-list-item-checkbox\" disabled=\"disabled\" readonly=\"readonly\" />&nbsp;");
    public static final DataKey<String> TIGHT_ITEM_CLASS = new DataKey("TIGHT_ITEM_CLASS", (Object)"task-list-item");
    public static final DataKey<String> LOOSE_ITEM_CLASS = new DataKey("LOOSE_ITEM_CLASS", TIGHT_ITEM_CLASS);
    public static final DataKey<String> PARAGRAPH_CLASS = new DataKey("PARAGRAPH_CLASS", (Object)"");
    public static final DataKey<String> ITEM_DONE_CLASS = new DataKey("ITEM_DONE_CLASS", (Object)"");
    public static final DataKey<String> ITEM_NOT_DONE_CLASS = new DataKey("ITEM_NOT_DONE_CLASS", (Object)"");
    public static final DataKey<String> ITEM_CLASS = TIGHT_ITEM_CLASS;
    public static final DataKey<TaskListItemCase> FORMAT_LIST_ITEM_CASE = new DataKey("FORMAT_LIST_ITEM_CASE", (Object)TaskListItemCase.AS_IS);
    public static final DataKey<TaskListItemPlacement> FORMAT_LIST_ITEM_PLACEMENT = new DataKey("FORMAT_LIST_ITEM_PLACEMENT", (Object)TaskListItemPlacement.AS_IS);

    private TaskListExtension() {
    }

    public static Extension create() {
        return new TaskListExtension();
    }

    public void extend(Formatter.Builder builder) {
        builder.nodeFormatterFactory(new NodeFormatterFactory(){

            public NodeFormatter create(DataHolder options) {
                return new TaskListNodeFormatter(options);
            }
        });
    }

    public void rendererOptions(MutableDataHolder options) {
    }

    public void parserOptions(MutableDataHolder options) {
        ListOptions.addItemMarkerSuffixes((MutableDataHolder)options, (String[])new String[]{"[ ]", "[x]", "[X]"});
    }

    public void extend(Parser.Builder parserBuilder) {
        parserBuilder.blockPreProcessorFactory((BlockPreProcessorFactory)new TaskListItemBlockPreProcessor.Factory());
    }

    public void extend(HtmlRenderer.Builder rendererBuilder, String rendererType) {
        if (rendererBuilder.isRendererType("HTML")) {
            rendererBuilder.nodeRendererFactory((NodeRendererFactory)new TaskListNodeRenderer.Factory());
        } else if (rendererBuilder.isRendererType("JIRA")) {
            // empty if block
        }
    }
}

