/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.footnotes.internal;

import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.NodeVisitor;
import com.vladsch.flexmark.ast.VisitHandler;
import com.vladsch.flexmark.ast.Visitor;
import com.vladsch.flexmark.ext.footnotes.Footnote;
import com.vladsch.flexmark.ext.footnotes.FootnoteBlock;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteOptions;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteRepository;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.PhasedNodeRenderer;
import com.vladsch.flexmark.html.renderer.RenderingPhase;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FootnoteNodeRenderer
implements PhasedNodeRenderer {
    private final FootnoteRepository footnoteRepository;
    private final FootnoteOptions options;
    private boolean recheckUndefinedReferences;

    public FootnoteNodeRenderer(DataHolder options) {
        this.options = new FootnoteOptions(options);
        this.footnoteRepository = (FootnoteRepository)((Object)options.get(FootnoteExtension.FOOTNOTES));
        this.recheckUndefinedReferences = (Boolean)HtmlRenderer.RECHECK_UNDEFINED_REFERENCES.getFrom(options);
        this.footnoteRepository.resolveFootnoteOrdinals();
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler(Footnote.class, (CustomNodeRenderer)new CustomNodeRenderer<Footnote>(){

            public void render(Footnote node, NodeRendererContext context, HtmlWriter html) {
                FootnoteNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(FootnoteBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<FootnoteBlock>(){

            public void render(FootnoteBlock node, NodeRendererContext context, HtmlWriter html) {
                FootnoteNodeRenderer.this.render(node, context, html);
            }
        })));
    }

    public Set<RenderingPhase> getRenderingPhases() {
        HashSet<RenderingPhase> set = new HashSet<RenderingPhase>();
        set.add(RenderingPhase.BODY_TOP);
        set.add(RenderingPhase.BODY_BOTTOM);
        return set;
    }

    public void renderDocument(final NodeRendererContext context, final HtmlWriter html, Document document, RenderingPhase phase) {
        if (phase == RenderingPhase.BODY_TOP && this.recheckUndefinedReferences) {
            final boolean[] hadNewFootnotes = new boolean[]{false};
            NodeVisitor visitor = new NodeVisitor(new VisitHandler[]{new VisitHandler(Footnote.class, (Visitor)new Visitor<Footnote>(){

                public void visit(Footnote node) {
                    FootnoteBlock footonoteBlock;
                    if (!node.isDefined() && (footonoteBlock = node.getFootonoteBlock(FootnoteNodeRenderer.this.footnoteRepository)) != null) {
                        FootnoteNodeRenderer.this.footnoteRepository.addFootnoteReference(footonoteBlock, node);
                        node.setFootnoteBlock(footonoteBlock);
                        hadNewFootnotes[0] = true;
                    }
                }
            })});
            visitor.visit((Node)document);
            if (hadNewFootnotes[0]) {
                this.footnoteRepository.resolveFootnoteOrdinals();
            }
        }
        if (phase == RenderingPhase.BODY_BOTTOM && this.footnoteRepository.getReferencedFootnoteBlocks().size() > 0) {
            ((HtmlWriter)html.attr((CharSequence)"class", (CharSequence)"footnotes")).withAttr().tagIndent((CharSequence)"div", new Runnable(){

                @Override
                public void run() {
                    html.tagVoidLine((CharSequence)"hr");
                    html.tagIndent((CharSequence)"ol", new Runnable(){

                        @Override
                        public void run() {
                            for (final FootnoteBlock footnoteBlock : FootnoteNodeRenderer.this.footnoteRepository.getReferencedFootnoteBlocks()) {
                                final int footnoteOrdinal = footnoteBlock.getFootnoteOrdinal();
                                html.attr((CharSequence)"id", (CharSequence)("fn-" + footnoteOrdinal));
                                html.withAttr().tagIndent((CharSequence)"li", new Runnable(){

                                    @Override
                                    public void run() {
                                        context.renderChildren((Node)footnoteBlock);
                                        html.attr((CharSequence)"href", (CharSequence)("#fnref-" + footnoteOrdinal));
                                        if (!((FootnoteNodeRenderer)FootnoteNodeRenderer.this).options.footnoteBackLinkRefClass.isEmpty()) {
                                            html.attr((CharSequence)"class", (CharSequence)((FootnoteNodeRenderer)FootnoteNodeRenderer.this).options.footnoteBackLinkRefClass);
                                        }
                                        html.withAttr().tag((CharSequence)"a");
                                        html.raw((CharSequence)((FootnoteNodeRenderer)FootnoteNodeRenderer.this).options.footnoteBackRefString);
                                        html.tag((CharSequence)"/a");
                                    }
                                });
                            }
                        }
                    });
                }
            });
        }
    }

    private void render(FootnoteBlock node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(Footnote node, NodeRendererContext context, final HtmlWriter html) {
        FootnoteBlock footnoteBlock = node.getFootnoteBlock();
        if (footnoteBlock == null) {
            html.raw((CharSequence)"[^");
            context.renderChildren((Node)node);
            html.raw((CharSequence)"]");
        } else {
            final int footnoteOrdinal = footnoteBlock.getFootnoteOrdinal();
            html.attr((CharSequence)"id", (CharSequence)("fnref-" + footnoteOrdinal));
            html.srcPos(node.getChars()).withAttr().tag((CharSequence)"sup", false, false, new Runnable(){

                @Override
                public void run() {
                    if (!((FootnoteNodeRenderer)FootnoteNodeRenderer.this).options.footnoteLinkRefClass.isEmpty()) {
                        html.attr((CharSequence)"class", (CharSequence)((FootnoteNodeRenderer)FootnoteNodeRenderer.this).options.footnoteLinkRefClass);
                    }
                    html.attr((CharSequence)"href", (CharSequence)("#fn-" + footnoteOrdinal));
                    html.withAttr().tag((CharSequence)"a");
                    html.raw((CharSequence)(((FootnoteNodeRenderer)FootnoteNodeRenderer.this).options.footnoteRefPrefix + String.valueOf(footnoteOrdinal) + ((FootnoteNodeRenderer)FootnoteNodeRenderer.this).options.footnoteRefSuffix));
                    html.tag((CharSequence)"/a");
                }
            });
        }
    }
}

