/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.definition.internal;

import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.definition.DefinitionItem;
import com.vladsch.flexmark.ext.definition.DefinitionList;
import com.vladsch.flexmark.ext.definition.internal.DefinitionListItemBlockPreProcessor;
import com.vladsch.flexmark.ext.definition.internal.DefinitionOptions;
import com.vladsch.flexmark.parser.block.BlockPreProcessor;
import com.vladsch.flexmark.parser.block.BlockPreProcessorFactory;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashSet;
import java.util.Set;

public class DefinitionListBlockPreProcessor
implements BlockPreProcessor {
    private final DefinitionOptions options;

    public DefinitionListBlockPreProcessor(DataHolder options) {
        this.options = new DefinitionOptions(options);
    }

    public void preProcess(ParserState state, Block block) {
        if (block instanceof DefinitionList) {
            DefinitionList definitionList = (DefinitionList)block;
            boolean isTight = definitionList.isTight();
            if (this.options.autoLoose && isTight) {
                for (Node child : definitionList.getChildren()) {
                    if (!(child instanceof DefinitionItem) || !((DefinitionItem)child).isLoose()) continue;
                    isTight = false;
                    break;
                }
                definitionList.setTight(isTight);
            }
        }
    }

    public static class Factory
    implements BlockPreProcessorFactory {
        public Set<Class<? extends Block>> getBlockTypes() {
            HashSet<Class<? extends Block>> set = new HashSet<Class<? extends Block>>();
            set.add(DefinitionList.class);
            return set;
        }

        public Set<Class<? extends BlockPreProcessorFactory>> getAfterDependents() {
            HashSet<Class<? extends BlockPreProcessorFactory>> set = new HashSet<Class<? extends BlockPreProcessorFactory>>();
            set.add(DefinitionListItemBlockPreProcessor.Factory.class);
            return set;
        }

        public Set<Class<? extends BlockPreProcessorFactory>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return true;
        }

        public BlockPreProcessor create(ParserState state) {
            return new DefinitionListBlockPreProcessor((DataHolder)state.getProperties());
        }
    }
}

