/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.anchorlink.internal;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.anchorlink.AnchorLink;
import com.vladsch.flexmark.ext.anchorlink.internal.AnchorLinkOptions;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AnchorLinkNodeRenderer
implements NodeRenderer {
    private final AnchorLinkOptions options;

    public AnchorLinkNodeRenderer(DataHolder options) {
        this.options = new AnchorLinkOptions(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Collections.singletonList(new NodeRenderingHandler(AnchorLink.class, this::render)));
    }

    private void render(AnchorLink node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            if (this.options.wrapText) {
                context.renderChildren((Node)node);
            }
        } else {
            String id = context.getNodeId(node.getParent());
            if (id != null) {
                html.attr("href", "#" + id);
                if (this.options.setId) {
                    html.attr("id", id);
                }
                if (this.options.setName) {
                    html.attr("name", id);
                }
                if (!this.options.anchorClass.isEmpty()) {
                    html.attr("class", this.options.anchorClass);
                }
                if (!this.options.wrapText) {
                    html.withAttr().tag("a");
                    if (!this.options.textPrefix.isEmpty()) {
                        html.raw(this.options.textPrefix);
                    }
                    if (!this.options.textSuffix.isEmpty()) {
                        html.raw(this.options.textSuffix);
                    }
                    html.tag("/a");
                } else {
                    html.withAttr().tag("a", () -> {
                        if (!this.options.textPrefix.isEmpty()) {
                            html.raw(this.options.textPrefix);
                        }
                        context.renderChildren((Node)node);
                        if (!this.options.textSuffix.isEmpty()) {
                            html.raw(this.options.textSuffix);
                        }
                    });
                }
            } else if (this.options.wrapText) {
                context.renderChildren((Node)node);
            }
        }
    }
}

