/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.internal;

import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.docx.converter.DocxRenderer;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTag;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.renderer.LinkResolverBasicContext;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.misc.Utils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocxLinkResolver
implements LinkResolver {
    private final String docRelativeURL;
    private final String docRootURL;
    private final String[] relativeParts;
    private final boolean prefixWwwLinks;

    public DocxLinkResolver(LinkResolverBasicContext context) {
        String docRelativeURL = (String)DocxRenderer.DOC_RELATIVE_URL.get(context.getOptions());
        String docRootURL = (String)DocxRenderer.DOC_ROOT_URL.get(context.getOptions());
        this.docRelativeURL = docRelativeURL;
        this.docRootURL = docRootURL;
        docRelativeURL = Utils.removePrefix((String)docRelativeURL, (char)'/');
        this.relativeParts = docRelativeURL.split("/");
        this.prefixWwwLinks = (Boolean)DocxRenderer.PREFIX_WWW_LINKS.get(context.getOptions());
    }

    @NotNull
    public ResolvedLink resolveLink(@NotNull Node node, @NotNull LinkResolverBasicContext context, @NotNull ResolvedLink link) {
        if (node instanceof Image || node instanceof Link || node instanceof Reference || node instanceof JekyllTag) {
            Object url = link.getUrl();
            if (this.docRelativeURL.isEmpty() && this.docRootURL.isEmpty()) {
                return link.withStatus(LinkStatus.VALID).withUrl((CharSequence)url);
            }
            if (((String)url).startsWith("http://") || ((String)url).startsWith("https://") || ((String)url).startsWith("ftp://") || ((String)url).startsWith("sftp://")) {
                return link.withStatus(LinkStatus.VALID).withUrl((CharSequence)url);
            }
            if (((String)url).startsWith("file:/")) {
                return link.withStatus(LinkStatus.VALID).withUrl((CharSequence)url);
            }
            if (((String)url).startsWith("emoji:")) {
                return link.withStatus(LinkStatus.VALID).withUrl((CharSequence)url);
            }
            if (((String)url).startsWith("/")) {
                if (this.docRootURL != null && !this.docRootURL.isEmpty()) {
                    if (!((String)(url = this.docRootURL + (String)url)).startsWith("file:")) {
                        url = "file://" + (String)url;
                    }
                    return link.withStatus(LinkStatus.VALID).withUrl((CharSequence)url);
                }
            } else {
                if (this.prefixWwwLinks && ((String)url).startsWith("www.")) {
                    return link.withStatus(LinkStatus.INVALID).withUrl((CharSequence)("http://" + (String)url));
                }
                if (!((String)url).startsWith("data:") && !((String)url).matches("^(?:[a-z]+:|#|\\?)")) {
                    Object pageRef = url;
                    String suffix = "";
                    int pos = ((String)url).indexOf(35);
                    if (pos == 0) {
                        return link.withStatus(LinkStatus.VALID);
                    }
                    if (pos > 0) {
                        suffix = ((String)url).substring(pos);
                        pageRef = ((String)url).substring(0, pos);
                    } else if (((String)url).contains("?")) {
                        pos = ((String)url).indexOf("?");
                        suffix = ((String)url).substring(pos);
                        pageRef = ((String)url).substring(0, pos);
                    }
                    String[] pathParts = ((String)pageRef).split("/");
                    int docParts = this.relativeParts.length;
                    int iMax = pathParts.length;
                    StringBuilder resolved = new StringBuilder();
                    String sep = "";
                    for (int i = 0; i < iMax; ++i) {
                        String part = pathParts[i];
                        if (part.equals(".")) continue;
                        if (part.equals("..")) {
                            if (docParts == 0) {
                                return link;
                            }
                            --docParts;
                            continue;
                        }
                        resolved.append(sep);
                        resolved.append(part);
                        sep = "/";
                    }
                    sep = this.docRelativeURL.startsWith("/") ? "/" : "";
                    StringBuilder resolvedPath = new StringBuilder();
                    iMax = docParts;
                    for (int i = 0; i < iMax; ++i) {
                        resolvedPath.append(sep);
                        resolvedPath.append(this.relativeParts[i]);
                        sep = "/";
                    }
                    resolvedPath.append('/').append((CharSequence)resolved).append(suffix);
                    Object resolvedUri = resolvedPath.toString();
                    if (!((String)resolvedUri).startsWith("file:")) {
                        resolvedUri = "file://" + (String)resolvedUri;
                    }
                    return link.withStatus(LinkStatus.VALID).withUrl((CharSequence)resolvedUri);
                }
            }
        }
        return link;
    }

    public static class Factory
    implements LinkResolverFactory {
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        @NotNull
        public LinkResolver apply(@NotNull LinkResolverBasicContext context) {
            return new DocxLinkResolver(context);
        }
    }
}

