/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.util;

import jakarta.xml.bind.JAXBElement;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.XmlUtils;
import org.docx4j.dml.Graphic;
import org.docx4j.dml.wordprocessingDrawing.Anchor;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.Base;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.ExternalTarget;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryPartAbstractImage {
    final org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage myAbstractImage;
    protected static Logger log = LoggerFactory.getLogger(org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage.class);
    static final String namespaces = " xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\"";

    public BinaryPartAbstractImage(org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage abstractImage) {
        this.myAbstractImage = abstractImage;
    }

    public Anchor createImageAnchor(String filenameHint, String altText, int id1, int id2, boolean link, long posHOffset, long posVOffset) throws Exception {
        WordprocessingMLPackage wmlPackage = (WordprocessingMLPackage)this.myAbstractImage.getPackage();
        List sections = wmlPackage.getDocumentModel().getSections();
        PageDimensions page = ((SectionWrapper)sections.get(sections.size() - 1)).getPageDimensions();
        BinaryPartAbstractImage.CxCy cxcy = BinaryPartAbstractImage.CxCy.scale((ImageInfo)this.myAbstractImage.getImageInfo(), (PageDimensions)page);
        return this.createImageAnchor(filenameHint, altText, id1, id2, cxcy.getCx(), cxcy.getCy(), link, posHOffset, posVOffset);
    }

    public Anchor createImageAnchor(String filenameHint, String altText, int id1, int id2, boolean link, int maxWidth, int maxHeight, long posHOffset, long posVOffset) throws Exception {
        WordprocessingMLPackage wmlPackage = (WordprocessingMLPackage)this.getPackage();
        List sections = wmlPackage.getDocumentModel().getSections();
        PageDimensions page = ((SectionWrapper)sections.get(sections.size() - 1)).getPageDimensions();
        BinaryPartAbstractImage.CxCy cxcy = BinaryPartAbstractImage.scale(this.myAbstractImage.getImageInfo(), page, maxWidth, maxHeight);
        return this.createImageAnchor(filenameHint, altText, id1, id2, cxcy.getCx(), cxcy.getCy(), link, posHOffset, posVOffset);
    }

    public static BinaryPartAbstractImage.CxCy scale(ImageInfo imageInfo, PageDimensions page, int maxWidth, int maxHeight) {
        long cy;
        long cx;
        double writableWidthTwips = page.getWritableWidthTwips();
        log.debug("writableWidthTwips: " + writableWidthTwips);
        if (maxWidth > 0 && (double)maxWidth < writableWidthTwips) {
            writableWidthTwips = maxWidth;
            log.debug("reduced to: " + writableWidthTwips);
        }
        double writableHeightTwips = page.getWritableHeightTwips();
        log.debug("writableHeightTwips: " + writableHeightTwips);
        if (maxHeight > 0 && (double)maxHeight < writableHeightTwips) {
            writableHeightTwips = maxHeight;
            log.debug("reduced to: " + writableHeightTwips);
        }
        ImageSize size = imageInfo.getSize();
        Dimension dpx = size.getDimensionPx();
        double imageWidthTwips = UnitsOfMeasurement.pxToTwipDouble((double)((Dimension2D)dpx).getWidth());
        double imageHeightTwips = UnitsOfMeasurement.pxToTwipDouble((double)((Dimension2D)dpx).getHeight());
        log.debug("imageWidthTwips: " + imageWidthTwips);
        log.debug("imageHeightTwips: " + imageHeightTwips);
        boolean scaled = false;
        if (imageWidthTwips > writableWidthTwips && imageHeightTwips > writableHeightTwips) {
            log.debug("Scaling image to fit page width/height");
            scaled = true;
            double scale = Math.min(writableWidthTwips / imageWidthTwips, writableHeightTwips / imageHeightTwips);
            cx = UnitsOfMeasurement.twipToEMU((double)(imageWidthTwips * scale));
            cy = UnitsOfMeasurement.twipToEMU((double)(imageHeightTwips * scale));
        } else if (imageWidthTwips > writableWidthTwips) {
            log.debug("Scaling image to fit page width");
            scaled = true;
            cx = UnitsOfMeasurement.twipToEMU((double)writableWidthTwips);
            cy = UnitsOfMeasurement.twipToEMU((double)(imageHeightTwips * writableWidthTwips / imageWidthTwips));
        } else if (imageHeightTwips > writableHeightTwips) {
            log.debug("Scaling image to fit page height");
            scaled = true;
            cx = UnitsOfMeasurement.twipToEMU((double)(imageWidthTwips * writableHeightTwips / imageHeightTwips));
            cy = UnitsOfMeasurement.twipToEMU((double)writableHeightTwips);
        } else {
            log.debug("Scaling image - not necessary");
            cx = UnitsOfMeasurement.twipToEMU((double)imageWidthTwips);
            cy = UnitsOfMeasurement.twipToEMU((double)imageHeightTwips);
        }
        log.debug("cx=" + cx + "; cy=" + cy);
        return BinaryPartAbstractImage.CxCy.scaleToFit((double)UnitsOfMeasurement.twipToEMU((double)imageWidthTwips), (double)UnitsOfMeasurement.twipToEMU((double)imageHeightTwips), (double)cx, (double)cy);
    }

    public Anchor createImageAnchor(String filenameHint, String altText, int id1, int id2, long cx, boolean link, long posHOffset, long posVOffset) throws Exception {
        ImageSize size = this.myAbstractImage.getImageInfo().getSize();
        Dimension2D dPt = size.getDimensionPt();
        double imageWidthTwips = dPt.getWidth() * 20.0;
        log.debug("imageWidthTwips: " + imageWidthTwips);
        log.debug("Scaling image height to retain aspect ratio");
        long cy = UnitsOfMeasurement.twipToEMU((double)(dPt.getHeight() * 20.0 * (double)cx / imageWidthTwips));
        cx = UnitsOfMeasurement.twipToEMU((double)cx);
        log.debug("cx=" + cx + "; cy=" + cy);
        return this.createImageAnchor(filenameHint, altText, id1, id2, cx, cy, link, posHOffset, posVOffset);
    }

    public Anchor createImageAnchor(String filenameHint, String altText, int id1, int id2, long cx, long cy, boolean link, long posHOffset, long posVOffset) throws Exception {
        if (filenameHint == null) {
            filenameHint = "";
        }
        if (altText == null) {
            altText = "";
        }
        String type = link ? "r:link" : "r:embed";
        String alignmentNone = "<wp:positionH relativeFrom=\"column\"><wp:posOffset>${posHOffset}</wp:posOffset></wp:positionH><wp:positionV relativeFrom=\"paragraph\"><wp:posOffset>${posVOffset}</wp:posOffset></wp:positionV><wp:wrapNone/>";
        String alignmentLeft = "<wp:positionH relativeFrom=\"column\">\n  <wp:align>left</wp:align>\n</wp:positionH>\n<wp:positionV relativeFrom=\"paragraph\">\n  <wp:posOffset>0</wp:posOffset>\n</wp:positionV><wp:wrapSquare wrapText=\"right\"/>\n";
        String alignmentCenter = "<wp:positionH relativeFrom=\"column\">\n  <wp:align>center</wp:align>\n</wp:positionH>\n<wp:positionV relativeFrom=\"paragraph\">\n  <wp:posOffset>0</wp:posOffset>\n</wp:positionV><wp:wrapSquare wrapText=\"bothSides\"/>\n";
        String alignmentRight = "<wp:positionH relativeFrom=\"column\">\n  <wp:align>right</wp:align>\n</wp:positionH>\n<wp:positionV relativeFrom=\"paragraph\">\n  <wp:posOffset>0</wp:posOffset>\n</wp:positionV><wp:wrapSquare wrapText=\"left\"/>\n";
        String mlTop = "<wp:anchor distT=\"0\" distB=\"0\" distL=\"114300\" distR=\"114300\" simplePos=\"0\" relativeHeight=\"251658240\" behindDoc=\"0\" locked=\"0\" layoutInCell=\"1\" allowOverlap=\"1\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\"><wp:simplePos x=\"0\" y=\"0\"/><wp:extent cx=\"${cx}\" cy=\"${cy}\"/><wp:effectExtent l=\"0\" t=\"0\" r=\"0\" b=\"0\"/><wp:docPr id=\"${id1}\" name=\"${filenameHint}\" descr=\"${altText}\"/><wp:cNvGraphicFramePr><a:graphicFrameLocks xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" noChangeAspect=\"1\"/></wp:cNvGraphicFramePr><a:graphic xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\"> <a:graphicData uri=\"http://schemas.openxmlformats.org/drawingml/2006/picture\"> <pic:pic xmlns:pic=\"http://schemas.openxmlformats.org/drawingml/2006/picture\"><pic:nvPicPr><pic:cNvPr id=\"${id2}\" name=\"${filenameHint}\"/><pic:cNvPicPr/></pic:nvPicPr><pic:blipFill><a:blip " + type + "=\"${rEmbedId}\"/><a:stretch><a:fillRect/></a:stretch></pic:blipFill><pic:spPr><a:xfrm><a:off x=\"0\" y=\"0\"/><a:ext cx=\"${cx}\" cy=\"${cy}\"/></a:xfrm><a:prstGeom prst=\"rect\"><a:avLst/></a:prstGeom></pic:spPr></pic:pic></a:graphicData></a:graphic>";
        String mlBottom = "</wp:anchor>";
        HashMap<String, String> mappings = new HashMap<String, String>();
        String ml = posHOffset == Long.MAX_VALUE ? mlTop + alignmentRight + mlBottom : (posHOffset == 0x3FFFFFFFFFFFFFFFL ? mlTop + alignmentCenter + mlBottom : (posHOffset == Long.MIN_VALUE ? mlTop + alignmentLeft + mlBottom : mlTop + alignmentNone + mlBottom));
        mappings.put("cx", Long.toString(cx));
        mappings.put("cy", Long.toString(cy));
        mappings.put("posHOffset", Long.toString(posHOffset));
        mappings.put("posVOffset", Long.toString(posVOffset));
        mappings.put("filenameHint", filenameHint);
        mappings.put("altText", altText);
        mappings.put("rEmbedId", this.myAbstractImage.getRelLast().getId());
        mappings.put("id1", Integer.toString(id1));
        mappings.put("id2", Integer.toString(id2));
        Object o = XmlUtils.unmarshallFromTemplate((String)ml, mappings);
        Anchor anchor = (Anchor)((JAXBElement)o).getValue();
        return anchor;
    }

    public Inline createImageInline(String filenameHint, String altText, int id1, int id2, boolean link, int maxWidth, int maxHeight) throws Exception {
        WordprocessingMLPackage wmlPackage = (WordprocessingMLPackage)this.getPackage();
        List sections = wmlPackage.getDocumentModel().getSections();
        PageDimensions page = ((SectionWrapper)sections.get(sections.size() - 1)).getPageDimensions();
        ImageSize size = this.myAbstractImage.getImageInfo().getSize();
        BinaryPartAbstractImage.CxCy cxcy = BinaryPartAbstractImage.scale(this.myAbstractImage.getImageInfo(), page, maxWidth, maxHeight);
        return this.createImageInline(filenameHint, altText, id1, id2, cxcy.getCx(), cxcy.getCy(), link);
    }

    public static BinaryPartAbstractImage createImagePart(OpcPackage opcPackage, Part sourcePart, byte[] bytes) throws Exception {
        return new BinaryPartAbstractImage(org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage.createImagePart((OpcPackage)opcPackage, (Part)sourcePart, (byte[])bytes));
    }

    @Deprecated
    public ImageInfo getImageInfo() {
        return this.myAbstractImage.getImageInfo();
    }

    @Deprecated
    public void setImageInfo(ImageInfo imageInfo) {
        this.myAbstractImage.setImageInfo(imageInfo);
    }

    public List<Relationship> getRels() {
        return this.myAbstractImage.getRels();
    }

    public Relationship getRelLast() {
        return this.myAbstractImage.getRelLast();
    }

    public static void setDensity(int density) {
        org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage.setDensity((int)density);
    }

    public static org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage createImagePart(WordprocessingMLPackage wordMLPackage, byte[] bytes) throws Exception {
        return org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)wordMLPackage, (byte[])bytes);
    }

    public static org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage createImagePart(WordprocessingMLPackage wordMLPackage, File imageFile) throws Exception {
        return org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)wordMLPackage, (File)imageFile);
    }

    @Deprecated
    public static String createImageName(Base sourcePart, String proposedRelId, String ext) {
        return org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage.createImageName((Base)sourcePart, (String)proposedRelId, (String)ext);
    }

    public static String createImageName(OpcPackage opcPackage, Base sourcePart, String proposedRelId, String ext) {
        return org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage.createImageName((OpcPackage)opcPackage, (Base)sourcePart, (String)proposedRelId, (String)ext);
    }

    @Deprecated
    public static org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage createImagePart(OpcPackage opcPackage, Part sourcePart, byte[] bytes, String mime, String ext) throws Exception {
        return org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage.createImagePart((OpcPackage)opcPackage, (Part)sourcePart, (byte[])bytes, (String)mime, (String)ext);
    }

    public static org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage createImagePart(OpcPackage opcPackage, Part sourcePart, byte[] bytes, String mime) throws Exception {
        return org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage.createImagePart((OpcPackage)opcPackage, (Part)sourcePart, (byte[])bytes, (String)mime);
    }

    public static org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage createImagePart(OpcPackage opcPackage, Part sourcePart, File imageFile) throws Exception {
        return org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage.createImagePart((OpcPackage)opcPackage, (Part)sourcePart, (File)imageFile);
    }

    public static org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage createLinkedImagePart(WordprocessingMLPackage wordMLPackage, URL fileurl) throws Exception {
        return org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage.createLinkedImagePart((WordprocessingMLPackage)wordMLPackage, (URL)fileurl);
    }

    public static org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage createLinkedImagePart(OpcPackage opcPackage, Part sourcePart, URL url) throws Exception {
        return org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage.createLinkedImagePart((OpcPackage)opcPackage, (Part)sourcePart, (URL)url);
    }

    @Deprecated
    public Inline createImageInline(String filenameHint, String altText, int id1, int id2) throws Exception {
        return this.myAbstractImage.createImageInline(filenameHint, altText, (long)id1, id2);
    }

    public Inline createImageInline(String filenameHint, String altText, int id1, int id2, boolean link) throws Exception {
        return this.myAbstractImage.createImageInline(filenameHint, altText, (long)id1, id2, link);
    }

    public Inline createImageInline(String filenameHint, String altText, int id1, int id2, boolean link, int maxWidth) throws Exception {
        return this.myAbstractImage.createImageInline(filenameHint, altText, (long)id1, id2, link, maxWidth);
    }

    @Deprecated
    public Inline createImageInline(String filenameHint, String altText, int id1, int id2, long cx) throws Exception {
        return this.myAbstractImage.createImageInline(filenameHint, altText, (long)id1, id2, cx);
    }

    public Inline createImageInline(String filenameHint, String altText, int id1, int id2, long cx, boolean link) throws Exception {
        return this.myAbstractImage.createImageInline(filenameHint, altText, (long)id1, id2, cx, link);
    }

    public Inline createImageInline(String filenameHint, String altText, int id1, int id2, long cx, long cy, boolean link) throws Exception {
        return this.myAbstractImage.createImageInline(filenameHint, altText, (long)id1, id2, cx, cy, link);
    }

    public static ImageInfo getImageInfo(URL url) throws Exception {
        return org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage.getImageInfo((URL)url);
    }

    public static void main(String[] args) throws Exception {
        org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage.main((String[])args);
    }

    public static void displayImageInfo(ImageInfo info) {
        org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage.displayImageInfo((ImageInfo)info);
    }

    public static byte[] getImage(WordprocessingMLPackage wmlPkg, Graphic graphic) {
        return org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage.getImage((WordprocessingMLPackage)wmlPkg, (Graphic)graphic);
    }

    public static void convertToPNG(InputStream is, OutputStream os, int density) throws IOException, InterruptedException {
        org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage.convertToPNG((InputStream)is, (OutputStream)os, (int)density);
    }

    public static void copy2(InputStream is, OutputStream os) throws IOException {
        org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage.copy2((InputStream)is, (OutputStream)os);
    }

    public ExternalTarget getExternalTarget() {
        return this.myAbstractImage.getExternalTarget();
    }

    public void setBinaryData(InputStream binaryData) {
        this.myAbstractImage.setBinaryData(binaryData);
    }

    public void setBinaryData(byte[] bytes) {
        this.myAbstractImage.setBinaryData(bytes);
    }

    public void setBinaryData(ByteBuffer bb) {
        this.myAbstractImage.setBinaryData(bb);
    }

    public boolean isLoaded() {
        return this.myAbstractImage.isLoaded();
    }

    public ByteBuffer getBuffer() {
        return this.myAbstractImage.getBuffer();
    }

    public void writeDataToOutputStream(OutputStream out) throws IOException {
        this.myAbstractImage.writeDataToOutputStream(out);
    }

    public byte[] getBytes() {
        return this.myAbstractImage.getBytes();
    }

    public boolean isContentEqual(Part other) throws Docx4JException {
        return this.myAbstractImage.isContentEqual(other);
    }

    public List<Relationship> getSourceRelationships() {
        return this.myAbstractImage.getSourceRelationships();
    }

    @Deprecated
    public Relationship getSourceRelationship() {
        return this.myAbstractImage.getSourceRelationship();
    }

    @Deprecated
    public void setSourceRelationship(Relationship sourceRelationship) {
        this.myAbstractImage.setSourceRelationship(sourceRelationship);
    }

    public String getRelationshipType() {
        return this.myAbstractImage.getRelationshipType();
    }

    public void setRelationshipType(String relationshipType) {
        this.myAbstractImage.setRelationshipType(relationshipType);
    }

    @Deprecated
    public RelationshipsPart getOwningRelationshipPart() {
        return this.myAbstractImage.getOwningRelationshipPart();
    }

    @Deprecated
    public void setOwningRelationshipPart(RelationshipsPart owningRelationshipPart) {
        this.myAbstractImage.setOwningRelationshipPart(owningRelationshipPart);
    }

    public long getContentLengthAsLoaded() {
        return this.myAbstractImage.getContentLengthAsLoaded();
    }

    public OpcPackage getPackage() {
        return this.myAbstractImage.getPackage();
    }

    public void setPackage(OpcPackage pack) {
        this.myAbstractImage.setPackage(pack);
    }

    public boolean setPartShortcut(Part part, String relationshipType) {
        return this.myAbstractImage.setPartShortcut(part, relationshipType);
    }

    public void setVersion(long version) {
        this.myAbstractImage.setVersion(version);
    }

    public long getVersion() {
        return this.myAbstractImage.getVersion();
    }

    public void rename(PartName newName) {
        this.myAbstractImage.rename(newName);
    }

    public void remove() {
        this.myAbstractImage.remove();
    }

    public Object getUserData(String key) {
        return this.myAbstractImage.getUserData(key);
    }

    public void setUserData(String key, Object value) {
        this.myAbstractImage.setUserData(key, value);
    }

    public RelationshipsPart getRelationshipsPart() {
        return this.myAbstractImage.getRelationshipsPart();
    }

    public RelationshipsPart getRelationshipsPart(boolean createIfAbsent) {
        return this.myAbstractImage.getRelationshipsPart(createIfAbsent);
    }

    public void setRelationships(RelationshipsPart relationships) {
        this.myAbstractImage.setRelationships(relationships);
    }

    public String getContentType() {
        return this.myAbstractImage.getContentType();
    }

    public void setContentType(ContentType contentType) {
        this.myAbstractImage.setContentType(contentType);
    }

    public void setPartName(PartName partName) {
        this.myAbstractImage.setPartName(partName);
    }

    public PartName getPartName() {
        return this.myAbstractImage.getPartName();
    }

    public Relationship addTargetPart(Part targetpart, RelationshipsPart.AddPartBehaviour mode) throws InvalidFormatException {
        return this.myAbstractImage.addTargetPart(targetpart, mode);
    }

    public Relationship addTargetPart(Part targetpart) throws InvalidFormatException {
        return this.myAbstractImage.addTargetPart(targetpart);
    }

    public Relationship addTargetPart(Part targetpart, String proposedRelId) throws InvalidFormatException {
        return this.myAbstractImage.addTargetPart(targetpart, proposedRelId);
    }

    public Relationship addTargetPart(Part targetpart, RelationshipsPart.AddPartBehaviour mode, String proposedRelId) throws InvalidFormatException {
        return this.myAbstractImage.addTargetPart(targetpart, mode, proposedRelId);
    }

    public void reset() {
        this.myAbstractImage.reset();
    }
}

