/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter;

import com.vladsch.flexmark.Extension;
import com.vladsch.flexmark.docx.converter.DocxRendererContext;
import com.vladsch.flexmark.docx.converter.DocxRendererOptions;
import com.vladsch.flexmark.docx.converter.DocxRendererPhase;
import com.vladsch.flexmark.docx.converter.NodeDocxRenderer;
import com.vladsch.flexmark.docx.converter.NodeDocxRendererFactory;
import com.vladsch.flexmark.docx.converter.NodeDocxRendererHandler;
import com.vladsch.flexmark.docx.converter.PhasedNodeDocxRenderer;
import com.vladsch.flexmark.docx.converter.internal.CoreNodeDocxRenderer;
import com.vladsch.flexmark.docx.converter.internal.DocxLinkResolver;
import com.vladsch.flexmark.docx.converter.util.DocumentContentHandler;
import com.vladsch.flexmark.docx.converter.util.DocxContextImpl;
import com.vladsch.flexmark.docx.converter.util.XmlDocxSorter;
import com.vladsch.flexmark.docx.converter.util.XmlFormatter;
import com.vladsch.flexmark.ext.emoji.EmojiExtension;
import com.vladsch.flexmark.html.AttributeProvider;
import com.vladsch.flexmark.html.AttributeProviderFactory;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.RendererBuilder;
import com.vladsch.flexmark.html.RendererExtension;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.HeaderIdGenerator;
import com.vladsch.flexmark.html.renderer.HeaderIdGeneratorFactory;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.html.renderer.LinkResolverContext;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.IRender;
import com.vladsch.flexmark.util.ast.AllNodesVisitor;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.collection.DataValueFactory;
import com.vladsch.flexmark.util.collection.DynamicDefaultKey;
import com.vladsch.flexmark.util.collection.NodeCollectingVisitor;
import com.vladsch.flexmark.util.collection.SubClassingBag;
import com.vladsch.flexmark.util.collection.TwoWayHashMap;
import com.vladsch.flexmark.util.dependency.FlatDependencyHandler;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import com.vladsch.flexmark.util.options.DataSet;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import com.vladsch.flexmark.util.options.ScopedDataSet;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.Numbering;
import org.docx4j.wml.Styles;

public class DocxRenderer
implements IRender {
    public static final DataKey<String> STYLES_XML = new DataKey("STYLES_XML", (Object)DocxRenderer.getResourceString("/styles.xml"));
    public static final DataKey<String> NUMBERING_XML = new DataKey("NUMBERING_XML", (Object)DocxRenderer.getResourceString("/numbering.xml"));
    public static final DataKey<Boolean> RENDER_BODY_ONLY = new DataKey("RENDER_BODY_ONLY", (Object)false);
    public static final DataKey<Integer> MAX_IMAGE_WIDTH = new DataKey("MAX_IMAGE_WIDTH", (Object)0);
    public static final DataKey<Boolean> DEFAULT_LINK_RESOLVER = new DataKey("DEFAULT_LINK_RESOLVER", (Object)true);
    public static final DataKey<String> DOC_RELATIVE_URL = new DataKey("DOC_RELATIVE_URL", (Object)"");
    public static final DataKey<String> DOC_ROOT_URL = new DataKey("DOC_ROOT_URL", (Object)"");
    public static final DataKey<Boolean> PREFIX_WWW_LINKS = new DataKey("PREFIX_WWW_LINKS", (Object)true);
    public static final DataKey<Boolean> RECHECK_UNDEFINED_REFERENCES = HtmlRenderer.RECHECK_UNDEFINED_REFERENCES;
    public static final DataKey<Boolean> PERCENT_ENCODE_URLS = HtmlRenderer.PERCENT_ENCODE_URLS;
    public static final DataKey<Boolean> ESCAPE_HTML = HtmlRenderer.ESCAPE_HTML;
    public static final DataKey<Boolean> ESCAPE_HTML_BLOCKS = HtmlRenderer.ESCAPE_HTML_BLOCKS;
    public static final DataKey<Boolean> ESCAPE_HTML_COMMENT_BLOCKS = HtmlRenderer.ESCAPE_HTML_COMMENT_BLOCKS;
    public static final DataKey<Boolean> ESCAPE_INLINE_HTML = HtmlRenderer.ESCAPE_INLINE_HTML;
    public static final DataKey<Boolean> ESCAPE_INLINE_HTML_COMMENTS = HtmlRenderer.ESCAPE_INLINE_HTML_COMMENTS;
    public static final DataKey<Boolean> SUPPRESS_HTML = HtmlRenderer.SUPPRESS_HTML;
    public static final DataKey<Boolean> SUPPRESS_HTML_BLOCKS = HtmlRenderer.SUPPRESS_HTML_BLOCKS;
    public static final DataKey<Boolean> SUPPRESS_HTML_COMMENT_BLOCKS = HtmlRenderer.SUPPRESS_HTML_COMMENT_BLOCKS;
    public static final DataKey<Boolean> SUPPRESS_INLINE_HTML = HtmlRenderer.SUPPRESS_INLINE_HTML;
    public static final DataKey<Boolean> SUPPRESS_INLINE_HTML_COMMENTS = HtmlRenderer.SUPPRESS_INLINE_HTML_COMMENTS;
    public static final DataKey<Boolean> LINEBREAK_ON_INLINE_HTML_BR = new DataKey("LINEBREAK_ON_INLINE_HTML_BR", (Object)true);
    public static final DataKey<Boolean> TABLE_CAPTION_TO_PARAGRAPH = new DataKey("TABLE_CAPTION_TO_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> TABLE_CAPTION_BEFORE_TABLE = new DataKey("TABLE_CAPTION_BEFORE_TABLE", (Object)false);
    public static final DataKey<Integer> TABLE_PREFERRED_WIDTH_PCT = new DataKey("TABLE_PREFERRED_WIDTH_PCT", (Object)0);
    public static final DataKey<Integer> TABLE_LEFT_INDENT = new DataKey("TABLE_LEFT_INDENT", (Object)120);
    public static final DataKey<String> TABLE_STYLE = new DataKey("TABLE_STYLE", (Object)"");
    public static final DataKey<Boolean> TOC_GENERATE = new DataKey("TOC_GENERATE", (Object)false);
    public static final DataKey<String> TOC_INSTRUCTION = new DataKey("TOC_INSTRUCTION", (Object)"TOC \\o \"1-3\" \\h \\z \\u ");
    public static final DataKey<Boolean> LOG_IMAGE_PROCESSING = new DataKey("LOG_IMAGE_PROCESSING", (Object)false);
    public static final DataKey<Boolean> NO_CHARACTER_STYLES = new DataKey("NO_CHARACTER_STYLES", (Object)false);
    public static final DataKey<String> CODE_HIGHLIGHT_SHADING = new DataKey("CODE_HIGHLIGHT_SHADING", (Object)"");
    public static final DataKey<Boolean> ERRORS_TO_STDERR = new DataKey("ERRORS_TO_STDERR", (Object)false);
    public static final DataKey<String> ERROR_SOURCE_FILE = new DataKey("ERROR_SOURCE_FILE", (Object)"");
    public static final DataKey<Double> DOC_EMOJI_IMAGE_VERT_OFFSET = new DataKey("DOC_EMOJI_IMAGE_VERT_OFFSET", (Object)-0.1);
    public static final DataKey<Double> DOC_EMOJI_IMAGE_VERT_SIZE = new DataKey("DOC_EMOJI_IMAGE_VERT_SIZE", (Object)1.05);
    public static final DataKey<Boolean> HEADER_ID_GENERATOR_RESOLVE_DUPES = HtmlRenderer.HEADER_ID_GENERATOR_RESOLVE_DUPES;
    public static final DataKey<String> HEADER_ID_GENERATOR_TO_DASH_CHARS = HtmlRenderer.HEADER_ID_GENERATOR_TO_DASH_CHARS;
    public static final DataKey<Boolean> HEADER_ID_GENERATOR_NO_DUPED_DASHES = HtmlRenderer.HEADER_ID_GENERATOR_NO_DUPED_DASHES;
    public static final DataKey<Boolean> RENDER_HEADER_ID = HtmlRenderer.RENDER_HEADER_ID;
    public static final DataKey<String> LOCAL_HYPERLINK_SUFFIX = new DataKey("LOCAL_HYPERLINK_SUFFIX", (Object)"");
    public static final DataKey<String> LOCAL_HYPERLINK_MISSING_HIGHLIGHT = new DataKey("LOCAL_HYPERLINK_MISSING_HIGHLIGHT", (Object)"red");
    public static final DataKey<String> LOCAL_HYPERLINK_MISSING_FORMAT = new DataKey("LOCAL_HYPERLINK_MISSING_FORMAT", (Object)"Missing target id: #%s");
    public static final DataKey<String> ASIDE_BLOCK_STYLE = new DataKey("ASIDE_BLOCK_STYLE", (Object)"AsideBlock");
    public static final DataKey<String> BLOCK_QUOTE_STYLE = new DataKey("BLOCK_QUOTE_STYLE", (Object)"Quotations");
    public static final DataKey<String> BOLD_STYLE = new DataKey("BOLD_STYLE", (Object)"StrongEmphasis");
    public static final DataKey<String> DEFAULT_STYLE = new DataKey("DEFAULT_STYLE", (Object)"Normal");
    public static final DataKey<String> ENDNOTE_ANCHOR_STYLE = new DataKey("ENDNOTE_ANCHOR_STYLE", (Object)"EndnoteReference");
    public static final DataKey<String> FOOTER = new DataKey("FOOTER", (Object)"Footer");
    public static final DataKey<String> FOOTNOTE_ANCHOR_STYLE = new DataKey("FOOTNOTE_ANCHOR_STYLE", (Object)"FootnoteReference");
    public static final DataKey<String> FOOTNOTE_STYLE = new DataKey("FOOTNOTE_STYLE", (Object)"Footnote");
    public static final DataKey<String> FOOTNOTE_TEXT = new DataKey("FOOTNOTE_TEXT", (Object)"FootnoteText");
    public static final DataKey<String> HEADER = new DataKey("HEADER", (Object)"Header");
    public static final DataKey<String> HEADING_1 = new DataKey("HEADING_1", (Object)"Heading1");
    public static final DataKey<String> HEADING_2 = new DataKey("HEADING_2", (Object)"Heading2");
    public static final DataKey<String> HEADING_3 = new DataKey("HEADING_3", (Object)"Heading3");
    public static final DataKey<String> HEADING_4 = new DataKey("HEADING_4", (Object)"Heading4");
    public static final DataKey<String> HEADING_5 = new DataKey("HEADING_5", (Object)"Heading5");
    public static final DataKey<String> HEADING_6 = new DataKey("HEADING_6", (Object)"Heading6");
    public static final DataKey<String> HORIZONTAL_LINE_STYLE = new DataKey("HORIZONTAL_LINE_STYLE", (Object)"HorizontalLine");
    public static final DataKey<String> HYPERLINK_STYLE = new DataKey("HYPERLINK_STYLE", (Object)"Hyperlink");
    public static final DataKey<String> INLINE_CODE_STYLE = new DataKey("INLINE_CODE_STYLE", (Object)"SourceText");
    public static final DataKey<String> INS_STYLE = new DataKey("INS_STYLE", (Object)"Underlined");
    public static final DataKey<String> ITALIC_STYLE = new DataKey("ITALIC_STYLE", (Object)"Emphasis");
    public static final DataKey<String> LOOSE_PARAGRAPH_STYLE = new DataKey("LOOSE_PARAGRAPH_STYLE", (Object)"ParagraphTextBody");
    public static final DataKey<String> PREFORMATTED_TEXT_STYLE = new DataKey("PREFORMATTED_TEXT_STYLE", (Object)"PreformattedText");
    public static final DataKey<String> STRIKE_THROUGH_STYLE = new DataKey("STRIKE_THROUGH_STYLE", (Object)"Strikethrough");
    public static final DataKey<String> SUBSCRIPT_STYLE = new DataKey("SUBSCRIPT_STYLE", (Object)"Subscript");
    public static final DataKey<String> SUPERSCRIPT_STYLE = new DataKey("SUPERSCRIPT_STYLE", (Object)"Superscript");
    public static final DataKey<String> TABLE_CAPTION = new DataKey("TABLE_CAPTION", (Object)"TableCaption");
    public static final DataKey<String> TABLE_CONTENTS = new DataKey("TABLE_CONTENTS", (Object)"TableContents");
    public static final DataKey<String> TABLE_GRID = new DataKey("TABLE_GRID", (Object)"TableGrid");
    public static final DataKey<String> TABLE_HEADING = new DataKey("TABLE_HEADING", (Object)"TableHeading");
    public static final DataKey<String> TIGHT_PARAGRAPH_STYLE = new DataKey("TIGHT_PARAGRAPH_STYLE", (Object)"BodyText");
    public static final String EMOJI_RESOURCE_PREFIX = "emoji:";
    public static final DynamicDefaultKey<String> DOC_EMOJI_ROOT_IMAGE_PATH = new DynamicDefaultKey("DOC_EMOJI_ROOT_IMAGE_PATH", (DataValueFactory)new DataValueFactory<String>(){

        public String create(DataHolder options) {
            if (options != null && options.contains(EmojiExtension.ROOT_IMAGE_PATH)) {
                return (String)options.get(EmojiExtension.ROOT_IMAGE_PATH);
            }
            return DocxRenderer.EMOJI_RESOURCE_PREFIX;
        }
    });
    final List<NodeDocxRendererFactory> nodeFormatterFactories;
    private final DataHolder options;
    private final Builder builder;
    final List<LinkResolverFactory> linkResolverFactories;
    final List<AttributeProviderFactory> attributeProviderFactories;
    final HeaderIdGeneratorFactory htmlIdGeneratorFactory;
    private static final Iterator<? extends Node> NULL_ITERATOR = new Iterator<Node>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Node next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };
    static final Iterable<? extends Node> NULL_ITERABLE = new Iterable<Node>(){

        @Override
        public Iterator<Node> iterator() {
            return null;
        }
    };

    private DocxRenderer(Builder builder) {
        this.builder = new Builder(builder);
        this.options = new DataSet((DataHolder)builder);
        this.htmlIdGeneratorFactory = builder.htmlIdGeneratorFactory;
        this.nodeFormatterFactories = new ArrayList<NodeDocxRendererFactory>(builder.nodeDocxRendererFactories.size() + 1);
        this.nodeFormatterFactories.addAll(builder.nodeDocxRendererFactories);
        this.nodeFormatterFactories.add(new NodeDocxRendererFactory(){

            @Override
            public NodeDocxRenderer create(DataHolder options) {
                return new CoreNodeDocxRenderer(options);
            }
        });
        this.attributeProviderFactories = FlatDependencyHandler.computeDependencies(builder.attributeProviderFactories);
        this.linkResolverFactories = FlatDependencyHandler.computeDependencies(builder.linkResolverFactories);
    }

    public DataHolder getOptions() {
        return new DataSet((DataHolder)this.builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataHolder options) {
        return new Builder(options);
    }

    public static WordprocessingMLPackage getDefaultTemplate() {
        return DocxRenderer.getDefaultTemplate("/empty.xml");
    }

    public static WordprocessingMLPackage getDefaultTemplate(String emptyXMLResourcePath) {
        InputStream inputStream = DocxRenderer.getResourceInputStream(emptyXMLResourcePath);
        return DocxRenderer.getDefaultTemplate(inputStream);
    }

    public static WordprocessingMLPackage getDefaultTemplate(InputStream inputStream) {
        try {
            WordprocessingMLPackage mlPackage = WordprocessingMLPackage.load((InputStream)inputStream);
            return mlPackage;
        }
        catch (Docx4JException e) {
            e.printStackTrace();
            return null;
        }
    }

    static void setDefaultStyleAndNumbering(WordprocessingMLPackage out, DataHolder options) {
        try {
            MainDocumentPart documentPart = out.getMainDocumentPart();
            if (documentPart == null) {
                try {
                    documentPart = new MainDocumentPart();
                    out.addTargetPart((Part)documentPart);
                }
                catch (InvalidFormatException e) {
                    e.printStackTrace();
                }
            }
            if (documentPart.getStyleDefinitionsPart() == null) {
                StyleDefinitionsPart stylesPart = new StyleDefinitionsPart();
                Styles styles = (Styles)XmlUtils.unmarshalString((String)((String)STYLES_XML.getFrom(options)));
                stylesPart.setJaxbElement(styles);
                documentPart.addTargetPart((Part)stylesPart);
                assert (documentPart.getStyleDefinitionsPart() != null) : "Styles failed to set";
            }
            if (documentPart.getNumberingDefinitionsPart() == null) {
                NumberingDefinitionsPart numberingPart = new NumberingDefinitionsPart();
                Numbering numbering = (Numbering)XmlUtils.unmarshalString((String)((String)NUMBERING_XML.getFrom(options)));
                numberingPart.setJaxbElement((Object)numbering);
                documentPart.addTargetPart((Part)numberingPart);
                assert (documentPart.getNumberingDefinitionsPart() != null) : "Numbering failed to set";
            }
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void render(Node node, WordprocessingMLPackage output) {
        MainDocxRenderer renderer = new MainDocxRenderer(this.options, output, node.getDocument(), null);
        renderer.render(node);
    }

    public void render(Node node, WordprocessingMLPackage output, DocumentContentHandler contentContainer) {
        MainDocxRenderer renderer = new MainDocxRenderer(this.options, output, node.getDocument(), contentContainer);
        if (contentContainer != null) {
            contentContainer.startDocumentRendering(renderer);
        }
        renderer.render(node);
        if (contentContainer != null) {
            contentContainer.endDocumentRendering(renderer);
        }
    }

    public String render(Node node) {
        WordprocessingMLPackage mlPackage = DocxRenderer.getDefaultTemplate();
        this.render(node, mlPackage);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            mlPackage.save((OutputStream)outputStream, 2);
            String s = (Boolean)this.options.get(RENDER_BODY_ONLY) != false ? XmlFormatter.formatDocumentBody(outputStream.toString("UTF-8")) : XmlDocxSorter.sortDocumentParts(outputStream.toString("UTF-8"));
            return s;
        }
        catch (Docx4JException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void render(Node node, Appendable output) {
        String docx = this.render(node);
        try {
            output.append(docx);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public DocxRenderer withOptions(DataHolder options) {
        return options == null ? this : new DocxRenderer(new Builder(this.builder, options));
    }

    public static String getResourceString(String resourcePath) {
        try {
            String line;
            InputStream stream = DocxRenderer.getResourceInputStream(resourcePath);
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charset.forName("UTF-8")));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream getResourceInputStream(String resourcePath) {
        String specPath = resourcePath != null ? resourcePath : "/spec.txt";
        InputStream stream = DocxRenderer.class.getResourceAsStream(specPath);
        if (stream == null) {
            throw new IllegalStateException("Could not load " + resourcePath + " classpath resource");
        }
        return stream;
    }

    private class MainDocxRenderer
    extends DocxContextImpl<Node>
    implements DocxRendererContext {
        private final Document document;
        private final Map<Class<?>, NodeDocxRendererHandler> renderers;
        private final SubClassingBag<Node> collectedNodes;
        final HashSet<Class<?>> bookmarkWrapsChildren;
        private final List<PhasedNodeDocxRenderer> phasedFormatters;
        private final Set<DocxRendererPhase> renderingPhases;
        private DocxRendererPhase phase;
        Node renderingNode;
        private final LinkResolver[] myLinkResolvers;
        private final HashMap<LinkType, HashMap<String, ResolvedLink>> resolvedLinkMap;
        private final AttributeProvider[] myAttributeProviders;
        private final HtmlIdGenerator htmlIdGenerator;
        final TwoWayHashMap<Node, String> nodeIdMap;
        final HashMap<String, Integer> baseIdToSerial;
        final HashMap<String, String> idToValidBookmark;
        final DocxRendererOptions rendererOptions;

        MainDocxRenderer(DataHolder options, WordprocessingMLPackage out, Document document, DocumentContentHandler contentContainer) {
            int i;
            super(out, (DataHolder)new ScopedDataSet((DataHolder)document, options));
            this.resolvedLinkMap = new HashMap();
            this.rendererOptions = this.myRendererOptions;
            this.document = document;
            this.renderers = new HashMap(32);
            this.renderingPhases = new HashSet<DocxRendererPhase>(DocxRendererPhase.values().length);
            HashSet collectNodeTypes = new HashSet(100);
            this.phasedFormatters = new ArrayList<PhasedNodeDocxRenderer>(DocxRenderer.this.nodeFormatterFactories.size());
            Boolean defaultLinkResolver = (Boolean)DEFAULT_LINK_RESOLVER.getFrom(options);
            this.myLinkResolvers = new LinkResolver[DocxRenderer.this.linkResolverFactories.size() + (defaultLinkResolver != false ? 1 : 0)];
            this.htmlIdGenerator = DocxRenderer.this.htmlIdGeneratorFactory != null ? DocxRenderer.this.htmlIdGeneratorFactory.create((LinkResolverContext)this) : new HeaderIdGenerator.Factory().create((LinkResolverContext)this);
            this.bookmarkWrapsChildren = new HashSet();
            this.nodeIdMap = new TwoWayHashMap();
            this.baseIdToSerial = new HashMap();
            this.idToValidBookmark = new HashMap();
            DocxRenderer.setDefaultStyleAndNumbering(out, this.options);
            this.myBlockFormatProviders.put(document, this);
            this.myRunFormatProviders.put(document, this);
            for (i = 0; i < DocxRenderer.this.linkResolverFactories.size(); ++i) {
                this.myLinkResolvers[i] = DocxRenderer.this.linkResolverFactories.get(i).create((LinkResolverContext)this);
            }
            if (defaultLinkResolver.booleanValue()) {
                this.myLinkResolvers[DocxRenderer.this.linkResolverFactories.size()] = new DocxLinkResolver.Factory().create(this);
            }
            this.myAttributeProviders = new AttributeProvider[DocxRenderer.this.attributeProviderFactories.size()];
            for (i = 0; i < DocxRenderer.this.attributeProviderFactories.size(); ++i) {
                this.myAttributeProviders[i] = DocxRenderer.this.attributeProviderFactories.get(i).create((LinkResolverContext)this);
            }
            for (i = DocxRenderer.this.nodeFormatterFactories.size() - 1; i >= 0; --i) {
                Set<Class<?>> wrapChildrenClasses;
                NodeDocxRendererFactory nodeDocxRendererFactory = DocxRenderer.this.nodeFormatterFactories.get(i);
                NodeDocxRenderer nodeDocxRenderer = nodeDocxRendererFactory.create(this.getOptions());
                Set<NodeDocxRendererHandler<?>> formattingHandlers = nodeDocxRenderer.getNodeFormattingHandlers();
                if (formattingHandlers == null) continue;
                for (NodeDocxRendererHandler<?> nodeType : formattingHandlers) {
                    this.renderers.put(nodeType.getNodeType(), nodeType);
                }
                Set<Class<?>> nodeClasses = nodeDocxRenderer.getNodeClasses();
                if (nodeClasses != null) {
                    collectNodeTypes.addAll(nodeClasses);
                }
                if ((wrapChildrenClasses = nodeDocxRenderer.getBookmarkWrapsChildrenClasses()) != null) {
                    this.bookmarkWrapsChildren.addAll(wrapChildrenClasses);
                }
                if (!(nodeDocxRenderer instanceof PhasedNodeDocxRenderer)) continue;
                Set<DocxRendererPhase> phases = ((PhasedNodeDocxRenderer)nodeDocxRenderer).getFormattingPhases();
                if (phases != null) {
                    if (phases.isEmpty()) {
                        throw new IllegalStateException("PhasedNodeDocxRenderer with empty Phases");
                    }
                    this.renderingPhases.addAll(phases);
                    this.phasedFormatters.add((PhasedNodeDocxRenderer)nodeDocxRenderer);
                    continue;
                }
                throw new IllegalStateException("PhasedNodeDocxRenderer with null Phases");
            }
            if (!collectNodeTypes.isEmpty()) {
                NodeCollectingVisitor collectingVisitor = new NodeCollectingVisitor(collectNodeTypes);
                collectingVisitor.collect((Node)document);
                this.collectedNodes = collectingVisitor.getSubClassingBag();
            } else {
                this.collectedNodes = null;
            }
            if (contentContainer != null) {
                this.setContentContainer(contentContainer);
            }
        }

        String calculateNodeId(Node node) {
            String id = this.htmlIdGenerator.getId(node);
            if (DocxRenderer.this.attributeProviderFactories.size() != 0) {
                Attributes attributes = new Attributes();
                if (id != null) {
                    attributes.replaceValue((CharSequence)"id", (CharSequence)id);
                }
                for (AttributeProvider attributeProvider : this.myAttributeProviders) {
                    attributeProvider.setAttributes(node, AttributablePart.ID, attributes);
                }
                id = attributes.getValue((CharSequence)"id");
            }
            return id == null ? "" : id;
        }

        @Override
        public String getNodeId(Node node) {
            String id = (String)this.nodeIdMap.getSecond((Object)node);
            return id;
        }

        @Override
        public String getValidBookmarkName(String id) {
            Integer baseSerial;
            String validBookmark = this.idToValidBookmark.get(id);
            if (validBookmark != null) {
                return validBookmark;
            }
            if (id.length() < 32) {
                this.idToValidBookmark.put(id, id);
                return id;
            }
            String baseId = id.substring(0, 32);
            if (baseId.endsWith("-") || baseId.endsWith("_")) {
                baseId = baseId.substring(0, baseId.length() - 1);
            }
            if ((baseSerial = this.baseIdToSerial.get(baseId)) == null) {
                baseSerial = 0;
            }
            this.baseIdToSerial.put(baseId, baseSerial + 1);
            validBookmark = String.format("%s-%d", baseId, baseSerial);
            this.idToValidBookmark.put(id, validBookmark);
            return validBookmark;
        }

        @Override
        public Node getNodeFromId(String nodeId) {
            return (Node)this.nodeIdMap.getFirst((Object)nodeId);
        }

        public String encodeUrl(CharSequence url) {
            if (this.rendererOptions.percentEncodeUrls) {
                return Escaping.percentEncodeUrl((CharSequence)url);
            }
            return String.valueOf(url);
        }

        @Override
        public Attributes extendRenderingNodeAttributes(AttributablePart part, Attributes attributes) {
            Attributes attr = attributes != null ? attributes : new Attributes();
            for (AttributeProvider attributeProvider : this.myAttributeProviders) {
                attributeProvider.setAttributes(this.renderingNode, part, attr);
            }
            return attr;
        }

        @Override
        public Attributes extendRenderingNodeAttributes(Node node, AttributablePart part, Attributes attributes) {
            Attributes attr = attributes != null ? attributes : new Attributes();
            for (AttributeProvider attributeProvider : this.myAttributeProviders) {
                attributeProvider.setAttributes(node, part, attr);
            }
            return attr;
        }

        public Node getCurrentNode() {
            return this.renderingNode;
        }

        @Override
        public Node getContextFrame() {
            return this.renderingNode;
        }

        public DataHolder getOptions() {
            return this.options;
        }

        @Override
        public DocxRendererOptions getDocxRendererOptions() {
            return this.rendererOptions;
        }

        public Document getDocument() {
            return this.document;
        }

        @Override
        public DocxRendererPhase getPhase() {
            return this.phase;
        }

        @Override
        public final Iterable<? extends Node> nodesOfType(Class<?>[] classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.itemsOfType(Node.class, (Class[])classes);
        }

        @Override
        public final Iterable<? extends Node> nodesOfType(Collection<Class<?>> classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.itemsOfType(Node.class, classes);
        }

        @Override
        public final Iterable<? extends Node> reversedNodesOfType(Class<?>[] classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.reversedItemsOfType(Node.class, (Class[])classes);
        }

        @Override
        public final Iterable<? extends Node> reversedNodesOfType(Collection<Class<?>> classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.reversedItemsOfType(Node.class, classes);
        }

        public ResolvedLink resolveLink(LinkType linkType, CharSequence url, Boolean urlEncode) {
            return this.resolveLink(linkType, url, null, urlEncode);
        }

        public ResolvedLink resolveLink(LinkType linkType, CharSequence url, Attributes attributes, Boolean urlEncode) {
            String urlSeq;
            ResolvedLink resolvedLink;
            HashMap<String, Object> resolvedLinks = this.resolvedLinkMap.get(linkType);
            if (resolvedLinks == null) {
                resolvedLinks = new HashMap();
                this.resolvedLinkMap.put(linkType, resolvedLinks);
            }
            if ((resolvedLink = (ResolvedLink)resolvedLinks.get(urlSeq = String.valueOf(url))) == null) {
                resolvedLink = new ResolvedLink(linkType, (CharSequence)urlSeq, attributes);
                if (!urlSeq.isEmpty()) {
                    LinkResolver linkResolver;
                    Node currentNode = this.renderingNode;
                    LinkResolver[] linkResolverArray = this.myLinkResolvers;
                    int n = linkResolverArray.length;
                    for (int i = 0; i < n && (resolvedLink = (linkResolver = linkResolverArray[i]).resolveLink(currentNode, (LinkResolverContext)this, resolvedLink)).getStatus() == LinkStatus.UNKNOWN; ++i) {
                    }
                    if (urlEncode == null && this.rendererOptions.percentEncodeUrls || urlEncode != null && urlEncode.booleanValue()) {
                        resolvedLink = resolvedLink.withUrl((CharSequence)Escaping.percentEncodeUrl((CharSequence)resolvedLink.getUrl()));
                    }
                }
                resolvedLinks.put(urlSeq, resolvedLink);
            }
            return resolvedLink;
        }

        public void render(final Node node) {
            if (node instanceof Document) {
                this.htmlIdGenerator.generateIds(this.document);
                new AllNodesVisitor(){

                    protected void process(Node node) {
                        String id = MainDocxRenderer.this.calculateNodeId(node);
                        if (id != null && !id.isEmpty()) {
                            MainDocxRenderer.this.nodeIdMap.add((Object)node, (Object)id);
                        }
                    }
                }.visit((Node)this.document);
                for (DocxRendererPhase phase : DocxRendererPhase.values()) {
                    if (phase != DocxRendererPhase.DOCUMENT && !this.renderingPhases.contains((Object)phase)) continue;
                    this.phase = phase;
                    if (this.phase == DocxRendererPhase.DOCUMENT) {
                        NodeDocxRendererHandler nodeRenderer = this.renderers.get(node.getClass());
                        if (nodeRenderer == null) continue;
                        this.renderingNode = node;
                        nodeRenderer.render(node, (DocxRendererContext)this);
                        this.renderingNode = null;
                        continue;
                    }
                    for (PhasedNodeDocxRenderer phasedFormatter : this.phasedFormatters) {
                        if (!phasedFormatter.getFormattingPhases().contains((Object)phase)) continue;
                        this.renderingNode = node;
                        phasedFormatter.renderDocument(this, (Document)node, phase);
                        this.renderingNode = null;
                    }
                }
            } else {
                NodeDocxRendererHandler nodeRenderer = this.renderers.get(node.getClass());
                if (nodeRenderer == null) {
                    nodeRenderer = this.renderers.get(Node.class);
                }
                if (nodeRenderer != null) {
                    final NodeDocxRendererHandler finalNodeRenderer = nodeRenderer;
                    final Node oldNode = this.renderingNode;
                    this.renderingNode = node;
                    this.contextFramed(new Runnable(){

                        @Override
                        public void run() {
                            String id = MainDocxRenderer.this.getNodeId(node);
                            if (id != null && !id.isEmpty()) {
                                if (!MainDocxRenderer.this.bookmarkWrapsChildren.contains(node.getClass())) {
                                    boolean isBlockBookmark = node instanceof Block;
                                    if (isBlockBookmark) {
                                        CTBookmark bookmarkStart = MainDocxRenderer.this.createBookmarkStart(id, true);
                                        MainDocxRenderer.this.createBookmarkEnd(bookmarkStart, true);
                                        finalNodeRenderer.render(MainDocxRenderer.this.renderingNode, (DocxRendererContext)MainDocxRenderer.this);
                                    } else {
                                        CTBookmark bookmarkStart = MainDocxRenderer.this.createBookmarkStart(id, false);
                                        finalNodeRenderer.render(MainDocxRenderer.this.renderingNode, (DocxRendererContext)MainDocxRenderer.this);
                                        MainDocxRenderer.this.createBookmarkEnd(bookmarkStart, false);
                                    }
                                } else {
                                    finalNodeRenderer.render(MainDocxRenderer.this.renderingNode, (DocxRendererContext)MainDocxRenderer.this);
                                }
                            } else {
                                finalNodeRenderer.render(MainDocxRenderer.this.renderingNode, (DocxRendererContext)MainDocxRenderer.this);
                            }
                            MainDocxRenderer.this.renderingNode = oldNode;
                        }
                    });
                } else {
                    throw new IllegalStateException("Core Node DocxRenderer should implement generic Node renderer");
                }
            }
        }

        void renderChildrenUnwrapped(Node parent) {
            Node node = parent.getFirstChild();
            while (node != null) {
                Node next = node.getNext();
                this.render(node);
                node = next;
            }
        }

        public void renderChildren(Node parent) {
            String id = this.getNodeId(parent);
            if (id != null && !id.isEmpty()) {
                if (this.bookmarkWrapsChildren.contains(parent.getClass())) {
                    CTBookmark bookmarkStart = this.createBookmarkStart(id, false);
                    this.renderChildrenUnwrapped(parent);
                    this.createBookmarkEnd(bookmarkStart, false);
                } else {
                    this.renderChildrenUnwrapped(parent);
                }
            } else {
                this.renderChildrenUnwrapped(parent);
            }
        }

        @Override
        public Node getProviderFrame() {
            return this.document;
        }
    }

    public static interface DocxRendererExtension
    extends Extension {
        public void rendererOptions(MutableDataHolder var1);

        public void extend(Builder var1);
    }

    public static class Builder
    extends MutableDataSet
    implements RendererBuilder {
        List<AttributeProviderFactory> attributeProviderFactories = new ArrayList<AttributeProviderFactory>();
        List<NodeDocxRendererFactory> nodeDocxRendererFactories = new ArrayList<NodeDocxRendererFactory>();
        List<LinkResolverFactory> linkResolverFactories = new ArrayList<LinkResolverFactory>();
        private final HashSet<Extension> loadedExtensions = new HashSet();
        HeaderIdGeneratorFactory htmlIdGeneratorFactory = null;

        public Builder() {
        }

        public Builder(DataHolder options) {
            super(options);
            if (options.contains(Parser.EXTENSIONS)) {
                this.extensions((Iterable)this.get(Parser.EXTENSIONS));
            }
        }

        public Builder(Builder other) {
            super((DataHolder)other);
            this.attributeProviderFactories.addAll(other.attributeProviderFactories);
            this.nodeDocxRendererFactories.addAll(other.nodeDocxRendererFactories);
            this.linkResolverFactories.addAll(other.linkResolverFactories);
            this.loadedExtensions.addAll(other.loadedExtensions);
            this.htmlIdGeneratorFactory = other.htmlIdGeneratorFactory;
        }

        public Builder(Builder other, DataHolder options) {
            super((DataHolder)other);
            ArrayList<Extension> extensions = new ArrayList<Extension>();
            for (Extension extension : (Iterable)this.get(Parser.EXTENSIONS)) {
                extensions.add(extension);
            }
            if (options != null) {
                for (DataKey key : options.keySet()) {
                    if (key == Parser.EXTENSIONS) {
                        for (Extension extension : (Iterable)options.get(Parser.EXTENSIONS)) {
                            extensions.add(extension);
                        }
                        continue;
                    }
                    this.set(key, options.get(key));
                }
            }
            this.set(Parser.EXTENSIONS, extensions);
            this.extensions(extensions);
        }

        public DocxRenderer build() {
            return new DocxRenderer(this);
        }

        public Builder nodeFormatterFactory(NodeDocxRendererFactory nodeDocxRendererFactory) {
            this.nodeDocxRendererFactories.add(nodeDocxRendererFactory);
            return this;
        }

        public Builder linkResolverFactory(LinkResolverFactory linkResolverFactory) {
            this.linkResolverFactories.add(linkResolverFactory);
            return this;
        }

        public Builder attributeProviderFactory(AttributeProviderFactory attributeProviderFactory) {
            this.attributeProviderFactories.add(attributeProviderFactory);
            return this;
        }

        public Builder htmlIdGeneratorFactory(HeaderIdGeneratorFactory htmlIdGeneratorFactory) {
            if (this.htmlIdGeneratorFactory != null) {
                throw new IllegalStateException("custom header id factory is already set to " + htmlIdGeneratorFactory.getClass().getName());
            }
            this.htmlIdGeneratorFactory = htmlIdGeneratorFactory;
            return this;
        }

        public Builder extensions(Iterable<? extends Extension> extensions) {
            DocxRendererExtension docxRendererExtension;
            for (Extension extension : extensions) {
                if (extension instanceof DocxRendererExtension) {
                    if (this.loadedExtensions.contains(extension)) continue;
                    docxRendererExtension = (DocxRendererExtension)extension;
                    docxRendererExtension.rendererOptions((MutableDataHolder)this);
                    continue;
                }
                if (!(extension instanceof RendererExtension) || this.loadedExtensions.contains(extension)) continue;
                docxRendererExtension = (RendererExtension)extension;
                docxRendererExtension.rendererOptions((MutableDataHolder)this);
            }
            for (Extension extension : extensions) {
                if (extension instanceof DocxRendererExtension) {
                    if (this.loadedExtensions.contains(extension)) continue;
                    docxRendererExtension = (DocxRendererExtension)extension;
                    docxRendererExtension.extend(this);
                    this.loadedExtensions.add(docxRendererExtension);
                    continue;
                }
                if (!(extension instanceof RendererExtension) || this.loadedExtensions.contains(extension)) continue;
                RendererExtension htmlRendererExtension = (RendererExtension)extension;
                htmlRendererExtension.extend((RendererBuilder)this, (String)this.get(HtmlRenderer.TYPE));
                this.loadedExtensions.add((Extension)htmlRendererExtension);
            }
            return this;
        }
    }
}

