/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.core.test.util;

import com.vladsch.flexmark.core.test.util.FormatterTranslationSpecTestBase;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.formatter.RenderPurpose;
import com.vladsch.flexmark.formatter.TranslationHandler;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.test.util.ComboSpecTestCase;
import com.vladsch.flexmark.test.util.FlexmarkSpecExampleRenderer;
import com.vladsch.flexmark.test.util.SpecExampleRenderer;
import com.vladsch.flexmark.test.util.TestUtils;
import com.vladsch.flexmark.test.util.spec.SpecExample;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.IParse;
import com.vladsch.flexmark.util.ast.IRender;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TranslationFormatterSpecTest
extends FormatterTranslationSpecTestBase {
    private static final boolean SHOW_INTERMEDIATE = false;
    private static final boolean SHOW_INTERMEDIATE_AST = false;
    public static final DataKey<Boolean> DETAILS = new DataKey("DETAILS", (Object)false);
    public static final DataKey<Boolean> AST_DETAILS = new DataKey("AST_DETAILS", (Object)false);
    private static final DataHolder OPTIONS = new MutableDataSet().set(Parser.HTML_FOR_TRANSLATOR, (Object)true).set(Parser.PARSE_INNER_HTML_COMMENTS, (Object)true).set(Formatter.MAX_TRAILING_BLANK_LINES, (Object)0).toImmutable();
    private static final Map<String, DataHolder> optionsMap = new HashMap<String, DataHolder>();

    public TranslationFormatterSpecTest(@NotNull SpecExample example, @Nullable Map<String, ? extends DataHolder> optionMap, DataHolder ... defaultOptions) {
        super(example, ComboSpecTestCase.optionsMaps(optionsMap, optionMap), ComboSpecTestCase.dataHolders((DataHolder)OPTIONS, (DataHolder[])defaultOptions));
    }

    private Parser getParser(@Nullable DataHolder OPTIONS) {
        return Parser.builder((DataHolder)OPTIONS).build();
    }

    private IRender getRenderer(@Nullable DataHolder OPTIONS) {
        return new TranslationFormatter(Formatter.builder((DataHolder)OPTIONS).build());
    }

    @NotNull
    public final SpecExampleRenderer getSpecExampleRenderer(@NotNull SpecExample example, @Nullable DataHolder exampleOptions) {
        DataHolder combinedOptions = TranslationFormatterSpecTest.aggregate((DataHolder)this.myDefaultOptions, (DataHolder)exampleOptions);
        return new FlexmarkSpecExampleRenderer(example, combinedOptions, (IParse)this.getParser(combinedOptions), this.getRenderer(combinedOptions), true){

            @NotNull
            protected String renderAst() {
                TranslationFormatter translationFormatter = (TranslationFormatter)this.getRenderer();
                if (translationFormatter.isShowIntermediateAst()) {
                    return translationFormatter.getAst();
                }
                return super.renderAst();
            }
        };
    }

    static CharSequence translate(CharSequence text) {
        StringBuilder sb = new StringBuilder();
        int iMax = text.length();
        for (int i = 0; i < iMax; ++i) {
            char c = text.charAt(i);
            if ("htpcom".indexOf(c) != -1) {
                sb.append(c);
                continue;
            }
            if ("aeiouy".indexOf(c) != -1) {
                sb.append(c);
            }
            if (Character.isUpperCase(c)) {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (Character.isLowerCase(c)) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb;
    }

    static {
        optionsMap.put("details", (DataHolder)new MutableDataSet().set(DETAILS, (Object)true));
        optionsMap.put("ast-details", (DataHolder)new MutableDataSet().set(AST_DETAILS, (Object)true));
    }

    static class TranslationFormatter
    implements IRender {
        final Formatter myFormatter;
        boolean myShowIntermediate;
        boolean myShowIntermediateAst;
        @Nullable
        private String myAst = null;

        public TranslationFormatter(Formatter formatter) {
            this.myFormatter = formatter;
            this.myShowIntermediate = (Boolean)DETAILS.get(this.myFormatter.getOptions());
            this.myShowIntermediateAst = (Boolean)AST_DETAILS.get(this.myFormatter.getOptions());
        }

        public boolean isShowIntermediate() {
            return this.myShowIntermediate;
        }

        public boolean isShowIntermediateAst() {
            return this.myShowIntermediateAst;
        }

        @NotNull
        public String getAst() {
            return this.myAst == null ? "" : this.myAst;
        }

        @Nullable
        public DataHolder getOptions() {
            return this.myFormatter.getOptions();
        }

        public void render(@NotNull Node node, @NotNull Appendable output) {
            CharSequence translated;
            Document document = (Document)node;
            TranslationHandler handler = this.myFormatter.getTranslationHandler();
            String formattedOutput = this.myFormatter.translationRender((Node)document, handler, RenderPurpose.TRANSLATION_SPANS);
            List translatingTexts = handler.getTranslatingTexts();
            StringBuilder outputAst = this.myShowIntermediateAst ? new StringBuilder() : null;
            try {
                if (this.myShowIntermediate) {
                    output.append("- Translating Spans ------\n");
                    output.append(formattedOutput);
                    output.append("- Translated Spans --------\n");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.myShowIntermediateAst) {
                outputAst.append("- Original ----------------\n");
                outputAst.append(TestUtils.ast((Node)document));
            }
            ArrayList<CharSequence> translatedTexts = new ArrayList<CharSequence>(translatingTexts.size());
            for (CharSequence text : translatingTexts) {
                translated = TranslationFormatterSpecTest.translate(text);
                translatedTexts.add(translated);
                try {
                    if (!this.myShowIntermediate) continue;
                    output.append("<<<").append(text).append('\n');
                    output.append(">>>").append(translated).append('\n');
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.myShowIntermediate) {
                try {
                    output.append("- Partial ----------------\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            handler.setTranslatedTexts(translatedTexts);
            String partial = this.myFormatter.translationRender((Node)document, handler, RenderPurpose.TRANSLATED_SPANS);
            if (this.myShowIntermediate) {
                try {
                    output.append(partial);
                    output.append("- Translated -------------\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Document partialDoc = Parser.builder((DataHolder)this.getOptions()).build().parse(partial);
            if (this.myShowIntermediateAst) {
                outputAst.append("- Partial ----------------\n");
                outputAst.append(TestUtils.ast((Node)partialDoc));
            }
            translated = this.myFormatter.translationRender((Node)partialDoc, handler, RenderPurpose.TRANSLATED);
            try {
                output.append(translated);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.myShowIntermediateAst) {
                Document translatedDoc = Parser.builder((DataHolder)this.getOptions()).build().parse((String)translated);
                outputAst.append("- Translated -------------\n");
                outputAst.append(TestUtils.ast((Node)translatedDoc));
            }
            if (this.myShowIntermediateAst) {
                this.myAst = outputAst.toString();
            }
        }
    }
}

