/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.flexypool.strategy;

import com.vladmihalcea.flexypool.adaptor.PoolAdapter;
import com.vladmihalcea.flexypool.common.ConfigurationProperties;
import com.vladmihalcea.flexypool.connection.ConnectionRequestContext;
import com.vladmihalcea.flexypool.exception.ConnectionAcquisitionTimeoutException;
import com.vladmihalcea.flexypool.metric.Histogram;
import com.vladmihalcea.flexypool.metric.Metrics;
import com.vladmihalcea.flexypool.strategy.AbstractConnectionAcquisitionStrategy;
import com.vladmihalcea.flexypool.strategy.ConnectionAcquisitionStrategyFactory;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryConnectionAcquisitionStrategy<T extends DataSource>
extends AbstractConnectionAcquisitionStrategy {
    public static final String RETRY_ATTEMPTS_HISTOGRAM = "retryAttemptsHistogram";
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryConnectionAcquisitionStrategy.class);
    private final int retryAttempts;
    private final Histogram retryAttemptsHistogram;

    private RetryConnectionAcquisitionStrategy(ConfigurationProperties<? extends DataSource, Metrics, PoolAdapter> configurationProperties, int retryAttempts) {
        super(configurationProperties);
        this.retryAttempts = this.validateRetryAttempts(retryAttempts);
        this.retryAttemptsHistogram = configurationProperties.getMetrics().histogram(RETRY_ATTEMPTS_HISTOGRAM);
    }

    private int validateRetryAttempts(int retryAttempts) {
        if (retryAttempts <= 0) {
            throw new IllegalArgumentException("retryAttempts must ge greater than 0!");
        }
        return retryAttempts;
    }

    @Override
    public Connection getConnection(ConnectionRequestContext requestContext) throws SQLException {
        int remainingAttempts = this.retryAttempts;
        while (true) {
            try {
                Connection connection = this.getConnectionFactory().getConnection(requestContext);
                return connection;
            }
            catch (ConnectionAcquisitionTimeoutException e) {
                requestContext.incrementAttempts();
                LOGGER.warn("Can't acquireConnection connection, remaining retry attempts {}", (Object)(--remainingAttempts));
                if (remainingAttempts > 0) continue;
                throw e;
            }
            break;
        }
        finally {
            int attemptedRetries = requestContext.getRetryAttempts();
            if (attemptedRetries > 0) {
                this.retryAttemptsHistogram.update(attemptedRetries);
            }
        }
    }

    public String toString() {
        return "RetryConnectionAcquisitionStrategy{retryAttempts=" + this.retryAttempts + "}";
    }

    public static class Factory<T extends DataSource>
    implements ConnectionAcquisitionStrategyFactory<RetryConnectionAcquisitionStrategy, T> {
        private final int retryAttempts;

        public Factory(int retryAttempts) {
            this.retryAttempts = retryAttempts;
        }

        @Override
        public RetryConnectionAcquisitionStrategy newInstance(ConfigurationProperties<T, Metrics, PoolAdapter<T>> configurationProperties) {
            return new RetryConnectionAcquisitionStrategy(configurationProperties, this.retryAttempts);
        }
    }
}

