/*
 * Decompiled with CFR 0.152.
 */
package com.vimeo.android.deeplink;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public final class VimeoDeeplink {
    private static final int VERSION_CODE_DEBUG = 0;
    private static final int VERSION_CODE_DEEP_LINK_CATEGORY = 48;
    private static final int VERSION_CODE_DEEP_LINK_USER = 49;
    private static final int VERSION_CODE_DEEP_LINK_VIDEO = 48;
    private static final int VERSION_CODE_DEEP_LINK_CATEGORIES = 74;
    private static final int VERSION_CODE_DEEP_LINK_CHANNELS = 74;
    private static final int VERSION_CODE_DEEP_LINK_EXPLORE = 74;
    private static final int VERSION_CODE_DEEP_LINK_FEED = 74;
    private static final int VERSION_CODE_DEEP_LINK_ME = 74;
    private static final int VERSION_CODE_DEEP_LINK_NOTIFICATIONS = 1202;
    private static final int VERSION_CODE_DEEP_LINK_NOTIFICATION_SETTINGS = 1202;
    private static final int VERSION_CODE_DEEP_LINK_OFFLINE = 470;
    private static final int VERSION_CODE_DEEP_LINK_ONDEMAND = 470;
    private static final int VERSION_CODE_DEEP_LINK_PLAYLISTS = 74;
    private static final int VERSION_CODE_DEEP_LINK_PURCHASES = 470;
    private static final int VERSION_CODE_DEEP_LINK_UPLOAD = 74;
    private static final int VERSION_CODE_DEEP_LINK_URL = 234;
    private static final int VERSION_CODE_DEEP_LINK_WATCHLATER = 470;
    private static final String VIMEO_BASE_URL_HOST = "vimeo.com";
    private static final String VIMEO_BASE_URI = "vimeo://app.vimeo.com";
    private static final String VIMEO_APP_PACKAGE = "com.vimeo.android.videoapp";
    private static final String PLAY_STORE_URI = "market://details?id=com.vimeo.android.videoapp";
    private static final String PLAY_STORE_WEB_URL = "http://play.google.com/store/apps/details?id=com.vimeo.android.videoapp";
    private static final String CATEGORIES = "/categories";
    private static final String EXPLORE = "/explore";
    private static final String FEED = "/feed";
    private static final String ME = "/me";
    private static final String NOTIFICATIONS = "/notifications";
    private static final String NOTIFICATION_SETTINGS = "/settings/notifications";
    private static final String OFFLINE = "/offline";
    private static final String PLAYLISTS = "/playlists";
    private static final String PURCHASES = "/purchases";
    private static final String UPLOAD = "/upload";
    private static final String WATCH_LATER = "/watchlater";
    public static final String VIMEO_VIDEO_URI_PREFIX = "/videos/";
    public static final String VIMEO_USER_URI_PREFIX = "/users/";
    public static final String VIMEO_CATEGORY_URI_PREFIX = "/categories/";
    public static final String VIMEO_CHANNEL_URI_PREFIX = "/channels/";
    public static final String VIMEO_ONDEMAND_URI_PREFIX = "/ondemand/";

    public static boolean isVimeoAppInstalled(@NonNull Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            packageManager.getPackageInfo(VIMEO_APP_PACKAGE, 1);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static boolean viewVimeoAppInAppStore(@NonNull Context context) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)PLAY_STORE_URI));
        if (!VimeoDeeplink.startActivity(context, intent)) {
            intent = new Intent("android.intent.action.VIEW", Uri.parse((String)PLAY_STORE_WEB_URL));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return true;
    }

    public static boolean openVimeoApp(@NonNull Context context) {
        if (VimeoDeeplink.isVimeoAppInstalled(context)) {
            Intent LaunchIntent = context.getPackageManager().getLaunchIntentForPackage(VIMEO_APP_PACKAGE);
            context.startActivity(LaunchIntent);
            return true;
        }
        return false;
    }

    public static boolean canHandleVideoDeeplink(@NonNull Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 48 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showVideoWithUri(@NonNull Context context, @NonNull String videoUriPath) {
        if (videoUriPath.startsWith(VIMEO_VIDEO_URI_PREFIX) && VimeoDeeplink.canHandleVideoDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)(VIMEO_BASE_URI + videoUriPath)));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleCategoryDeeplink(@NonNull Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 48 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showCategoryWithUri(@NonNull Context context, @NonNull String categoryUriPath) {
        if (categoryUriPath.startsWith(VIMEO_CATEGORY_URI_PREFIX) && VimeoDeeplink.canHandleCategoryDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)(VIMEO_BASE_URI + categoryUriPath)));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleChannelDeeplink(@NonNull Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 74 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showChannelWithUri(@NonNull Context context, @NonNull String channelUriPath) {
        if (channelUriPath.startsWith(VIMEO_CHANNEL_URI_PREFIX) && VimeoDeeplink.canHandleChannelDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)(VIMEO_BASE_URI + channelUriPath)));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleUserDeeplink(@NonNull Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 49 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showUserWithUri(@NonNull Context context, @NonNull String userUriPath) {
        if (userUriPath.startsWith(VIMEO_USER_URI_PREFIX) && VimeoDeeplink.canHandleUserDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)(VIMEO_BASE_URI + userUriPath)));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleOnDemandDeeplink(@NonNull Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 470 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showOnDemandTitleWithUri(@NonNull Context context, @NonNull String ondemandUriPath) {
        if (ondemandUriPath.startsWith(VIMEO_ONDEMAND_URI_PREFIX) && VimeoDeeplink.canHandleOnDemandDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)(VIMEO_BASE_URI + ondemandUriPath)));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean showCategories(@NonNull Context context) {
        if (VimeoDeeplink.canHandleCategoiesDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/categories"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleCategoiesDeeplink(@NonNull Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 74 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showExplore(@NonNull Context context) {
        if (VimeoDeeplink.canHandleExploreDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/explore"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleExploreDeeplink(@NonNull Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 74 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showFeed(@NonNull Context context) {
        if (VimeoDeeplink.canHandleFeedDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/feed"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleFeedDeeplink(@NonNull Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 74 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showMyProfile(@NonNull Context context) {
        if (VimeoDeeplink.canHandleMeDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/me"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleMeDeeplink(@NonNull Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 74 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showNotifications(@NonNull Context context) {
        if (VimeoDeeplink.canHandleNotificationsDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/notifications"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleNotificationsDeeplink(@NonNull Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 1202 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showPushNotificationSettings(@NonNull Context context) {
        if (VimeoDeeplink.canHandlePushNotificationSettingsDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/settings/notifications"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandlePushNotificationSettingsDeeplink(@NonNull Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 1202 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showOffline(@NonNull Context context) {
        if (VimeoDeeplink.canHandleOfflineDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/offline"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleOfflineDeeplink(@NonNull Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 470 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showPlaylists(@NonNull Context context) {
        if (VimeoDeeplink.canHandlePlaylistDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/playlists"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandlePlaylistDeeplink(@NonNull Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 74 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showPurchases(@NonNull Context context) {
        if (VimeoDeeplink.canHandlePlaylistDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/purchases"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandlePurchaseDeeplink(@NonNull Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 470 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showUpload(@NonNull Context context) {
        if (VimeoDeeplink.canHandleUploadDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/upload"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleUploadDeeplink(@NonNull Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 74 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean showWatchLater(@NonNull Context context) {
        if (VimeoDeeplink.canHandleOfflineDeeplink(context)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"vimeo://app.vimeo.com/watchlater"));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleWatchLaterDeeplink(@NonNull Context context) {
        return VimeoDeeplink.vimeoAppVersion(context) >= 470 || VimeoDeeplink.vimeoAppVersion(context) == 0;
    }

    public static boolean openUrl(@NonNull Context context, @NonNull String url) {
        if (VimeoDeeplink.canHandleUrl(context, url)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            return VimeoDeeplink.startActivity(context, intent);
        }
        return false;
    }

    public static boolean canHandleUrl(@NonNull Context context, @NonNull String url) {
        return (VimeoDeeplink.vimeoAppVersion(context) >= 234 || VimeoDeeplink.vimeoAppVersion(context) == 0) && url.toLowerCase().contains(VIMEO_BASE_URL_HOST);
    }

    private static int vimeoAppVersion(@NonNull Context context) {
        if (VimeoDeeplink.isVimeoAppInstalled(context)) {
            PackageManager packageManager = context.getPackageManager();
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(VIMEO_APP_PACKAGE, 1);
                return packageInfo.versionCode;
            }
            catch (PackageManager.NameNotFoundException e) {
                return 0;
            }
        }
        return 0;
    }

    private static boolean startActivity(@NonNull Context context, @Nullable Intent intent) {
        if (intent != null && intent.resolveActivity(context.getPackageManager()) != null) {
            intent.addFlags(0x10008000);
            context.startActivity(intent);
            return true;
        }
        return false;
    }

    private VimeoDeeplink() {
    }
}

