/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.VidyoClient.Device;

public class Device {
    private long objPtr;
    public String id;
    public String name;
    public DeviceType type;

    public long GetObjectPtr() {
        return this.objPtr;
    }

    private native long constructCopyNative(long var1);

    private native boolean derivedEqualNative(long var1);

    private native void destructNative(long var1);

    private native String getIdNative(long var1);

    private native String getNameNative(long var1);

    private native DeviceType getTypeNative(long var1);

    public Device(long rPtr) {
        this.objPtr = this.constructCopyNative(rPtr);
    }

    protected void dispose() {
        if (this.objPtr != 0L) {
            this.destructNative(this.objPtr);
        }
        this.objPtr = 0L;
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public boolean derivedEqual() {
        return this.derivedEqualNative(this.objPtr);
    }

    public String getId() {
        return this.getIdNative(this.objPtr);
    }

    public String getName() {
        return this.getNameNative(this.objPtr);
    }

    public DeviceType getType() {
        return this.getTypeNative(this.objPtr);
    }

    public static enum DeviceType {
        VIDYO_DEVICETYPE_LocalCamera,
        VIDYO_DEVICETYPE_LocalMicrophone,
        VIDYO_DEVICETYPE_LocalMonitor,
        VIDYO_DEVICETYPE_LocalWindowShare,
        VIDYO_DEVICETYPE_LocalSpeaker,
        VIDYO_DEVICETYPE_LocalRenderer,
        VIDYO_DEVICETYPE_RemoteCamera,
        VIDYO_DEVICETYPE_RemoteMicrophone,
        VIDYO_DEVICETYPE_RemoteWindowShare,
        VIDYO_DEVICETYPE_RemoteSpeaker,
        VIDYO_DEVICETYPE_RemoteRenderer;

    }

    public static enum DeviceState {
        VIDYO_DEVICESTATE_Added,
        VIDYO_DEVICESTATE_Removed,
        VIDYO_DEVICESTATE_Started,
        VIDYO_DEVICESTATE_Stopped,
        VIDYO_DEVICESTATE_Suspended,
        VIDYO_DEVICESTATE_Unsuspended,
        VIDYO_DEVICESTATE_InUse,
        VIDYO_DEVICESTATE_Available,
        VIDYO_DEVICESTATE_Paused,
        VIDYO_DEVICESTATE_Resumed,
        VIDYO_DEVICESTATE_ControlledByRemoteEntity,
        VIDYO_DEVICESTATE_NotControlledByRemoteEntity,
        VIDYO_DEVICESTATE_Controllable,
        VIDYO_DEVICESTATE_NotControllable,
        VIDYO_DEVICESTATE_DefaultChanged,
        VIDYO_DEVICESTATE_ConfigureSuccess,
        VIDYO_DEVICESTATE_ConfigureError,
        VIDYO_DEVICESTATE_Error;

    }

    public static enum DeviceAudioSignalType {
        VIDYO_DEVICEAUDIOSIGNALTYPE_Voice,
        VIDYO_DEVICEAUDIOSIGNALTYPE_Unprocessed;

    }
}

