/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.LmiDeviceManager;

import android.annotation.TargetApi;
import android.media.Image;
import com.vidyo.LmiDeviceManager.LmiVideoCapturerCamera2;

public class LmiVideoFrame {
    private byte[] buffer;
    private Image image;
    private String format;
    private int width;
    private int height;
    private long timestamp = Long.MAX_VALUE;
    private int orientation = 0;
    private int orientationRelativeToInterface = 0;
    private boolean mirrored = false;
    private Object obj = null;

    public LmiVideoFrame(String fmt, byte[] buf, int w, int h) {
        this.format = fmt;
        this.buffer = buf;
        this.width = w;
        this.height = h;
    }

    @TargetApi(value=19)
    public LmiVideoFrame(Image i) {
        this.image = i;
        this.width = i.getWidth();
        this.height = i.getHeight();
        this.format = LmiVideoCapturerCamera2.pixelFormatToString(i.getFormat());
        this.timestamp = i.getTimestamp();
    }

    public void setOrientation(int o) {
        if (o < 0 || o >= 360) {
            throw new IllegalArgumentException("Invalid orientation " + o);
        }
        this.orientation = o;
    }

    public void setOrientationRelativeToInterface(int o) {
        if (o < 0 || o >= 360) {
            throw new IllegalArgumentException("Invalid orientation " + o + " relative to app.");
        }
        this.orientationRelativeToInterface = o;
    }

    public void setMirrored(boolean m) {
        this.mirrored = m;
    }

    public void setTimestamp(long t) {
        this.timestamp = t;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    @TargetApi(value=19)
    public Image getImage() {
        return this.image;
    }

    public String getFormat() {
        return this.format;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getOrientationRelativeToInterface() {
        return this.orientationRelativeToInterface;
    }

    public boolean getMirrored() {
        return this.mirrored;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setObject(Object o) {
        this.obj = o;
    }

    public Object getObject() {
        return this.obj;
    }
}

