/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.LmiDeviceManager;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.OrientationEventListener;
import com.vidyo.LmiDeviceManager.LmiScreenManagerCupcakeListener;
import com.vidyo.LmiDeviceManager.LmiScreenManagerJellybeanListener;
import java.nio.ByteBuffer;

public class LmiScreenManager
extends OrientationEventListener {
    private Display[] displays;
    private static String TAG = "LmiScreenManagerJava";
    private ByteBuffer pointerwrapper;
    private int deviceRotation;
    private LmiScreenManagerListener listener;

    public LmiScreenManager(Context context, ByteBuffer pointerwrapper) {
        super(context.getApplicationContext(), 3);
        this.pointerwrapper = pointerwrapper;
        this.deviceRotation = 0;
        this.listener = Build.VERSION.SDK_INT >= 17 ? LmiScreenManagerJellybeanListener.newInstance(context, pointerwrapper, this) : LmiScreenManagerCupcakeListener.newInstance(context, pointerwrapper, this);
        this.getDisplays();
        Log.d((String)TAG, (String)"LmiScreenManager construct done in java");
    }

    public void onOrientationChanged(int orientation) {
        int oldRotation = this.deviceRotation;
        this.deviceRotation = orientation > 45 && orientation <= 145 ? 90 : (orientation > 145 && orientation <= 225 ? 180 : (orientation > 225 && orientation <= 315 ? 270 : (orientation == -1 ? -1 : 0)));
        if (oldRotation != this.deviceRotation) {
            Log.d((String)TAG, (String)"LmiScreenManager new rotatation in java");
            this.getDisplays();
            this.rotationChanged(0, this.pointerwrapper);
        }
    }

    public native void rotationChanged(int var1, ByteBuffer var2);

    public native void displayAdded(int var1, ByteBuffer var2);

    public native void displayRemoved(int var1, ByteBuffer var2);

    public native void displayChanged(int var1, ByteBuffer var2);

    public boolean start() {
        boolean s = false;
        this.enable();
        s = this.listener.start();
        Log.d((String)TAG, (String)"LmiScreenManager started in java");
        return s;
    }

    public void stop() {
        this.listener.stop();
        this.disable();
        Log.d((String)TAG, (String)"LmiScreenManager stopped in java");
    }

    public void getDisplays() {
        this.displays = this.listener.getDisplays();
    }

    public int[] getDisplayIds() {
        int[] ids = new int[this.displays.length];
        for (int i = 0; i < this.displays.length; ++i) {
            ids[i] = this.displays[i].getDisplayId();
        }
        return ids;
    }

    public Display getDisplay(int displayId) {
        int numDisplays = this.displays.length;
        for (int i = 0; i < numDisplays; ++i) {
            if (this.displays[i].getDisplayId() != displayId) continue;
            return this.displays[i];
        }
        return null;
    }

    public int getWorkAreaWidth(int displayId) {
        Display d = this.getDisplay(displayId);
        if (d == null) {
            return 0;
        }
        return d.getWidth();
    }

    public int getWorkAreaHeight(int displayId) {
        Display d = this.getDisplay(displayId);
        if (d == null) {
            return 0;
        }
        return d.getHeight();
    }

    public int getRealWidth(int displayId) {
        return this.listener.getRealWidth(displayId);
    }

    public int getRealHeight(int displayId) {
        return this.listener.getRealHeight(displayId);
    }

    public int getXdpi(int displayId) {
        Display d = this.getDisplay(displayId);
        if (d == null) {
            return 0;
        }
        DisplayMetrics metrics = new DisplayMetrics();
        d.getMetrics(metrics);
        return Math.round(metrics.xdpi);
    }

    public int getYdpi(int displayId) {
        Display d = this.getDisplay(displayId);
        if (d == null) {
            return 0;
        }
        DisplayMetrics metrics = new DisplayMetrics();
        d.getMetrics(metrics);
        return Math.round(metrics.ydpi);
    }

    public boolean isDefaultDisplay(int displayId) {
        return 0 == displayId;
    }

    public String getName(int displayId) {
        return this.listener.getName(displayId);
    }

    public int getRotation(int displayId) {
        if (this.isDefaultDisplay(displayId)) {
            return this.deviceRotation;
        }
        return 0;
    }

    public static interface LmiScreenManagerListener {
        public boolean start();

        public void stop();

        public Display[] getDisplays();

        public int getRealWidth(int var1);

        public int getRealHeight(int var1);

        public String getName(int var1);
    }
}

