/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.LmiUi;

import android.app.Activity;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;

public class LmiWindow
extends TextureView
implements TextureView.SurfaceTextureListener,
View.OnLayoutChangeListener,
View.OnTouchListener,
View.OnKeyListener {
    private static String TAG = "LmiWindow";
    private long nativePtr;
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);
    private static final int LMI_TOUCHSTATE_START = 0;
    private static final int LMI_TOUCHSTATE_MOVE = 1;
    private static final int LMI_TOUCHSTATE_STOP = 2;

    public LmiWindow(Context context, long nativeP) {
        super(context);
        this.nativePtr = nativeP;
        int viewId = Build.VERSION.SDK_INT >= 17 ? LmiWindow.generateViewId() : LmiWindow.generateViewIdFallback();
        this.setId(viewId);
        this.setSurfaceTextureListener(this);
        this.addOnLayoutChangeListener(this);
        this.setOnTouchListener(this);
        this.setOnKeyListener(this);
        this.setVisibility(8);
        Log.d((String)TAG, (String)"LmiWindow constructed in Java");
    }

    private static int generateViewIdFallback() {
        int newValue;
        int result;
        do {
            if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
            newValue = 1;
        } while (!sNextGeneratedId.compareAndSet(result, newValue));
        return result;
    }

    public void stopCallbacks() {
        this.setSurfaceTextureListener(null);
        this.removeOnLayoutChangeListener(this);
        this.setOnTouchListener(null);
        this.setOnKeyListener(null);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        Log.d((String)TAG, (String)("Surface texture available: " + width + "x" + height));
        this.notifySurfaceTextureAvailable(width, height);
    }

    public native void notifySurfaceTextureAvailable(int var1, int var2);

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.notifySurfaceTextureDestroyed();
        Log.d((String)TAG, (String)"Surface texture destroyed");
        return true;
    }

    public native void notifySurfaceTextureDestroyed();

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        Log.d((String)TAG, (String)("Surface texture size changed: " + width + "x" + height));
        this.notifySurfaceTextureSizeChanged(width, height);
    }

    public native void notifySurfaceTextureSizeChanged(int var1, int var2);

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (v != this) {
            throw new IllegalArgumentException("only want to listen for my own layout changes");
        }
        int width = right - left;
        int height = bottom - top;
        Log.d((String)TAG, (String)("Layout changed: " + width + "x" + height + "@" + left + "," + top));
        this.notifyLayoutChanged(width, height, left, top);
    }

    public native void notifyLayoutChanged(int var1, int var2, int var3, int var4);

    public boolean onTouch(View v, MotionEvent event) {
        if (v != this) {
            throw new IllegalArgumentException("only want to listen for my own touch events");
        }
        int action = event.getAction();
        switch (action & 0xFF) {
            case 0: {
                this.notifyTouchEvent(event.getPointerId(0), 0, (int)event.getX(), (int)event.getY());
                return true;
            }
            case 1: {
                this.notifyTouchEvent(event.getPointerId(0), 2, (int)event.getX(), (int)event.getY());
                return true;
            }
            case 2: {
                for (int idx = 0; idx < event.getPointerCount(); ++idx) {
                    this.notifyTouchEvent(event.getPointerId(idx), 1, (int)event.getX(idx), (int)event.getY(idx));
                }
                return true;
            }
            case 5: {
                int idx = (action & 0xFF00) >> 8;
                this.notifyTouchEvent(event.getPointerId(idx), 0, (int)event.getX(idx), (int)event.getY(idx));
                return true;
            }
            case 6: {
                int idx = (action & 0xFF00) >> 8;
                this.notifyTouchEvent(event.getPointerId(idx), 2, (int)event.getX(idx), (int)event.getY(idx));
                return true;
            }
        }
        return false;
    }

    public native void notifyTouchEvent(int var1, int var2, int var3, int var4);

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        if (v != this) {
            throw new IllegalArgumentException("only want to listen for my own key events");
        }
        return false;
    }

    public static void setContentViewOnUiThread(final Activity activity, final View view, int width, int height, final int left, final int top) throws Exception {
        final ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(width, height);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                activity.setContentView(view, layoutParams);
                view.setLeft(left);
                view.setTop(top);
            }
        };
        FutureTask<Object> action = new FutureTask<Object>(task, null);
        activity.runOnUiThread(action);
        action.get();
    }

    public static void addViewOnUiThread(Activity activity, final ViewGroup viewGroup, final View view, final int width, final int height, final int left, final int top) throws Exception {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                viewGroup.addView(view, width, height);
                view.setLeft(left);
                view.setTop(top);
            }
        };
        FutureTask<Object> action = new FutureTask<Object>(task, null);
        activity.runOnUiThread(action);
        action.get();
    }

    public static void setVisibilityOnUiThread(Activity activity, final View view, final int visibility) throws Exception {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                view.setVisibility(visibility);
            }
        };
        FutureTask<Object> action = new FutureTask<Object>(task, null);
        activity.runOnUiThread(action);
        action.get();
    }

    public static void setPositionOnUiThread(Activity activity, final View view, final int width, final int height, final int left, final int top) throws Exception {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ViewGroup.LayoutParams params = view.getLayoutParams();
                params.width = width;
                params.height = height;
                view.setLayoutParams(params);
                view.setLeft(left);
                view.setTop(top);
            }
        };
        FutureTask<Object> action = new FutureTask<Object>(task, null);
        activity.runOnUiThread(action);
        action.get();
    }

    public static void removeViewOnUiThread(Activity activity, final View view) throws Exception {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ((ViewGroup)view.getParent()).removeView(view);
            }
        };
        FutureTask<Object> action = new FutureTask<Object>(task, null);
        activity.runOnUiThread(action);
        action.get();
    }
}

