/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.LmiDeviceManager;

import android.content.Context;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.media.CameraProfile;
import android.media.MediaActionSound;
import android.opengl.GLES20;
import android.opengl.GLU;
import android.opengl.GLUtils;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import com.vidyo.LmiDeviceManager.LmiVideoCapturer;
import com.vidyo.LmiDeviceManager.LmiVideoCapturerCapability;
import com.vidyo.LmiDeviceManager.LmiVideoFrame;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

class LmiVideoCapturerInternal
extends LmiVideoCapturer
implements Camera.PreviewCallback,
SurfaceTexture.OnFrameAvailableListener {
    private LmiVideoCapturerCapability[] capabilityArray = null;
    private LmiVideoCapturerCapability[] capabilityArrayCapture = null;
    private int deviceId;
    private Camera camera = null;
    private Camera.Size size;
    private PixelFormat pixelFormat;
    private int pixelFormatInt = 0;
    private String pixelFormatString;
    private String pixelFormatStringPicture;
    private Context context;
    private LmiVideoFrame lastFrame = null;
    private LmiVideoFrame lastFramePicture = null;
    private long lastTimestamp = Long.MAX_VALUE;
    private boolean stopping = false;
    private boolean hasFlashUnit = false;
    private List<String> flashModes;
    private String torchMode = "off";
    private int cameraRotation = 0;
    private boolean mirrored = false;
    private int facing = 0;
    private String name = null;
    private EGL10 egl = null;
    private EGLDisplay eglDisplay = null;
    private EGLContext eglContext = null;
    private EGLSurface eglSurface = null;
    private int textureNum = Integer.MAX_VALUE;
    private SurfaceTexture surfaceTexture = null;
    private OrientationEventListener rotationNotifier;
    private Integer mDeviceRotation = Integer.MAX_VALUE;
    private Integer mAppUiRotation = Integer.MAX_VALUE;
    private int capturePictureFlashMode = 0;
    private String capturePictureFormat = "JPEG";
    private int capturePictureQuality = 0;
    private boolean inVideo = false;
    private int widthPicture = 0;
    private int heightPicture = 0;
    private boolean pictureInProgress = false;
    private boolean pictureAvailable = false;
    private ByteArrayOutputStream outputStreamPicture = null;
    Camera.PictureCallback pictureCallback = new Camera.PictureCallback(){

        public void onPictureTaken(byte[] data, Camera camera) {
            try {
                LmiVideoCapturerInternal.this.lastFramePicture = new LmiVideoFrame(LmiVideoCapturerInternal.this.pixelFormatStringPicture, data, LmiVideoCapturerInternal.this.widthPicture, LmiVideoCapturerInternal.this.heightPicture);
                LmiVideoCapturerInternal.this.lastFramePicture.setMirrored(LmiVideoCapturerInternal.this.mirrored);
                LmiVideoCapturerInternal.this.lastFramePicture.setOrientation(LmiVideoCapturerInternal.this.getOrientation());
                LmiVideoCapturerInternal.this.lastFramePicture.setOrientationRelativeToInterface(LmiVideoCapturerInternal.this.getOrientationRelativeToInterface());
                if (LmiVideoCapturerInternal.this.surfaceTexture != null) {
                    LmiVideoCapturerInternal.this.lastFramePicture.setTimestamp(LmiVideoCapturerInternal.this.surfaceTexture.getTimestamp());
                } else {
                    LmiVideoCapturerInternal.this.lastFramePicture.setTimestamp(0L);
                }
                LmiVideoCapturerInternal.this.pictureAvailable = true;
                LmiVideoCapturerInternal.this.pictureReceived(LmiVideoCapturerInternal.this.lastFramePicture);
                LmiVideoCapturerInternal.this.lastFramePicture = null;
                LmiVideoCapturerInternal.this.captureThreadRunnable = new CaptureThreadRunnable();
                Thread captureStopThread = new Thread(LmiVideoCapturerInternal.this.captureThreadRunnable);
                LmiVideoCapturerInternal.this.captureThreadRunnable.callStop();
                captureStopThread.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private CaptureThreadRunnable captureThreadRunnable = null;
    private boolean captureThreadRunnableActive = false;
    private final int NUM_BUFFERS = 3;
    private byte[] bufferPicture = null;

    private void InitializeSurfaceTexture() {
        if (this.egl != null) {
            throw new RuntimeException("Double-initialization of camera surface texture");
        }
        this.egl = (EGL10)EGLContext.getEGL();
        this.eglDisplay = this.egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.eglDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new RuntimeException("Error: eglGetDisplay() Failed: " + GLUtils.getEGLErrorString((int)this.egl.eglGetError()));
        }
        int[] version = new int[2];
        if (!this.egl.eglInitialize(this.eglDisplay, version)) {
            throw new RuntimeException("Error: eglInitialize() Failed: " + GLUtils.getEGLErrorString((int)this.egl.eglGetError()));
        }
        EGLConfig[] eglConfigs = new EGLConfig[1];
        int[] configsCount = new int[1];
        int EGL_OPENGL_ES2_BIT = 4;
        int[] configSpec = new int[]{12352, 4, 12324, 4, 12323, 4, 12322, 4, 12344};
        if (!this.egl.eglChooseConfig(this.eglDisplay, configSpec, eglConfigs, 1, configsCount) || configsCount[0] == 0) {
            throw new RuntimeException("Error: eglChooseConfig() Failed: " + GLUtils.getEGLErrorString((int)this.egl.eglGetError()));
        }
        int EGL_CONTEXT_CLIENT_VERSION = 12440;
        int[] attribList = new int[]{12440, 2, 12344};
        this.eglContext = this.egl.eglCreateContext(this.eglDisplay, eglConfigs[0], EGL10.EGL_NO_CONTEXT, attribList);
        if (this.eglContext == EGL10.EGL_NO_CONTEXT) {
            throw new RuntimeException("Error: eglCreateContext() Failed: " + GLUtils.getEGLErrorString((int)this.egl.eglGetError()));
        }
        int[] surfaceAttrib = new int[]{12375, 1, 12374, 1, 12344};
        this.eglSurface = this.egl.eglCreatePbufferSurface(this.eglDisplay, eglConfigs[0], surfaceAttrib);
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("Error: eglCreatePbufferSurface() Failed: " + GLUtils.getEGLErrorString((int)this.egl.eglGetError()));
        }
        if (!this.egl.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext)) {
            Log.e((String)TAG, (String)("eglMakeCurrent() Failed before generating texture: " + GLUtils.getEGLErrorString((int)this.egl.eglGetError())));
            return;
        }
        int[] textures = new int[]{Integer.MAX_VALUE};
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        if (textures[0] == Integer.MAX_VALUE) {
            throw new RuntimeException("ERROR: glGenTextures() Failed: " + GLU.gluErrorString((int)GLES20.glGetError()));
        }
        GLES20.glBindTexture((int)36197, (int)textures[0]);
        this.textureNum = textures[0];
        this.surfaceTexture = new SurfaceTexture(this.textureNum);
        this.surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        if (!this.egl.eglMakeCurrent(this.eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT)) {
            throw new RuntimeException("eglMakeCurrent() Failed when unbinding display after generating texture: " + GLUtils.getEGLErrorString((int)this.egl.eglGetError()));
        }
        Log.d((String)TAG, (String)("Created SurfaceTexture " + this.surfaceTexture + " with texture " + this.textureNum + " for camera " + this.name));
    }

    private void FreeSurfaceTexture() {
        if (this.eglDisplay != null && this.eglSurface != null && this.eglContext != null && !this.egl.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext)) {
            Log.e((String)TAG, (String)("eglMakeCurrent() Failed before freeing texture: " + GLUtils.getEGLErrorString((int)this.egl.eglGetError())));
            return;
        }
        if (this.surfaceTexture != null) {
            Log.d((String)TAG, (String)("Freeing surface texture " + this.surfaceTexture + " for camera " + this.name));
            this.surfaceTexture.setOnFrameAvailableListener(null);
            this.surfaceTexture.detachFromGLContext();
            this.surfaceTexture.release();
            this.surfaceTexture = null;
        }
        if (this.textureNum != Integer.MAX_VALUE) {
            int[] textures = new int[]{this.textureNum};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            this.textureNum = Integer.MAX_VALUE;
        }
        if (this.eglSurface != null) {
            if (!this.egl.eglDestroySurface(this.eglDisplay, this.eglSurface)) {
                Log.e((String)TAG, (String)("eglDestroySurface() Failed: " + GLUtils.getEGLErrorString((int)this.egl.eglGetError())));
            }
            this.eglSurface = null;
        }
        if (this.eglContext != null) {
            if (!this.egl.eglDestroyContext(this.eglDisplay, this.eglContext)) {
                Log.e((String)TAG, (String)("eglDestroyContext() Failed: " + GLUtils.getEGLErrorString((int)this.egl.eglGetError())));
            }
            this.eglContext = null;
        }
        if (this.eglDisplay != null) {
            if (!this.egl.eglMakeCurrent(this.eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT)) {
                Log.e((String)TAG, (String)("eglMakeCurrent() Failed when unbinding display after freeing texture: " + GLUtils.getEGLErrorString((int)this.egl.eglGetError())));
                return;
            }
            if (!this.egl.eglTerminate(this.eglDisplay)) {
                Log.e((String)TAG, (String)("eglTerminate() Failed: " + GLUtils.getEGLErrorString((int)this.egl.eglGetError())));
            }
            this.eglDisplay = null;
        }
        this.egl = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int syncAppUiRotation() {
        int appUiRotation = 0;
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        Display defaultDisplay = windowManager.getDefaultDisplay();
        int displayRotation = defaultDisplay.getRotation();
        switch (displayRotation) {
            case 0: {
                appUiRotation = 0;
                break;
            }
            case 1: {
                appUiRotation = 270;
                break;
            }
            case 2: {
                appUiRotation = 180;
                break;
            }
            case 3: {
                appUiRotation = 90;
                break;
            }
            default: {
                Log.i((String)TAG, (String)String.format("UNEXPECTED enum value %d from Display.getRotation().", displayRotation));
            }
        }
        Integer n = this.mAppUiRotation;
        synchronized (n) {
            if (this.mAppUiRotation != appUiRotation) {
                Log.i((String)TAG, (String)String.format("App's UI rotation changed from %d to %d (camera \"%s\", facing %s)", this.mAppUiRotation, appUiRotation, this.name, this.facing == 0 ? "Front" : "Back"));
                this.mAppUiRotation = appUiRotation;
            }
        }
        return appUiRotation;
    }

    public LmiVideoCapturerInternal(Context context, String id, long nativePtr) {
        super(nativePtr);
        Log.i((String)TAG, (String)("constructing Camera1 capturer for camera " + id));
        this.deviceId = Integer.parseInt(id);
        this.context = context.getApplicationContext();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.deviceId, (Camera.CameraInfo)cameraInfo);
        this.facing = cameraInfo.facing == 1 ? 0 : 1;
        this.cameraRotation = cameraInfo.orientation;
        this.name = this.facing == 1 && this.deviceId == 0 ? "Back" : (this.facing == 0 && this.deviceId == 1 ? "Front" : String.format("Camera %d", this.deviceId));
        try {
            this.camera = Camera.open((int)this.deviceId);
            Camera.Parameters parameters = this.camera.getParameters();
            this.hasFlashUnit = parameters.getFlashMode() != null;
            this.flashModes = parameters.getSupportedFlashModes();
            this.camera.release();
            this.camera = null;
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("Unable to find camera, device Id: " + Integer.toString(this.deviceId)), (Throwable)ex);
            throw ex;
        }
        this.rotationNotifier = new OrientationEventListener(context){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onOrientationChanged(int orientation) {
                LmiVideoCapturerInternal.this.syncAppUiRotation();
                if (orientation == -1) {
                    return;
                }
                int roundedOrientation = (orientation + 45) / 90 * 90 % 360;
                Integer n = LmiVideoCapturerInternal.this.mDeviceRotation;
                synchronized (n) {
                    if (LmiVideoCapturerInternal.this.mDeviceRotation != roundedOrientation) {
                        Log.i((String)LmiVideoCapturer.TAG, (String)String.format("Camera \"%s\" device rotation changed, new value %d (camera rotation %d, facing %s)", LmiVideoCapturerInternal.this.name, roundedOrientation, LmiVideoCapturerInternal.this.cameraRotation, LmiVideoCapturerInternal.this.facing == 0 ? "Front" : "Back"));
                        LmiVideoCapturerInternal.this.mDeviceRotation = roundedOrientation;
                    }
                }
            }
        };
        Log.i((String)TAG, (String)"constructor exit");
    }

    @Override
    public LmiVideoCapturerCapability[] getCapabilities() {
        Log.i((String)TAG, (String)"getCapabilities()");
        if (null == this.capabilityArray) {
            this.enumerateCapabilities();
        }
        return this.capabilityArray;
    }

    @Override
    public LmiVideoCapturerCapability[] getCapabilitiesCapture() {
        Log.i((String)TAG, (String)"getCapabilitiesCapture()");
        if (null == this.capabilityArrayCapture) {
            this.enumerateCapabilitiesJPEG();
        }
        return this.capabilityArrayCapture;
    }

    private static boolean isSupported(String value, List<String> supported) {
        return supported != null && supported.indexOf(value) >= 0;
    }

    private void setAdvancedCameraParameters() {
        Log.i((String)TAG, (String)"Setting advanced camera parameters");
        Camera.Parameters mParameters = this.camera.getParameters();
        String whiteBalance = "auto";
        if (LmiVideoCapturerInternal.isSupported(whiteBalance, mParameters.getSupportedWhiteBalance())) {
            mParameters.setWhiteBalance(whiteBalance);
        } else {
            whiteBalance = mParameters.getWhiteBalance();
            if (whiteBalance == null) {
                whiteBalance = "auto";
            }
        }
        if (mParameters.isZoomSupported()) {
            mParameters.setZoom(0);
        }
        if (Build.MANUFACTURER.toLowerCase().equalsIgnoreCase("amazon") && Build.DEVICE.equalsIgnoreCase("d01e")) {
            Log.i((String)TAG, (String)"support for autofocus is off for amazon kindle HD");
        } else {
            List supportedFocus = mParameters.getSupportedFocusModes();
            if (LmiVideoCapturerInternal.isSupported("continuous-video", supportedFocus)) {
                mParameters.setFocusMode("continuous-video");
            }
        }
        if (Build.MANUFACTURER.toLowerCase().equalsIgnoreCase("samsung") && Build.DEVICE.equalsIgnoreCase("manta") && Build.MODEL.equalsIgnoreCase("Nexus 10")) {
            Log.i((String)TAG, (String)"video-stabilization-supported is off for Nexus 10");
        } else {
            String stabSupported = mParameters.get("video-stabilization-supported");
            if ("true".equals(stabSupported)) {
                mParameters.set("video-stabilization", "true");
            }
        }
        int jpegQuality = CameraProfile.getJpegEncodingQualityParameter((int)2);
        mParameters.setJpegQuality(jpegQuality);
        this.camera.setParameters(mParameters);
    }

    @Override
    public boolean startInternal(String format, int width, int height, long frameInterval, boolean startVideo, int pictureWidth, int pictureHeight, int maxNumberOfPictures) {
        this.stopping = false;
        this.pixelFormatInt = 0;
        this.inVideo = false;
        if (startVideo) {
            try {
                try {
                    this.camera = Camera.open((int)this.deviceId);
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)("Unable to find camera, device Id: " + Integer.toString(this.deviceId)), (Throwable)ex);
                    return false;
                }
                this.rotationNotifier.enable();
                if (this.capabilityArray == null) {
                    Log.e((String)TAG, (String)"capabilityArray is null");
                    this.enumerateCapabilitiesForCamera(this.camera);
                    if (this.capabilityArray == null) {
                        Log.e((String)TAG, (String)"Unable to enumerate capabilities for camera");
                        return false;
                    }
                }
                boolean found = false;
                int frameRate = -1;
                int rangeMinFrameRate = -1;
                for (int i = 0; i < this.capabilityArray.length && !found; ++i) {
                    if (this.capabilityArray[i].getWidth() != width || this.capabilityArray[i].getHeight() != height) continue;
                    long maxFrameInterval = this.capabilityArray[i].getMaxFrameInterval();
                    long minFrameInterval = this.capabilityArray[i].getMinFrameInterval();
                    Log.d((String)TAG, (String)String.format("Camera %s capability %d has width %d, height %d, maxFrameInterval %d, minFrameInterval %d, format %s.  Matching against interval %d, format %s", this.name, i, this.capabilityArray[i].getWidth(), this.capabilityArray[i].getHeight(), maxFrameInterval, minFrameInterval, this.capabilityArray[i].getFormat(), frameInterval, format));
                    if (frameInterval < minFrameInterval || frameInterval > maxFrameInterval) continue;
                    Log.d((String)TAG, (String)String.format("Camera %s capability %d: frame rate matches", this.name, i));
                    if (!this.capabilityArray[i].getFormat().equals(format)) continue;
                    int minFrameRate = this.capabilityArray[i].getMinFrameRate();
                    int maxFrameRate = this.capabilityArray[i].getMaxFrameRate();
                    if (frameInterval == minFrameInterval) {
                        frameRate = maxFrameRate;
                    } else if (frameInterval == maxFrameInterval) {
                        frameRate = minFrameRate;
                    } else {
                        frameRate = (int)(TimeUnit.SECONDS.toNanos(1000L) / frameInterval);
                        if (frameRate < minFrameRate) {
                            frameRate = minFrameRate;
                        } else if (frameRate > maxFrameRate) {
                            frameRate = maxFrameRate;
                        }
                    }
                    found = true;
                    rangeMinFrameRate = minFrameRate;
                }
                if (!found) {
                    Log.d((String)TAG, (String)String.format("Camera %s: No matching capabilities found", this.name));
                    this.camera.release();
                    this.camera = null;
                    this.rotationNotifier.disable();
                    return false;
                }
                Log.d((String)TAG, (String)String.format("Starting camera %s (%d): %dx%d@%d..%d/'%s'", this.name, this.deviceId, width, height, rangeMinFrameRate, frameRate, format));
                Camera.Parameters parameters = this.camera.getParameters();
                parameters.setPreviewSize(width, height);
                parameters.setPreviewFpsRange(rangeMinFrameRate, frameRate);
                parameters.setPreviewFormat(this.pixelFormatFromString(format));
                try {
                    this.camera.setParameters(parameters);
                }
                catch (RuntimeException rtex) {
                    Log.e((String)TAG, (String)String.format("Camera %s (%d): 'setParameters()' failed, Suspect 'setPreviewFpsRange(%d,%d)', Trying another range.", this.name, this.deviceId, rangeMinFrameRate, frameRate), (Throwable)rtex);
                    int bestFpsRangeMin = -1;
                    int bestFpsRangeMax = -1;
                    int bestFpsRangeSpan = Integer.MAX_VALUE;
                    parameters = this.camera.getParameters();
                    List supportedPreviewFpsList = parameters.getSupportedPreviewFpsRange();
                    for (int[] sfps : supportedPreviewFpsList) {
                        int fpsSpan;
                        int fpsMin = sfps[0];
                        int fpsMax = sfps[1];
                        if (fpsMin <= 0 || fpsMax <= 0) continue;
                        long frameIntervalMax = TimeUnit.SECONDS.toNanos(1000L) / (long)fpsMin;
                        long frameIntervalMin = TimeUnit.SECONDS.toNanos(1000L) / (long)fpsMax;
                        if (frameIntervalMax < frameInterval || frameInterval < frameIntervalMin || (fpsSpan = fpsMax - fpsMin) >= bestFpsRangeSpan) continue;
                        bestFpsRangeSpan = fpsSpan;
                        bestFpsRangeMin = fpsMin;
                        bestFpsRangeMax = fpsMax;
                    }
                    if (bestFpsRangeMin <= 0 || bestFpsRangeMax <= 0) {
                        bestFpsRangeMin = bestFpsRangeMax = frameRate;
                    }
                    Log.d((String)TAG, (String)String.format("Starting camera %s (%d) again: %dx%d@%d..%d/'%s'", this.name, this.deviceId, width, height, bestFpsRangeMin, bestFpsRangeMax, format));
                    parameters.setPreviewFpsRange(bestFpsRangeMin, bestFpsRangeMax);
                    parameters.setPreviewSize(width, height);
                    parameters.setPreviewFormat(this.pixelFormatFromString(format));
                    this.camera.setParameters(parameters);
                }
                parameters = this.camera.getParameters();
                this.size = parameters.getPreviewSize();
                this.pixelFormatInt = parameters.getPreviewFormat();
                this.pixelFormat = new PixelFormat();
                PixelFormat.getPixelFormatInfo((int)this.pixelFormatInt, (PixelFormat)this.pixelFormat);
                this.pixelFormatString = this.pixelFormatToString(this.pixelFormatInt);
                this.setAdvancedCameraParameters();
                parameters = this.camera.getParameters();
                if (this.capturePictureQuality == 0) {
                    this.capturePictureQuality = parameters.getJpegQuality();
                }
                this.initializeBuffers();
                this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
                this.InitializeSurfaceTexture();
                this.camera.setPreviewTexture(this.surfaceTexture);
                this.camera.startPreview();
                this.inVideo = true;
                Log.i((String)TAG, (String)String.format("Camera %s Started", this.name));
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)String.format("Unable to start camera %s", this.name), (Throwable)ex);
                this.inVideo = false;
                this.FreeSurfaceTexture();
                if (this.camera != null) {
                    try {
                        this.camera.setPreviewTexture(null);
                    }
                    catch (Exception ex2) {
                        Log.e((String)TAG, (String)String.format("Unable to clear surface texture for camera %s", this.name), (Throwable)ex2);
                    }
                    this.camera.release();
                }
                this.camera = null;
                this.rotationNotifier.disable();
                return false;
            }
        }
        try {
            try {
                this.camera = Camera.open((int)this.deviceId);
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)("Unable to find camera, device Id: " + Integer.toString(this.deviceId)), (Throwable)ex);
                return false;
            }
            Log.d((String)TAG, (String)String.format("Starting camera %s (%d): %dx%d/'%s'", this.name, this.deviceId, pictureWidth, pictureHeight, format));
            this.rotationNotifier.enable();
            this.setAdvancedCameraParameters();
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setPictureSize(pictureWidth, pictureHeight);
            parameters.setFlashMode("off");
            parameters.setPictureFormat(this.pixelFormatFromString(this.capturePictureFormat));
            if (this.capturePictureQuality == 0) {
                this.capturePictureQuality = parameters.getJpegQuality();
            }
            this.camera.setParameters(parameters);
            parameters = this.camera.getParameters();
            this.size = parameters.getPictureSize();
            this.pixelFormatInt = parameters.getPictureFormat();
            this.pixelFormatStringPicture = this.pixelFormatToString(this.pixelFormatInt);
            this.widthPicture = this.size.width;
            this.heightPicture = this.size.height;
            Log.d((String)TAG, (String)String.format("Picture format:%s width:%d height:%d", this.pixelFormatStringPicture, this.size.width, this.size.height));
            this.surfaceTexture = new SurfaceTexture(1);
            try {
                this.camera.setPreviewTexture(this.surfaceTexture);
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)String.format("Unable to start camera %s", this.name), (Throwable)ex);
            }
            this.camera.startPreview();
            Log.i((String)TAG, (String)String.format("Camera %s Started", this.name));
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)String.format("Unable to start camera %s", this.name), (Throwable)ex);
            this.FreeSurfaceTexture();
            if (this.camera != null) {
                try {
                    this.camera.setPreviewTexture(null);
                }
                catch (Exception ex2) {
                    Log.e((String)TAG, (String)String.format("Unable to clear surface texture for camera %s", this.name), (Throwable)ex2);
                }
                this.camera.release();
            }
            this.camera = null;
            this.rotationNotifier.disable();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyCamera() {
        Log.i((String)TAG, (String)"destroyCamera");
        LmiVideoCapturerInternal lmiVideoCapturerInternal = this;
        synchronized (lmiVideoCapturerInternal) {
            if (this.camera != null) {
                this.camera.stopPreview();
                try {
                    this.camera.setPreviewTexture(null);
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)String.format("Unable to clear surface texture for camera %s", this.name), (Throwable)ex);
                }
                this.camera.setPreviewCallbackWithBuffer(null);
                this.camera.release();
                this.camera = null;
                Log.i((String)TAG, (String)("camera " + this.name + " destroyed"));
            }
            this.FreeSurfaceTexture();
            this.rotationNotifier.disable();
        }
    }

    @Override
    public void stopInternal(boolean stopPictureAndVideo) {
        Log.i((String)TAG, (String)"stop");
        this.inVideo = false;
        this.stopping = true;
        if (this.camera != null) {
            this.destroyCamera();
            Log.i((String)TAG, (String)("stop: Camera " + this.name + " stopped"));
        }
        this.rotationNotifier.disable();
    }

    @Override
    public boolean hasTorchInternal() {
        return this.hasFlashUnit;
    }

    @Override
    public boolean isTorchModeSupportedInternal(int mode) {
        boolean r = false;
        if (this.flashModes != null) {
            if (mode == 0) {
                r = this.flashModes.contains("off");
            } else if (mode == 1) {
                r = this.flashModes.contains("torch");
            }
        }
        return r;
    }

    @Override
    public int getTorchModeInternal() {
        int r;
        if (this.torchMode == "off") {
            r = 0;
        } else if (this.torchMode == "torch") {
            r = 1;
        } else {
            throw new RuntimeException("Unknown or unsupported torch mode");
        }
        return r;
    }

    @Override
    public void setTorchModeInternal(int mode) {
        if (mode == 0 || mode == 1) {
            if (this.camera != null) {
                Camera.Parameters parameters = this.camera.getParameters();
                if (mode == 0) {
                    parameters.setFlashMode("off");
                } else if (mode == 1) {
                    parameters.setFlashMode("torch");
                }
                this.camera.setParameters(parameters);
            }
            if (mode == 0) {
                this.torchMode = "off";
            } else if (mode == 1) {
                this.torchMode = "torch";
            }
        } else {
            throw new RuntimeException("Unknown or unsupported torch mode");
        }
    }

    @Override
    public boolean CapturePicture(int picQuality, int picFlashMode) {
        if (this.pictureInProgress) {
            Log.e((String)TAG, (String)"unable to take another picture");
            return false;
        }
        if (!this.inVideo) {
            Camera.Parameters parameters = this.camera.getParameters();
            if (picFlashMode == 1) {
                parameters.setFlashMode("on");
            } else if (picFlashMode == 2) {
                parameters.setFlashMode("auto");
            } else {
                parameters.setFlashMode("off");
            }
            parameters.setPictureFormat(this.pixelFormatFromString(this.capturePictureFormat));
            if (picQuality > 0 && picQuality <= 100) {
                this.capturePictureQuality = picQuality;
                parameters.setJpegQuality(picQuality);
            } else if (this.capturePictureQuality > 0) {
                parameters.setJpegQuality(this.capturePictureQuality);
            }
            this.camera.setParameters(parameters);
            MediaActionSound mediaActionSound = new MediaActionSound();
            mediaActionSound.play(0);
            this.camera.takePicture(null, null, null, this.pictureCallback);
        } else {
            MediaActionSound mediaActionSound = new MediaActionSound();
            mediaActionSound.play(0);
        }
        this.pictureInProgress = true;
        this.pictureAvailable = false;
        return true;
    }

    private int pixelFormatFromString(String format) {
        int pixelFormatInt = 0;
        if (format.equals("JPEG")) {
            pixelFormatInt = 256;
        } else if (format.equals("NV16")) {
            pixelFormatInt = 16;
        } else if (format.equals("NV21")) {
            pixelFormatInt = 17;
        } else if (format.equals("YUY2")) {
            pixelFormatInt = 20;
        } else if (format.equals("YV12")) {
            pixelFormatInt = 842094169;
        }
        return pixelFormatInt;
    }

    private String pixelFormatToString(int formatInt) {
        String format = "";
        switch (formatInt) {
            case 256: {
                format = "JPEG";
                break;
            }
            case 16: {
                format = "NV16";
                break;
            }
            case 17: {
                format = "NV21";
                break;
            }
            case 20: {
                format = "NV21";
                break;
            }
            case 842094169: {
                format = "NV21";
                break;
            }
            default: {
                format = "Unknown format " + Integer.toString(formatInt);
            }
        }
        return format;
    }

    private void enumerateCapabilitiesForCamera(Camera camera) {
        try {
            Object sfps22;
            Camera.Parameters parameters = camera.getParameters();
            List sizeList = parameters.getSupportedPreviewSizes();
            List supportedPreviewFps = parameters.getSupportedPreviewFpsRange();
            List formatList = parameters.getSupportedPreviewFormats();
            ArrayList<Object> supportedPreviewMaxFps = new ArrayList<Object>();
            for (Object sfps22 : supportedPreviewFps) {
                boolean alreadyAdded = false;
                for (int[] nArray : supportedPreviewMaxFps) {
                    if (nArray[1] != sfps22[1]) continue;
                    alreadyAdded = true;
                    if (nArray[0] >= sfps22[0]) break;
                    nArray[0] = (int)sfps22[0];
                    break;
                }
                if (alreadyAdded) continue;
                supportedPreviewMaxFps.add(sfps22);
            }
            if (formatList == null || sizeList == null || supportedPreviewFps == null) {
                Log.e((String)TAG, (String)"Failed to get capabilities list");
            }
            int numCapabilities = 0;
            sfps22 = sizeList.iterator();
            while (sfps22.hasNext()) {
                Camera.Size previewSize = (Camera.Size)sfps22.next();
                for (int[] nArray : supportedPreviewMaxFps) {
                    int n = nArray[0];
                    int maxFps = nArray[1];
                    for (Integer previewFormat : formatList) {
                        if (maxFps == 0) continue;
                        Log.d((String)TAG, (String)("Found Configuration format for device " + Integer.toString(this.deviceId) + " (" + this.name + "): " + this.pixelFormatToString(previewFormat) + " size: " + Integer.toString(previewSize.width) + "x" + Integer.toString(previewSize.height) + " min-sample-rate: " + Integer.toString(n) + " max-sampling-rate: " + Integer.toString(maxFps)));
                        ++numCapabilities;
                    }
                }
            }
            Log.i((String)TAG, (String)("Allocating new capabilities array, numCapabilities=" + Integer.toString(numCapabilities)));
            this.capabilityArray = new LmiVideoCapturerCapability[numCapabilities];
            int i = 0;
            for (Camera.Size previewSize : sizeList) {
                for (int[] nArray : supportedPreviewMaxFps) {
                    int minFps = nArray[0];
                    int maxFps = nArray[1];
                    if (maxFps == 0) continue;
                    for (Integer previewFormat : formatList) {
                        String format = this.pixelFormatToString(previewFormat);
                        this.capabilityArray[i] = new LmiVideoCapturerCapability(previewSize.width, previewSize.height, minFps, maxFps, format);
                        ++i;
                    }
                }
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Exception enumerating capabilties", (Throwable)ex);
            return;
        }
    }

    private void enumerateCapabilitiesForCameraJPEG(Camera camera) {
        try {
            Camera.Parameters parameters = camera.getParameters();
            List sizeList = parameters.getSupportedPictureSizes();
            List formatList = parameters.getSupportedPictureFormats();
            if (formatList == null || sizeList == null) {
                Log.e((String)TAG, (String)"Failed to get capabilities list");
            }
            int numCapabilities = 0;
            for (Camera.Size previewSize : sizeList) {
                for (Integer previewFormat : formatList) {
                    Log.d((String)TAG, (String)("Found Configuration format for device " + Integer.toString(this.deviceId) + " (" + this.name + "): " + this.pixelFormatToString(previewFormat) + " size: " + Integer.toString(previewSize.width) + "x" + Integer.toString(previewSize.height)));
                    ++numCapabilities;
                }
            }
            Log.i((String)TAG, (String)("Allocating new capabilities array, numCapabilities=" + Integer.toString(numCapabilities)));
            this.capabilityArrayCapture = new LmiVideoCapturerCapability[numCapabilities];
            int i = 0;
            for (Camera.Size previewSize : sizeList) {
                for (Integer previewFormat : formatList) {
                    String format = this.pixelFormatToString(previewFormat);
                    this.capabilityArrayCapture[i] = new LmiVideoCapturerCapability(previewSize.width, previewSize.height, 0, 0, format);
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Exception enumerating capabilties", (Throwable)ex);
            return;
        }
    }

    private void enumerateCapabilities() {
        Camera camera = null;
        Log.i((String)TAG, (String)("Enumerating camera capabilities for device " + Integer.toString(this.deviceId)));
        try {
            try {
                camera = Camera.open((int)this.deviceId);
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)("Unable to find camera, device Id: " + Integer.toString(this.deviceId)), (Throwable)ex);
                return;
            }
            this.enumerateCapabilitiesForCamera(camera);
            camera.release();
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Exception enumerating capabilties", (Throwable)ex);
            if (camera != null) {
                camera.release();
            }
            return;
        }
    }

    private void enumerateCapabilitiesJPEG() {
        Camera camera = null;
        Log.i((String)TAG, (String)("Enumerating camera photo capabilities for device " + Integer.toString(this.deviceId)));
        try {
            try {
                camera = Camera.open((int)this.deviceId);
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)("Unable to find camera, device Id: " + Integer.toString(this.deviceId)), (Throwable)ex);
                return;
            }
            this.enumerateCapabilitiesForCameraJPEG(camera);
            camera.release();
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Exception enumerating capabilties", (Throwable)ex);
            if (camera != null) {
                camera.release();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDeviceRotation() {
        Integer n = this.mDeviceRotation;
        synchronized (n) {
            if (this.mDeviceRotation == Integer.MAX_VALUE) {
                return 0;
            }
            return this.mDeviceRotation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAppUiRotation() {
        Integer n = this.mAppUiRotation;
        synchronized (n) {
            if (this.mAppUiRotation == Integer.MAX_VALUE) {
                return 0;
            }
            return this.mAppUiRotation;
        }
    }

    @Override
    public int getOrientation() {
        int deviceRotation = this.getDeviceRotation();
        if (this.facing == 0) {
            return (deviceRotation - this.cameraRotation + 360) % 360;
        }
        return (720 - this.cameraRotation - deviceRotation) % 360;
    }

    public int getOrientationRelativeToInterface() {
        int appUiRotation = this.getAppUiRotation();
        if (this.facing == 0) {
            return (720 - this.cameraRotation + appUiRotation) % 360;
        }
        return (720 - this.cameraRotation - appUiRotation) % 360;
    }

    @Override
    public boolean getMirrored() {
        return this.mirrored;
    }

    @Override
    public int getFacing() {
        return this.facing;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void initializeBuffers() {
        try {
            int bufSize = this.size.width * this.size.height * this.pixelFormat.bitsPerPixel / 8;
            Log.d((String)TAG, (String)("Using " + Integer.toString(3) + " callback buffers"));
            for (int i = 0; i < 3; ++i) {
                byte[] buffer = new byte[bufSize];
                this.camera.addCallbackBuffer(buffer);
            }
            this.bufferPicture = new byte[bufSize];
            this.outputStreamPicture = new ByteArrayOutputStream();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Adding callback buffers failed: " + e.toString()));
        }
    }

    public void onFrameAvailable(SurfaceTexture t) {
        if (this.stopping) {
            Log.d((String)TAG, (String)("onFrameAvailable called after stop for camera " + this.name + "; skipping."));
            return;
        }
        if (!this.egl.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext)) {
            Log.e((String)TAG, (String)("eglMakeCurrent() Failed before frame available: " + GLUtils.getEGLErrorString((int)this.egl.eglGetError())));
            return;
        }
        this.surfaceTexture.updateTexImage();
        if (this.lastTimestamp != Long.MAX_VALUE) {
            Log.w((String)TAG, (String)"onFrameAvailable called more than once without an intervening onPreviewFrame");
        }
        this.lastTimestamp = this.surfaceTexture.getTimestamp();
        if (this.pictureInProgress && !this.pictureAvailable && this.lastFramePicture != null) {
            this.pictureAvailable = true;
            this.lastFramePicture.setTimestamp(this.lastTimestamp);
            this.pictureReceived(this.lastFramePicture);
            this.lastFramePicture = null;
            this.captureThreadRunnable = new CaptureThreadRunnable();
            Thread captureStopThread = new Thread(this.captureThreadRunnable);
            this.captureThreadRunnable.callStop();
            captureStopThread.start();
        }
        if (this.lastFrame != null) {
            this.lastFrame.setTimestamp(this.lastTimestamp);
            this.frameReceived(this.lastFrame);
            this.lastFrame = null;
            this.lastTimestamp = Long.MAX_VALUE;
        }
        if (!this.egl.eglMakeCurrent(this.eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT)) {
            Log.e((String)TAG, (String)("eglMakeCurrent() Failed when unbinding display after frame available: " + GLUtils.getEGLErrorString((int)this.egl.eglGetError())));
        }
    }

    public void onPreviewFrame(byte[] buffer, Camera camera) {
        if (this.stopping) {
            Log.d((String)TAG, (String)("onPreviewFrame called after stop for camera " + this.name + "; skipping."));
            return;
        }
        if (buffer == null) {
            return;
        }
        if (this.lastFrame != null) {
            Log.w((String)TAG, (String)"onPreviewFrame called more than once without an intervening onFrameAvailable");
        }
        this.lastFrame = new LmiVideoFrame(this.pixelFormatString, buffer, this.size.width, this.size.height);
        this.lastFrame.setMirrored(this.mirrored);
        this.lastFrame.setOrientation(this.getOrientation());
        this.lastFrame.setOrientationRelativeToInterface(this.getOrientationRelativeToInterface());
        if (this.lastTimestamp != Long.MAX_VALUE) {
            this.lastFrame.setTimestamp(this.lastTimestamp);
            if (this.pictureInProgress && !this.pictureAvailable) {
                Object yuvImage = null;
                if (yuvImage == null) {
                    this.lastFramePicture = new LmiVideoFrame(this.pixelFormatString, buffer, this.size.width, this.size.height);
                } else {
                    Rect area = new Rect(0, 0, this.size.width, this.size.height);
                    boolean outputState = false;
                    outputState = this.capturePictureQuality > 0 ? yuvImage.compressToJpeg(area, this.capturePictureQuality, (OutputStream)this.outputStreamPicture) : yuvImage.compressToJpeg(area, 95, (OutputStream)this.outputStreamPicture);
                    if (!outputState) {
                        this.lastFramePicture = new LmiVideoFrame(this.pixelFormatString, buffer, this.size.width, this.size.height);
                    } else {
                        this.bufferPicture = this.outputStreamPicture.toByteArray();
                        this.lastFramePicture = new LmiVideoFrame(this.capturePictureFormat, this.bufferPicture, this.size.width, this.size.height);
                    }
                }
                this.lastFramePicture.setMirrored(this.mirrored);
                this.lastFramePicture.setOrientation(this.getOrientation());
                this.lastFramePicture.setOrientationRelativeToInterface(this.getOrientationRelativeToInterface());
                this.lastFramePicture.setTimestamp(this.lastTimestamp);
                this.pictureAvailable = true;
                this.pictureReceived(this.lastFramePicture);
                this.lastFramePicture = null;
                this.captureThreadRunnable = new CaptureThreadRunnable();
                Thread captureStopThread = new Thread(this.captureThreadRunnable);
                this.captureThreadRunnable.callStop();
                captureStopThread.start();
            }
            this.frameReceived(this.lastFrame);
            this.lastFrame = null;
            this.lastTimestamp = Long.MAX_VALUE;
        }
    }

    @Override
    public void releaseFrame(LmiVideoFrame frame) {
        if (this.lastFramePicture != frame) {
            this.camera.addCallbackBuffer(frame.getBuffer());
        } else if (this.inVideo) {
            this.pictureInProgress = false;
        }
    }

    private class CaptureThreadRunnable
    implements Runnable {
        boolean doneWaiting = false;
        boolean callStartPreviewFlag = false;

        CaptureThreadRunnable() {
            LmiVideoCapturerInternal.this.captureThreadRunnableActive = true;
        }

        public void callStop() {
            this.doneWaiting = true;
        }

        public void callStartPreview() {
            this.callStartPreviewFlag = true;
            this.doneWaiting = true;
        }

        @Override
        public void run() {
            while (!this.doneWaiting) {
                SystemClock.sleep((long)10L);
                if (LmiVideoCapturerInternal.this.captureThreadRunnableActive) continue;
                this.doneWaiting = true;
                return;
            }
            if (this.callStartPreviewFlag) {
                LmiVideoCapturerInternal.this.camera.startPreview();
                this.doneWaiting = true;
            } else {
                LmiVideoCapturerInternal.this.pictureReceivedStop();
                this.doneWaiting = true;
                LmiVideoCapturerInternal.this.captureThreadRunnableActive = false;
                LmiVideoCapturerInternal.this.pictureInProgress = false;
            }
        }
    }
}

