/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.VidyoClient.Device;

import com.vidyo.VidyoClient.Device.LocalRenderer;
import com.vidyo.VidyoClient.Device.RemoteRenderer;
import com.vidyo.VidyoClient.Device.VideoFrame;
import com.vidyo.VidyoClient.Endpoint.MediaFormat;
import com.vidyo.VidyoClient.Stats.LocalVideoSourceStats;

public class VirtualWindowShare {
    private long objPtr;
    public String applicationName = new String();
    public String id = new String();
    public String name = new String();
    private IConstruct Construct;

    public long GetObjectPtr() {
        return this.objPtr;
    }

    private native long addToLocalRendererNative(long var1, LocalRenderer var3);

    private native boolean addToRemoteRendererNative(long var1, RemoteRenderer var3);

    private native void clearConstraintsNative(long var1);

    private native long constructNative(String var1, String var2, String var3);

    private native long constructCopyNative(long var1);

    private native void destructNative(long var1);

    private native String getApplicationNameNative(long var1);

    private native String getIdNative(long var1);

    private native String getNameNative(long var1);

    private native String getPreviewLabelNative(long var1);

    private native boolean getStatsNative(long var1, LocalVideoSourceStats var3);

    private native void onFrameNative(long var1, VideoFrame var3, MediaFormat var4);

    private native boolean removeFromLocalRendererNative(long var1, LocalRenderer var3);

    private native boolean removeFromRemoteRendererNative(long var1, RemoteRenderer var3);

    private native boolean setBoundsConstraintsNative(long var1, long var3, long var5, int var7, int var8, int var9, int var10);

    private native boolean setDiscreteConstraintsNative(long var1, long var3, long var5, int var7, int var8, float var9);

    private native boolean setFrameIntervalNative(long var1, long var3);

    private native boolean setLowLatencyProfileNative(long var1, boolean var3);

    private native boolean setPositionInLocalRendererNative(long var1, LocalRenderer var3, int var4, int var5, int var6, int var7, long var8);

    private native boolean setPreviewLabelNative(long var1, String var3);

    private native boolean setScaleFactorNative(long var1, float var3);

    public VirtualWindowShare(String id, String windowName, String applicationName, IConstruct Construct) {
        this.Construct = Construct;
        this.objPtr = this.constructNative(id, windowName, applicationName);
    }

    public VirtualWindowShare(long rPtr) {
        this.objPtr = this.constructCopyNative(rPtr);
    }

    protected void dispose() {
        if (this.objPtr != 0L) {
            this.destructNative(this.objPtr);
        }
        this.objPtr = 0L;
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public void reconfigureCallback(long frameInterval, MediaFormat mediaFormat, long userData) {
        if (this.Construct != null) {
            this.Construct.reconfigureCallback(frameInterval, mediaFormat, userData);
        }
    }

    public void startCallback(long frameInterval, MediaFormat mediaFormat, long userData) {
        if (this.Construct != null) {
            this.Construct.startCallback(frameInterval, mediaFormat, userData);
        }
    }

    public void stopCallback(long userData) {
        if (this.Construct != null) {
            this.Construct.stopCallback(userData);
        }
    }

    public long addToLocalRenderer(LocalRenderer renderer) {
        return this.addToLocalRendererNative(this.objPtr, renderer);
    }

    public boolean addToRemoteRenderer(RemoteRenderer remoteRenderer) {
        return this.addToRemoteRendererNative(this.objPtr, remoteRenderer);
    }

    public void clearConstraints() {
        this.clearConstraintsNative(this.objPtr);
    }

    public String getApplicationName() {
        return this.getApplicationNameNative(this.objPtr);
    }

    public String getId() {
        return this.getIdNative(this.objPtr);
    }

    public String getName() {
        return this.getNameNative(this.objPtr);
    }

    public String getPreviewLabel() {
        return this.getPreviewLabelNative(this.objPtr);
    }

    public boolean getStats(LocalVideoSourceStats stats) {
        return this.getStatsNative(this.objPtr, stats);
    }

    public void onFrame(VideoFrame videoFrame, MediaFormat mediaFormat) {
        this.onFrameNative(this.objPtr, videoFrame, mediaFormat);
    }

    public boolean removeFromLocalRenderer(LocalRenderer renderer) {
        return this.removeFromLocalRendererNative(this.objPtr, renderer);
    }

    public boolean removeFromRemoteRenderer(RemoteRenderer remoteRenderer) {
        return this.removeFromRemoteRendererNative(this.objPtr, remoteRenderer);
    }

    public boolean setBoundsConstraints(long maxFrameInterval, long minFrameInterval, int maxWidth, int minWidth, int maxHeight, int minHeight) {
        return this.setBoundsConstraintsNative(this.objPtr, maxFrameInterval, minFrameInterval, maxWidth, minWidth, maxHeight, minHeight);
    }

    public boolean setDiscreteConstraints(long maxFrameInterval, long minFrameInterval, int width, int height, float scaleFactor) {
        return this.setDiscreteConstraintsNative(this.objPtr, maxFrameInterval, minFrameInterval, width, height, scaleFactor);
    }

    public boolean setFrameInterval(long frameInterval) {
        return this.setFrameIntervalNative(this.objPtr, frameInterval);
    }

    public boolean setLowLatencyProfile(boolean profile) {
        return this.setLowLatencyProfileNative(this.objPtr, profile);
    }

    public boolean setPositionInLocalRenderer(LocalRenderer localRenderer, int x, int y, int width, int height, long frameInterval) {
        return this.setPositionInLocalRendererNative(this.objPtr, localRenderer, x, y, width, height, frameInterval);
    }

    public boolean setPreviewLabel(String previewLabel) {
        return this.setPreviewLabelNative(this.objPtr, previewLabel);
    }

    public boolean setScaleFactor(float scaleFactor) {
        return this.setScaleFactorNative(this.objPtr, scaleFactor);
    }

    public static interface IConstruct {
        public void startCallback(long var1, MediaFormat var3, long var4);

        public void reconfigureCallback(long var1, MediaFormat var3, long var4);

        public void stopCallback(long var1);
    }

    public static enum VirtualWindowShareState {
        VIDYO_VIRTUALWINDOWSHARESTATE_Ok,
        VIDYO_VIRTUALWINDOWSHARESTATE_NotVisible,
        VIDYO_VIRTUALWINDOWSHARESTATE_Minimized,
        VIDYO_VIRTUALWINDOWSHARESTATE_Closed,
        VIDYO_VIRTUALWINDOWSHARESTATE_MiscError;

    }
}

