/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.LmiDeviceManager;

import android.content.Context;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import com.vidyo.LmiDeviceManager.LmiVideoCapturerManagerCamera2;

public class LmiVideoCapturerManager {
    static final String TAG = "LmiVideoCapturerManager";
    String[] devicesArray = new String[0];
    long nativePtr;

    static boolean useCamera2() {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        String cameraApi = System.getenv("VIDYO_CAMERA_API");
        if (cameraApi == null) {
            cameraApi = System.getProperty("com.vidyo.cameraApi", "Camera2");
        }
        if (cameraApi != null) {
            return !cameraApi.equalsIgnoreCase("Camera1");
        }
        return true;
    }

    public static LmiVideoCapturerManager GetCapturerManager(Context context, long nativeP) {
        LmiVideoCapturerManager ret;
        if (LmiVideoCapturerManager.useCamera2()) {
            ret = new LmiVideoCapturerManagerCamera2(context, nativeP);
        } else {
            Log.i((String)TAG, (String)"constructing Camera1 capturer manager");
            ret = new LmiVideoCapturerManager(nativeP);
        }
        try {
            ((LmiVideoCapturerManager)ret).enumerateDevices();
            return ret;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Could not create capturer manager", (Throwable)e);
            return null;
        }
    }

    LmiVideoCapturerManager(long nativeP) {
        this.nativePtr = nativeP;
    }

    public String[] getDevices() {
        return this.devicesArray;
    }

    void enumerateDevices() throws Exception {
        int numCameras = Camera.getNumberOfCameras();
        this.devicesArray = new String[numCameras];
        for (int i = 0; i < numCameras; ++i) {
            this.devicesArray[i] = Integer.toString(i);
        }
    }

    public boolean startDeviceDetector() {
        try {
            this.enumerateDevices();
            return true;
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Failed to enumerate cameras", (Throwable)ex);
            return false;
        }
    }

    public boolean stopDeviceDetector() {
        return true;
    }

    void processDeviceChange() {
        if (this.nativePtr != 0L) {
            this.nativeProcessDeviceChange(this.nativePtr);
        }
    }

    private native void nativeProcessDeviceChange(long var1);

    void processAvailable(String cameraId, boolean available) {
        if (this.nativePtr != 0L) {
            this.nativeProcessAvailable(this.nativePtr, cameraId, available);
        }
    }

    private native void nativeProcessAvailable(long var1, String var3, boolean var4);
}

