/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.VidyoClient.Device;

import com.vidyo.VidyoClient.Device.LocalRenderer;
import com.vidyo.VidyoClient.Device.RemoteRenderer;
import com.vidyo.VidyoClient.Device.VideoFrame;
import com.vidyo.VidyoClient.Endpoint.Endpoint;
import com.vidyo.VidyoClient.Endpoint.MediaFormat;

public class VirtualVideoSource {
    private long objPtr;
    public String id;
    public String name;
    public VirtualVideoSourceType type;
    private IRegisterEventListener RegisterEventListener;

    public long GetObjectPtr() {
        return this.objPtr;
    }

    private native long addToLocalRendererNative(long var1, LocalRenderer var3);

    private native boolean addToRemoteRendererNative(long var1, RemoteRenderer var3);

    private native void clearConstraintsNative(long var1);

    private native long constructNative(Endpoint var1, VirtualVideoSourceType var2, String var3, String var4);

    private native long constructCopyNative(long var1);

    private native void destructNative(long var1);

    private native long getCurrentEncodeFrameIntervalNative(long var1);

    private native String getIdNative(long var1);

    private native MediaFormat getMediaTypeNative(long var1);

    private native String getNameNative(long var1);

    private native String getPreviewLabelNative(long var1);

    private native VirtualVideoSourceType getTypeNative(long var1);

    private native boolean isPreviewOnNative(long var1);

    private native boolean isSelectedNative(long var1);

    private native void onFrameNative(long var1, VideoFrame var3, MediaFormat var4);

    private native boolean registerEventListenerNative(long var1);

    private native boolean removeFromLocalRendererNative(long var1, LocalRenderer var3);

    private native boolean removeFromRemoteRendererNative(long var1, RemoteRenderer var3);

    private native boolean sendFrameWithExternalDataNative(long var1, MediaFormat var3, byte[] var4, long var5, long var7, long var9);

    private native boolean setBoundsConstraintsNative(long var1, long var3, long var5, int var7, int var8, int var9, int var10);

    private native boolean setDiscreteConstraintsNative(long var1, long var3, long var5, int var7, int var8);

    private native boolean setLowLatencyProfileNative(long var1, boolean var3);

    private native boolean setMinFrameIntervalNative(long var1, long var3);

    private native boolean setPreviewLabelNative(long var1, String var3);

    private native boolean setStreamParametersInLocalRendererNative(long var1, LocalRenderer var3, int var4, int var5, long var6);

    public VirtualVideoSource(Endpoint endpoint, VirtualVideoSourceType type, String id, String name) {
        this.objPtr = this.constructNative(endpoint, type, id, name);
    }

    public VirtualVideoSource(long rPtr) {
        this.objPtr = this.constructCopyNative(rPtr);
    }

    protected void dispose() {
        if (this.objPtr != 0L) {
            this.destructNative(this.objPtr);
        }
        this.objPtr = 0L;
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public void externalMediaBufferReleaseCallback(byte[] buffer, long size, long userData) {
        if (this.RegisterEventListener != null) {
            this.RegisterEventListener.externalMediaBufferReleaseCallback(buffer, size, userData);
        }
    }

    public void reconfigureCallback(long frameInterval, MediaFormat mediaFormat, long userData) {
        if (this.RegisterEventListener != null) {
            this.RegisterEventListener.reconfigureCallback(frameInterval, mediaFormat, userData);
        }
    }

    public void startCallback(long frameInterval, MediaFormat mediaFormat, long userData) {
        if (this.RegisterEventListener != null) {
            this.RegisterEventListener.startCallback(frameInterval, mediaFormat, userData);
        }
    }

    public void stopCallback(long userData) {
        if (this.RegisterEventListener != null) {
            this.RegisterEventListener.stopCallback(userData);
        }
    }

    public long addToLocalRenderer(LocalRenderer renderer) {
        return this.addToLocalRendererNative(this.objPtr, renderer);
    }

    public boolean addToRemoteRenderer(RemoteRenderer remoteRenderer) {
        return this.addToRemoteRendererNative(this.objPtr, remoteRenderer);
    }

    public void clearConstraints() {
        this.clearConstraintsNative(this.objPtr);
    }

    public long getCurrentEncodeFrameInterval() {
        return this.getCurrentEncodeFrameIntervalNative(this.objPtr);
    }

    public String getId() {
        return this.getIdNative(this.objPtr);
    }

    public MediaFormat getMediaType() {
        return this.getMediaTypeNative(this.objPtr);
    }

    public String getName() {
        return this.getNameNative(this.objPtr);
    }

    public String getPreviewLabel() {
        return this.getPreviewLabelNative(this.objPtr);
    }

    public VirtualVideoSourceType getType() {
        return this.getTypeNative(this.objPtr);
    }

    public boolean isPreviewOn() {
        return this.isPreviewOnNative(this.objPtr);
    }

    public boolean isSelected() {
        return this.isSelectedNative(this.objPtr);
    }

    public void onFrame(VideoFrame videoFrame, MediaFormat mediaFormat) {
        this.onFrameNative(this.objPtr, videoFrame, mediaFormat);
    }

    public boolean registerEventListener(IRegisterEventListener RegisterEventListener) {
        this.RegisterEventListener = RegisterEventListener;
        return this.registerEventListenerNative(this.objPtr);
    }

    public boolean removeFromLocalRenderer(LocalRenderer renderer) {
        return this.removeFromLocalRendererNative(this.objPtr, renderer);
    }

    public boolean removeFromRemoteRenderer(RemoteRenderer remoteRenderer) {
        return this.removeFromRemoteRendererNative(this.objPtr, remoteRenderer);
    }

    public boolean sendFrameWithExternalData(MediaFormat format, byte[] buffer, long size, long width, long height) {
        return this.sendFrameWithExternalDataNative(this.objPtr, format, buffer, size, width, height);
    }

    public boolean setBoundsConstraints(long maxFrameInterval, long minFrameInterval, int maxWidth, int minWidth, int maxHeight, int minHeight) {
        return this.setBoundsConstraintsNative(this.objPtr, maxFrameInterval, minFrameInterval, maxWidth, minWidth, maxHeight, minHeight);
    }

    public boolean setDiscreteConstraints(long maxFrameInterval, long minFrameInterval, int width, int height) {
        return this.setDiscreteConstraintsNative(this.objPtr, maxFrameInterval, minFrameInterval, width, height);
    }

    public boolean setLowLatencyProfile(boolean profile) {
        return this.setLowLatencyProfileNative(this.objPtr, profile);
    }

    public boolean setMinFrameInterval(long frameInterval) {
        return this.setMinFrameIntervalNative(this.objPtr, frameInterval);
    }

    public boolean setPreviewLabel(String previewLabel) {
        return this.setPreviewLabelNative(this.objPtr, previewLabel);
    }

    public boolean setStreamParametersInLocalRenderer(LocalRenderer localRenderer, int width, int height, long frameInterval) {
        return this.setStreamParametersInLocalRendererNative(this.objPtr, localRenderer, width, height, frameInterval);
    }

    public static interface IRegisterEventListener {
        public void startCallback(long var1, MediaFormat var3, long var4);

        public void reconfigureCallback(long var1, MediaFormat var3, long var4);

        public void stopCallback(long var1);

        public void externalMediaBufferReleaseCallback(byte[] var1, long var2, long var4);
    }

    public static enum VirtualVideoSourceType {
        VIDYO_VIRTUALVIDEOSOURCETYPE_SHARE,
        VIDYO_VIRTUALVIDEOSOURCETYPE_CAMERA;

    }
}

