/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.LmiUi;

import android.app.Activity;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;

public class LmiWindow
extends TextureView
implements TextureView.SurfaceTextureListener,
View.OnLayoutChangeListener,
View.OnTouchListener,
View.OnKeyListener {
    private static String TAG = "LmiWindow";
    private long nativePtr;
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);
    private static final int LMI_TOUCHSTATE_START = 0;
    private static final int LMI_TOUCHSTATE_MOVE = 1;
    private static final int LMI_TOUCHSTATE_STOP = 2;

    public LmiWindow(Context context, long nativeP) {
        super(context);
        this.nativePtr = nativeP;
        int viewId = Build.VERSION.SDK_INT >= 17 ? LmiWindow.generateViewId() : LmiWindow.generateViewIdFallback();
        this.setId(viewId);
        this.setSurfaceTextureListener(this);
        this.addOnLayoutChangeListener(this);
        this.setOnTouchListener(this);
        this.setOnKeyListener(this);
        this.setVisibility(8);
        Log.d((String)TAG, (String)"LmiWindow constructed in Java");
    }

    private static int generateViewIdFallback() {
        int newValue;
        int result;
        do {
            if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
            newValue = 1;
        } while (!sNextGeneratedId.compareAndSet(result, newValue));
        return result;
    }

    public void stopCallbacks() {
        this.setSurfaceTextureListener(null);
        this.removeOnLayoutChangeListener(this);
        this.setOnTouchListener(null);
        this.setOnKeyListener(null);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        Log.d((String)TAG, (String)("Surface texture available: " + width + "x" + height));
        float scale = 1.0f / this.getPixelDensity();
        this.notifySurfaceTextureAvailable(LmiWindow.scaleCoord(width, scale), LmiWindow.scaleCoord(height, scale));
    }

    public native void notifySurfaceTextureAvailable(int var1, int var2);

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.notifySurfaceTextureDestroyed();
        Log.d((String)TAG, (String)"Surface texture destroyed");
        return true;
    }

    public native void notifySurfaceTextureDestroyed();

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        float scale = 1.0f / this.getPixelDensity();
        int sWidth = LmiWindow.scaleCoord(width, scale);
        int sHeight = LmiWindow.scaleCoord(height, scale);
        Log.d((String)TAG, (String)("Surface texture size changed: " + width + "x" + height + " px = " + sWidth + "x" + sHeight + " dip"));
        this.notifySurfaceTextureSizeChanged(sWidth, sHeight);
    }

    public native void notifySurfaceTextureSizeChanged(int var1, int var2);

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (v != this) {
            throw new IllegalArgumentException("only want to listen for my own layout changes");
        }
        float scale = 1.0f / this.getPixelDensity();
        int width = right - left;
        int height = bottom - top;
        int sLeft = LmiWindow.scaleCoord(left, scale);
        int sTop = LmiWindow.scaleCoord(top, scale);
        int sWidth = LmiWindow.scaleCoord(width, scale);
        int sHeight = LmiWindow.scaleCoord(height, scale);
        Log.d((String)TAG, (String)("Layout changed: " + width + "x" + height + "@" + left + "," + top + " px = " + sWidth + "x" + sHeight + "@" + sLeft + "," + sTop + " dip"));
        this.notifyLayoutChanged(sWidth, sHeight, sLeft, sTop);
    }

    public native void notifyLayoutChanged(int var1, int var2, int var3, int var4);

    public boolean onTouch(View v, MotionEvent event) {
        if (v != this) {
            throw new IllegalArgumentException("only want to listen for my own touch events");
        }
        int action = event.getAction();
        float scale = 1.0f / this.getPixelDensity();
        switch (action & 0xFF) {
            case 0: {
                this.notifyTouchEvent(event.getPointerId(0), 0, LmiWindow.scaleCoord((int)event.getX(), scale), LmiWindow.scaleCoord((int)event.getY(), scale));
                return true;
            }
            case 1: {
                this.notifyTouchEvent(event.getPointerId(0), 2, LmiWindow.scaleCoord((int)event.getX(), scale), LmiWindow.scaleCoord((int)event.getY(), scale));
                return true;
            }
            case 2: {
                for (int idx = 0; idx < event.getPointerCount(); ++idx) {
                    this.notifyTouchEvent(event.getPointerId(idx), 1, LmiWindow.scaleCoord((int)event.getX(idx), scale), LmiWindow.scaleCoord((int)event.getY(idx), scale));
                }
                return true;
            }
            case 5: {
                int idx = (action & 0xFF00) >> 8;
                this.notifyTouchEvent(event.getPointerId(idx), 0, LmiWindow.scaleCoord((int)event.getX(idx), scale), LmiWindow.scaleCoord((int)event.getY(idx), scale));
                return true;
            }
            case 6: {
                int idx = (action & 0xFF00) >> 8;
                this.notifyTouchEvent(event.getPointerId(idx), 2, LmiWindow.scaleCoord((int)event.getX(idx), scale), LmiWindow.scaleCoord((int)event.getY(idx), scale));
                return true;
            }
        }
        return false;
    }

    public native void notifyTouchEvent(int var1, int var2, int var3, int var4);

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        if (v != this) {
            throw new IllegalArgumentException("only want to listen for my own key events");
        }
        return false;
    }

    private static int scaleCoord(int x, float scale) {
        float y = (float)x * scale;
        return y > 0.0f ? (int)((double)y + 0.5) : (int)((double)y - 0.5);
    }

    public static float getPixelDensity(View view) {
        DisplayMetrics metrics = view.getResources().getDisplayMetrics();
        return metrics.density;
    }

    public static float getPixelDensity(Context context) {
        return context.getResources().getDisplayMetrics().density;
    }

    public static float getPixelDensity(View view, Context context) {
        float density = LmiWindow.getPixelDensity(view);
        if (density != 0.0f) {
            return density;
        }
        density = LmiWindow.getPixelDensity(context);
        if (density == 0.0f) {
            Log.w((String)TAG, (String)"Couldn't get pixel density");
            return 1.0f;
        }
        return density;
    }

    public float getPixelDensity() {
        return LmiWindow.getPixelDensity((View)this);
    }

    public static void setContentViewOnUiThread(final Activity activity, final View view, int width, int height, final int left, final int top) throws Exception {
        final float scale = LmiWindow.getPixelDensity(view, (Context)activity);
        final ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(LmiWindow.scaleCoord(width, scale), LmiWindow.scaleCoord(height, scale));
        Runnable task = new Runnable(){

            @Override
            public void run() {
                activity.setContentView(view, layoutParams);
                view.setLeft(LmiWindow.scaleCoord(left, scale));
                view.setTop(LmiWindow.scaleCoord(top, scale));
            }
        };
        FutureTask<Object> action = new FutureTask<Object>(task, null);
        activity.runOnUiThread(action);
        action.get();
    }

    public static void addViewOnUiThread(final Activity activity, final ViewGroup viewGroup, final View view, final int width, final int height, final int left, final int top) throws Exception {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                float scale = LmiWindow.getPixelDensity((View)viewGroup, (Context)activity);
                viewGroup.addView(view, LmiWindow.scaleCoord(width, scale), LmiWindow.scaleCoord(height, scale));
                view.setLeft(LmiWindow.scaleCoord(left, scale));
                view.setTop(LmiWindow.scaleCoord(top, scale));
            }
        };
        FutureTask<Object> action = new FutureTask<Object>(task, null);
        activity.runOnUiThread(action);
        action.get();
    }

    public static void setVisibilityOnUiThread(Activity activity, final View view, final int visibility) throws Exception {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                view.setVisibility(visibility);
            }
        };
        FutureTask<Object> action = new FutureTask<Object>(task, null);
        activity.runOnUiThread(action);
        action.get();
    }

    public static void setPositionOnUiThread(final Activity activity, final View view, final int width, final int height, final int left, final int top) throws Exception {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                float scale = LmiWindow.getPixelDensity(view, (Context)activity);
                ViewGroup.LayoutParams params = view.getLayoutParams();
                params.width = LmiWindow.scaleCoord(width, scale);
                params.height = LmiWindow.scaleCoord(height, scale);
                view.setLayoutParams(params);
                view.setLeft(LmiWindow.scaleCoord(left, scale));
                view.setTop(LmiWindow.scaleCoord(top, scale));
            }
        };
        FutureTask<Object> action = new FutureTask<Object>(task, null);
        activity.runOnUiThread(action);
        action.get();
    }

    public static void removeViewOnUiThread(Activity activity, final View view) throws Exception {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ((ViewGroup)view.getParent()).removeView(view);
            }
        };
        FutureTask<Object> action = new FutureTask<Object>(task, null);
        activity.runOnUiThread(action);
        action.get();
    }
}

