/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.VidyoClient.Device;

import com.vidyo.VidyoClient.Device.LocalRenderer;

public class RemoteCamera {
    private long objPtr;
    public String id;
    public String name;
    private IRegisterFrameSizeListener RegisterFrameSizeListener;

    public long GetObjectPtr() {
        return this.objPtr;
    }

    private native long addToLocalRendererNative(long var1, LocalRenderer var3, RemoteCameraMode var4);

    private native long constructCopyNative(long var1);

    private native boolean controlPTZNative(long var1, int var3, int var4, int var5);

    private native void destructNative(long var1);

    private native String getIdNative(long var1);

    private native long getLocalRenderingStreamIdNative(long var1, int var3);

    private native String getNameNative(long var1);

    private native RemoteCameraPosition getPositionNative(long var1);

    private native boolean isControllableNative(long var1);

    private native boolean registerFrameSizeListenerNative(long var1);

    private native boolean removeFromLocalRendererNative(long var1, LocalRenderer var3);

    private native boolean setPositionInLocalRendererNative(long var1, LocalRenderer var3, int var4, int var5, int var6, int var7, long var8);

    private native boolean showCameraControlNative(long var1, boolean var3);

    private native boolean unregisterFrameSizeListenerNative(long var1);

    public RemoteCamera(long rPtr) {
        this.objPtr = this.constructCopyNative(rPtr);
    }

    protected void dispose() {
        if (this.objPtr != 0L) {
            this.destructNative(this.objPtr);
        }
        this.objPtr = 0L;
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public void onFrameSizeUpdate(long width, long height) {
        if (this.RegisterFrameSizeListener != null) {
            this.RegisterFrameSizeListener.onFrameSizeUpdate(width, height);
        }
    }

    public long addToLocalRenderer(LocalRenderer localRenderer, RemoteCameraMode mode) {
        return this.addToLocalRendererNative(this.objPtr, localRenderer, mode);
    }

    public boolean controlPTZ(int pan, int tilt, int zoom) {
        return this.controlPTZNative(this.objPtr, pan, tilt, zoom);
    }

    public String getId() {
        return this.getIdNative(this.objPtr);
    }

    public long getLocalRenderingStreamId(int index) {
        return this.getLocalRenderingStreamIdNative(this.objPtr, index);
    }

    public String getName() {
        return this.getNameNative(this.objPtr);
    }

    public RemoteCameraPosition getPosition() {
        return this.getPositionNative(this.objPtr);
    }

    public boolean isControllable() {
        return this.isControllableNative(this.objPtr);
    }

    public boolean registerFrameSizeListener(IRegisterFrameSizeListener RegisterFrameSizeListener) {
        this.RegisterFrameSizeListener = RegisterFrameSizeListener;
        return this.registerFrameSizeListenerNative(this.objPtr);
    }

    public boolean removeFromLocalRenderer(LocalRenderer localRenderer) {
        return this.removeFromLocalRendererNative(this.objPtr, localRenderer);
    }

    public boolean setPositionInLocalRenderer(LocalRenderer localRenderer, int x, int y, int width, int height, long frameInterval) {
        return this.setPositionInLocalRendererNative(this.objPtr, localRenderer, x, y, width, height, frameInterval);
    }

    public boolean showCameraControl(boolean show) {
        return this.showCameraControlNative(this.objPtr, show);
    }

    public boolean unregisterFrameSizeListener() {
        return this.unregisterFrameSizeListenerNative(this.objPtr);
    }

    public static interface IRegisterFrameSizeListener {
        public void onFrameSizeUpdate(long var1, long var3);
    }

    public static enum RemoteCameraPosition {
        VIDYO_REMOTECAMERAPOSITION_Unknown,
        VIDYO_REMOTECAMERAPOSITION_Front,
        VIDYO_REMOTECAMERAPOSITION_Back;

    }

    public static enum RemoteCameraMode {
        VIDYO_REMOTECAMERAMODE_Dynamic,
        VIDYO_REMOTECAMERAMODE_Static;

    }
}

