/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.utils;

import com.google.common.net.InetAddresses;
import com.google.common.net.InternetDomainName;
import com.vesoft.nebula.driver.graph.data.HostAddress;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class AddressUtil {
    public static List<HostAddress> validateAddress(String addresses) throws UnknownHostException {
        ArrayList<HostAddress> newAddrs = new ArrayList<HostAddress>();
        for (String addr : addresses.split(",")) {
            InetAddress[] inetAddresses;
            int port;
            String host;
            if (addr == null || addr.isEmpty()) continue;
            String portString = null;
            if (addr.startsWith("[")) {
                String[] hostAndPort = AddressUtil.getHostAndPortFromBracketedAddr(addr);
                host = hostAndPort[0];
                portString = hostAndPort[1].trim();
            } else {
                int colonPos = addr.indexOf(":");
                if (colonPos >= 0 && addr.indexOf(":", colonPos + 1) == -1) {
                    host = addr.substring(0, colonPos);
                    portString = addr.substring(colonPos + 1).trim();
                } else {
                    if (colonPos == -1) {
                        throw new IllegalArgumentException("No port:" + addr);
                    }
                    throw new IllegalArgumentException("Possible bracketless IPv6 literal: " + addr);
                }
            }
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unparseable port number: " + addr);
            }
            for (InetAddress inetAddress : inetAddresses = InetAddress.getAllByName(host)) {
                String ip = inetAddress.getHostAddress();
                if ((InetAddresses.isInetAddress((String)ip) || InetAddresses.isUriInetAddress((String)ip) || InternetDomainName.isValid((String)ip)) && port > 0 && port < 65535) continue;
                throw new IllegalArgumentException(String.format("host %s and port %d is invalid.", ip, port));
            }
            newAddrs.add(new HostAddress(host, port));
        }
        return newAddrs;
    }

    private static String[] getHostAndPortFromBracketedAddr(String hostPortString) {
        int colonIndex = hostPortString.indexOf(58);
        int closeBracketIndex = hostPortString.lastIndexOf(93);
        if (colonIndex == -1 || closeBracketIndex <= colonIndex) {
            throw new IllegalArgumentException("Invalid bracketed host/port: " + hostPortString);
        }
        String host = hostPortString.substring(1, closeBracketIndex);
        if (closeBracketIndex + 1 == hostPortString.length()) {
            throw new IllegalArgumentException("Invalid port for addr:" + hostPortString);
        }
        if (hostPortString.charAt(closeBracketIndex + 1) != ':') {
            throw new IllegalArgumentException("Only a colon may follow a close bracket:" + hostPortString);
        }
        for (int i = closeBracketIndex + 2; i < hostPortString.length(); ++i) {
            if (Character.isDigit(hostPortString.charAt(i))) continue;
            throw new IllegalArgumentException("Port must be numeric: " + hostPortString);
        }
        return new String[]{host, hostPortString.substring(closeBracketIndex + 2)};
    }
}

