/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.decode;

public enum ColumnType {
    COLUMN_TYPE_NODE(1),
    COLUMN_TYPE_EDGE(2),
    COLUMN_TYPE_NULL(3),
    COLUMN_TYPE_BOOL(4),
    COLUMN_TYPE_INT8(5),
    COLUMN_TYPE_UINT8(6),
    COLUMN_TYPE_INT16(7),
    COLUMN_TYPE_UINT16(8),
    COLUMN_TYPE_INT32(9),
    COLUMN_TYPE_UINT32(10),
    COLUMN_TYPE_INT64(11),
    COLUMN_TYPE_UINT64(12),
    COLUMN_TYPE_FLOAT32(13),
    COLUMN_TYPE_FLOAT64(14),
    COLUMN_TYPE_STRING(16),
    COLUMN_TYPE_LIST(17),
    COLUMN_TYPE_PATH(18),
    COLUMN_TYPE_RECORD(19),
    COLUMN_TYPE_EMBEDDINGVECTOR(20),
    COLUMN_TYPE_LOCALTIME(21),
    COLUMN_TYPE_DURATION(22),
    COLUMN_TYPE_DATE(23),
    COLUMN_TYPE_LOCALDATETIME(24),
    COLUMN_TYPE_ZONEDTIME(25),
    COLUMN_TYPE_ZONEDDATETIME(32),
    COLUMN_TYPE_REFERENCE(33),
    COLUMN_TYPE_DECIMAL(34),
    COLUMN_TYPE_GEOGRAPHY(36),
    COLUMN_TYPE_ANY(254),
    COLUMN_TYPE_INVALID(255);

    private int type;

    private ColumnType(int type) {
        this.type = type;
    }

    public static ColumnType getColumnType(int type) {
        for (ColumnType columnType : ColumnType.values()) {
            if (columnType.type != type) continue;
            return columnType;
        }
        throw new RuntimeException("does not define the column type:" + type);
    }

    public static boolean isBasic(ColumnType type) {
        switch (type) {
            case COLUMN_TYPE_NULL: 
            case COLUMN_TYPE_BOOL: 
            case COLUMN_TYPE_INT8: 
            case COLUMN_TYPE_UINT8: 
            case COLUMN_TYPE_INT16: 
            case COLUMN_TYPE_UINT16: 
            case COLUMN_TYPE_INT32: 
            case COLUMN_TYPE_UINT32: 
            case COLUMN_TYPE_INT64: 
            case COLUMN_TYPE_UINT64: 
            case COLUMN_TYPE_FLOAT32: 
            case COLUMN_TYPE_FLOAT64: 
            case COLUMN_TYPE_DATE: 
            case COLUMN_TYPE_LOCALTIME: 
            case COLUMN_TYPE_ZONEDTIME: 
            case COLUMN_TYPE_LOCALDATETIME: 
            case COLUMN_TYPE_ZONEDDATETIME: 
            case COLUMN_TYPE_DURATION: 
            case COLUMN_TYPE_GEOGRAPHY: {
                return true;
            }
        }
        return false;
    }

    public static boolean isComposite(ColumnType type) {
        switch (type) {
            case COLUMN_TYPE_LIST: 
            case COLUMN_TYPE_RECORD: 
            case COLUMN_TYPE_EMBEDDINGVECTOR: 
            case COLUMN_TYPE_NODE: 
            case COLUMN_TYPE_EDGE: 
            case COLUMN_TYPE_PATH: {
                return true;
            }
        }
        return false;
    }
}

