/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.data;

import com.vesoft.nebula.driver.graph.data.Edge;
import com.vesoft.nebula.driver.graph.data.EmbeddingVector;
import com.vesoft.nebula.driver.graph.data.Geography;
import com.vesoft.nebula.driver.graph.data.NDuration;
import com.vesoft.nebula.driver.graph.data.NRecord;
import com.vesoft.nebula.driver.graph.data.Node;
import com.vesoft.nebula.driver.graph.data.Path;
import com.vesoft.nebula.driver.graph.decode.ColumnType;
import com.vesoft.nebula.driver.graph.exception.InvalidValueException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;

public class ValueWrapper {
    private final Object value;
    private final ColumnType type;
    DateTimeFormatter zonedDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSXXXXX");
    DateTimeFormatter localDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
    DateTimeFormatter zonedTimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSSXXXXX");
    DateTimeFormatter localTimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSS");

    public ValueWrapper(Object value, ColumnType type) {
        this.value = value;
        this.type = type;
    }

    public ColumnType getDataType() {
        return this.type;
    }

    public String getDataTypeString() {
        switch (this.type) {
            case COLUMN_TYPE_BOOL: {
                return "BOOLEAN";
            }
            case COLUMN_TYPE_UINT8: {
                return "UINT8";
            }
            case COLUMN_TYPE_INT8: {
                return "INT8";
            }
            case COLUMN_TYPE_UINT16: {
                return "UINT16";
            }
            case COLUMN_TYPE_INT16: {
                return "INT16";
            }
            case COLUMN_TYPE_UINT32: {
                return "UINT32";
            }
            case COLUMN_TYPE_INT32: {
                return "INT32";
            }
            case COLUMN_TYPE_UINT64: {
                return "UINT64";
            }
            case COLUMN_TYPE_INT64: {
                return "INT64";
            }
            case COLUMN_TYPE_FLOAT32: {
                return "FLOAT";
            }
            case COLUMN_TYPE_FLOAT64: {
                return "DOUBLE";
            }
            case COLUMN_TYPE_STRING: {
                return "STRING";
            }
            case COLUMN_TYPE_NODE: {
                return "NODE";
            }
            case COLUMN_TYPE_EDGE: {
                return "EDGE";
            }
            case COLUMN_TYPE_LIST: {
                return "LIST";
            }
            case COLUMN_TYPE_EMBEDDINGVECTOR: {
                return "VECTOR";
            }
            case COLUMN_TYPE_DURATION: {
                return "DURATION";
            }
            case COLUMN_TYPE_LOCALTIME: {
                return "LOCAL_TIME";
            }
            case COLUMN_TYPE_LOCALDATETIME: {
                return "LOCAL_DATETIME";
            }
            case COLUMN_TYPE_ZONEDTIME: {
                return "ZONED_TIME";
            }
            case COLUMN_TYPE_ZONEDDATETIME: {
                return "ZONED_DATETIME";
            }
            case COLUMN_TYPE_DATE: {
                return "DATE";
            }
            case COLUMN_TYPE_RECORD: {
                return "RECORD";
            }
            case COLUMN_TYPE_PATH: {
                return "PATH";
            }
            case COLUMN_TYPE_DECIMAL: {
                return "DECIMAL";
            }
            case COLUMN_TYPE_ANY: {
                return "ANY";
            }
            case COLUMN_TYPE_GEOGRAPHY: {
                return "GEOGRAPHY";
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + (Object)((Object)this.type));
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isBoolean() {
        return this.type == ColumnType.COLUMN_TYPE_BOOL;
    }

    public boolean isLong() {
        return this.type == ColumnType.COLUMN_TYPE_UINT64 || this.type == ColumnType.COLUMN_TYPE_INT64;
    }

    public boolean isInt() {
        return this.type == ColumnType.COLUMN_TYPE_UINT8 || this.type == ColumnType.COLUMN_TYPE_INT8 || this.type == ColumnType.COLUMN_TYPE_UINT16 || this.type == ColumnType.COLUMN_TYPE_INT16 || this.type == ColumnType.COLUMN_TYPE_UINT32 || this.type == ColumnType.COLUMN_TYPE_INT32;
    }

    public boolean isFloat() {
        return this.type == ColumnType.COLUMN_TYPE_FLOAT32;
    }

    public boolean isDouble() {
        return this.type == ColumnType.COLUMN_TYPE_FLOAT64;
    }

    public boolean isString() {
        return this.type == ColumnType.COLUMN_TYPE_STRING;
    }

    public boolean isList() {
        return this.type == ColumnType.COLUMN_TYPE_LIST;
    }

    public boolean isVector() {
        return this.type == ColumnType.COLUMN_TYPE_EMBEDDINGVECTOR;
    }

    public boolean isNode() {
        return this.type == ColumnType.COLUMN_TYPE_NODE;
    }

    public boolean isEdge() {
        return this.type == ColumnType.COLUMN_TYPE_EDGE;
    }

    public boolean isLocalTime() {
        return this.type == ColumnType.COLUMN_TYPE_LOCALTIME;
    }

    public boolean isZonedTime() {
        return this.type == ColumnType.COLUMN_TYPE_ZONEDTIME;
    }

    public boolean isLocalDateTime() {
        return this.type == ColumnType.COLUMN_TYPE_LOCALDATETIME;
    }

    public boolean isZonedDateTime() {
        return this.type == ColumnType.COLUMN_TYPE_ZONEDDATETIME;
    }

    public boolean isDate() {
        return this.type == ColumnType.COLUMN_TYPE_DATE;
    }

    public boolean isRecord() {
        return this.type == ColumnType.COLUMN_TYPE_RECORD;
    }

    public boolean isDuration() {
        return this.type == ColumnType.COLUMN_TYPE_DURATION;
    }

    public boolean isPath() {
        return this.type == ColumnType.COLUMN_TYPE_PATH;
    }

    public boolean isDecimal() {
        return this.type == ColumnType.COLUMN_TYPE_DECIMAL;
    }

    public boolean isGeography() {
        return this.type == ColumnType.COLUMN_TYPE_GEOGRAPHY;
    }

    public boolean asBoolean() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_BOOL) {
            return (Boolean)this.value;
        }
        throw new InvalidValueException("Cannot get field `boolean` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public int asInt() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_INT8 || this.type == ColumnType.COLUMN_TYPE_UINT8 || this.type == ColumnType.COLUMN_TYPE_UINT16 || this.type == ColumnType.COLUMN_TYPE_INT16 || this.type == ColumnType.COLUMN_TYPE_UINT32 || this.type == ColumnType.COLUMN_TYPE_INT32) {
            return Integer.parseInt(this.value.toString());
        }
        throw new InvalidValueException("Cannot get field `int` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public long asLong() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_INT64 || this.type == ColumnType.COLUMN_TYPE_UINT64) {
            return (Long)this.value;
        }
        throw new InvalidValueException("Cannot get field `long` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public String asString() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_STRING) {
            return (String)this.value;
        }
        throw new InvalidValueException("Cannot get field `string` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public float asFloat() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_FLOAT32) {
            return ((Float)this.value).floatValue();
        }
        throw new InvalidValueException("Cannot get field `float` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public double asDouble() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_FLOAT64) {
            return (Double)this.value;
        }
        throw new InvalidValueException("Cannot get field `double` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public List<ValueWrapper> asList() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_LIST) {
            return (List)this.value;
        }
        throw new InvalidValueException("Cannot get field `list` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public Node asNode() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_NODE) {
            return (Node)this.value;
        }
        throw new InvalidValueException("cannot get field `node` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public Edge asEdge() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_EDGE) {
            return (Edge)this.value;
        }
        throw new InvalidValueException("cannot get field `edge` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public LocalTime asLocalTime() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_LOCALTIME) {
            return (LocalTime)this.value;
        }
        throw new InvalidValueException("cannot get field `localtime` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public OffsetTime asZonedTime() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_ZONEDTIME) {
            return (OffsetTime)this.value;
        }
        throw new InvalidValueException("cannot get field `zonedtime` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public LocalDate asDate() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_DATE) {
            return (LocalDate)this.value;
        }
        throw new InvalidValueException("cannot get field `date` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public LocalDateTime asLocalDateTime() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_LOCALDATETIME) {
            return (LocalDateTime)this.value;
        }
        throw new InvalidValueException("cannot get field `localdatetime` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public ZonedDateTime asZonedDateTime() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_ZONEDDATETIME) {
            return (ZonedDateTime)this.value;
        }
        throw new InvalidValueException("cannot get field `zoneddatetime` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public NDuration asDuration() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_DURATION) {
            return (NDuration)this.value;
        }
        throw new InvalidValueException("cannot get field `duration` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public NRecord asRecord() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_RECORD) {
            return (NRecord)this.value;
        }
        throw new InvalidValueException("cannot get field `record` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public Path asPath() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_PATH) {
            return (Path)this.value;
        }
        throw new InvalidValueException("cannot get field `path` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public BigDecimal asDecimal() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_DECIMAL) {
            return (BigDecimal)this.value;
        }
        throw new InvalidValueException("cannot get field `decimal` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public EmbeddingVector asVector() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_EMBEDDINGVECTOR) {
            return (EmbeddingVector)this.value;
        }
        throw new InvalidValueException("cannot get field `vector` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public Geography asGeography() throws InvalidValueException {
        if (this.type == ColumnType.COLUMN_TYPE_GEOGRAPHY) {
            return (Geography)this.value;
        }
        throw new InvalidValueException("cannot get field `geography` because value's type is " + (Object)((Object)this.getDataType()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueWrapper that = (ValueWrapper)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        if (this.isNull()) {
            return null;
        }
        if (this.isBoolean()) {
            return String.valueOf(this.asBoolean());
        }
        if (this.isInt()) {
            return String.valueOf(this.asInt());
        }
        if (this.isLong()) {
            return String.valueOf(this.asLong());
        }
        if (this.isFloat()) {
            return String.valueOf(this.asFloat());
        }
        if (this.isDouble()) {
            return String.valueOf(this.asDouble());
        }
        if (this.isString()) {
            return this.asString();
        }
        if (this.isList()) {
            return this.asList().toString();
        }
        if (this.isRecord()) {
            return this.asRecord().toString();
        }
        if (this.isNode()) {
            return this.asNode().toString();
        }
        if (this.isEdge()) {
            return this.asEdge().toString();
        }
        if (this.isLocalTime()) {
            return this.asLocalTime().format(this.localTimeFormatter);
        }
        if (this.isZonedTime()) {
            return this.asZonedTime().format(this.zonedTimeFormatter);
        }
        if (this.isLocalDateTime()) {
            return this.asLocalDateTime().format(this.localDateTimeFormatter);
        }
        if (this.isZonedDateTime()) {
            return this.asZonedDateTime().format(this.zonedDateTimeFormatter);
        }
        if (this.isDate()) {
            return this.asDate().toString();
        }
        if (this.isDuration()) {
            return this.asDuration().toString();
        }
        if (this.isPath()) {
            return this.asPath().toString();
        }
        if (this.isDecimal()) {
            return this.asDecimal().toString();
        }
        if (this.isVector()) {
            return this.asVector().toString();
        }
        if (this.isGeography()) {
            return this.asGeography().toString();
        }
        return "Unknown type: " + (Object)((Object)this.getDataType());
    }
}

