/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph;

import java.util.HashMap;
import java.util.Map;

public enum ErrorCode {
    SUCCESSFUL_COMPLETION("00000"),
    OMITTED_RESULT("00001"),
    WARNING("01000"),
    WARNING_STRING_DATA_RIGHT_TRUNCATION("01004"),
    DEPRECATED_SYNTAX("01005"),
    CATALOG_GRAPH_NOT_FOUND("01G03"),
    CATALOG_GRAPH_TYPE_NOT_FOUND("01G04"),
    CATALOG_PLUGIN_NOT_FOUND("01G05"),
    NULL_VALUE_ELIMINATED_IN_SET_FUNCTION("01G11"),
    CATALOG_PROCEDURE_NOT_FOUND("01G12"),
    NO_DATA("02000"),
    INFORMATIONAL("03000"),
    CONNECTION_EXCEPTION("08000"),
    TRANSACTION_RESOLUTION_UNKNOWN("08007"),
    DATA_EXCEPTION("22000"),
    DATA_STRING_DATA_RIGHT_TRUNCATION("22001"),
    NUMERIC_VALUE_OUT_OF_RANGE("22003"),
    NULL_VALUE_NOT_ALLOWED("22004"),
    INVALID_DATE_TIME_OR_DATETIME_FORMAT("22007"),
    DATETIME_FIELD_OVERFLOW("22008"),
    PARSE_TEMPORAL_FAIL("22009"),
    SUBSTRING_ERROR("22011"),
    DIVISION_BY_ZERO("22012"),
    INTERVAL_FIELD_OVERFLOW("22015"),
    INVALID_CHARACTER_VALUE_FOR_CAST("22018"),
    INVALID_ARGUMENT_FOR_NATURAL_LOGARITHM("2201E"),
    INVALID_ARGUMENT_FOR_POWER_FUNCTION("2201F"),
    INVALID_ARGUMENT_FOR_LOG("22020"),
    TRIM_ERROR("22027"),
    ARRAY_DATA_RIGHT_TRUNCATION("2202F"),
    NEGATIVE_LIMIT_VALUE("22G02"),
    INVALID_VALUE_TYPE("22G03"),
    VALUES_NOT_COMPARABLE("22G04"),
    INVALID_DATE_TIME_OR_DATETIME_FUNCTION_FIELD_NAME("22G05"),
    INVALID_DATETIME_FUNCTION_VALUE("22G06"),
    INVALID_DURATION_FUNCTION_FIELD_NAME("22G07"),
    LIST_DATA_RIGHT_TRUNCATION("22G0B"),
    LIST_ELEMENT_ERROR("22G0C"),
    INVALID_NUMBER_OF_PATHS_OR_GROUPS("22G0F"),
    INVALID_DURATION_FORMAT("22G0H"),
    MULTIPLE_ASSIGNMENTS_TO_A_GRAPH_ELEMENT_PROPERTY("22G0M"),
    DATA_NUMBER_OF_NODE_LABELS_BELOW_SUPPORTED_MINIMUM("22G0N"),
    DATA_NUMBER_OF_NODE_LABELS_EXCEEDS_SUPPORTED_MAXIMUM("22G0P"),
    DATA_NUMBER_OF_EDGE_LABELS_BELOW_SUPPORTED_MINIMUM("22G0Q"),
    DATA_NUMBER_OF_EDGE_LABELS_EXCEEDS_SUPPORTED_MAXIMUM("22G0R"),
    DATA_NUMBER_OF_NODE_PROPERTIES_EXCEEDS_SUPPORTED_MAXIMUM("22G0S"),
    DATA_NUMBER_OF_EDGE_PROPERTIES_EXCEEDS_SUPPORTED_MAXIMUM("22G0T"),
    RECORD_FIELDS_DO_NOT_MATCH("22G0U"),
    REFERENCE_VALUE_INVALID_BASE_TYPE("22G0V"),
    REFERENCE_VALUE_INVALID_CONSTRAINED_TYPE("22G0W"),
    RECORD_DATA_FIELD_UNASSIGNABLE("22G0X"),
    RECORD_DATA_FIELD_MISSING("22G0Y"),
    MALFORMED_PATH("22G0Z"),
    PATH_DATE_RIGHT_TRUNCATION("22G10"),
    REFERENCE_VALUE_REFERENT_DELETED("22G11"),
    INVALID_GROUP_VARIABLE_VALUE("22G13"),
    INCOMPATIBLE_TEMPORAL_DURATION_UNIT_GROUPS("22G14"),
    VALUE_OUT_OF_LIMITS("22G15"),
    INVALID_LONGITUDE_VALUE("22G16"),
    INVALID_LATITUDE_VALUE("22G17"),
    INVALID_LINE_STRING("22G18"),
    INVALID_POLYGON("22G19"),
    INVALID_WKT_DATA("22G20"),
    INVALID_WKB_DATA("22G21"),
    INVALID_TRANSACTION_STATE("25000"),
    ACTIVE_GQL_TRANSACTION("25G01"),
    CATALOG_AND_DATA_STATEMENT_MIXING_NOT_SUPPORTED("25G02"),
    READ_ONLY_GQL_TRANSACTION("25G03"),
    ACCESSING_MULTIPLE_GRAPHS_NOT_SUPPORTED("25G04"),
    INVALID_TRANSACTION_TERMINATION("2D000"),
    TRANSACTION_ROLLBACK("40000"),
    STATEMENT_COMPLETION_UNKNOWN("40003"),
    SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION("42000"),
    INVALID_SYNTAX("42001"),
    INVALID_REFERENCE("42002"),
    USE_OF_VISUALLY_CONFUSABLE_IDENTIFIERS("42004"),
    SYNTAX_NUMBER_OF_EDGE_LABELS_BELOW_SUPPORTED_MINIMUM("42006"),
    SYNTAX_NUMBER_OF_EDGE_LABELS_EXCEEDS_SUPPORTED_MAXIMUM("42007"),
    SYNTAX_NUMBER_OF_EDGE_PROPERTIES_EXCEEDS_SUPPORTED_MAXIMUM("42008"),
    SYNTAX_NUMBER_OF_NODE_LABELS_BELOW_SUPPORTED_MINIMUM("42009"),
    SYNTAX_NUMBER_OF_NODE_LABELS_EXCEEDS_SUPPORTED_MAXIMUM("42010"),
    SYNTAX_NUMBER_OF_NODE_PROPERTIES_EXCEEDS_SUPPORTED_MAXIMUM("42011"),
    NUMBER_OF_NODE_TYPE_KEY_LABELS_BELOW_SUPPORTED_MINIMUM("42012"),
    NUMBER_OF_NODE_TYPE_KEY_LABELS_EXCEEDS_SUPPORTED_MAXIMUM("42013"),
    NUMBER_OF_EDGE_TYPE_KEY_LABELS_BELOW_SUPPORTED_MINIMUM("42014"),
    NUMBER_OF_EDGE_TYPE_KEY_LABELS_EXCEEDS_SUPPORTED_MAXIMUM("42015"),
    INVALID_ANN_SYNTAX("42016"),
    INVALID_FULLTEXT_INDEX_ACCESS("42017"),
    EMPTY_STATEMENT("42N01"),
    INVALID_SYNTAX_NOT_FOUND_IN_PROPS("42N03"),
    INVALID_SYNTAX_DST_TYPE_OF_EDGE_NOT_SPECIFIED("42N05"),
    INVALID_SYNTAX_UNKNOWN_ELEMENT_TYPE("42N06"),
    INVALID_SYNTAX_DUPLICATE_PROPERTY("42N08"),
    INVALID_SYNTAX_VALUE_QUERY_LAST_STMT_MUST_BE_RETURN_LIMIT1_OR_SINGLE_AGG("42N09"),
    INVALID_SYNTAX_EQUI_JOIN_ON_CONDITIONAL_VAR("42N15"),
    INVALID_SYNTAX_EQUI_JOIN_ON_GROUP_VAR("42N16"),
    INVALID_SYNTAX_VAR_TYPE_ERROR("42N17"),
    INVALID_SYNTAX_VAR_NOT_DEFINED("42N18"),
    INVALID_SYNTAX_INSERT_BOUND_NODE("42N19"),
    INVALID_SYNTAX_VAR_INVALID_NODE_TYPE("42N20"),
    INVALID_SYNTAX_VAR_REFER_MULTIPLE_NODE_TYPE("42N21"),
    INVALID_SYNTAX_REDEFINED_VAR("42N22"),
    INVALID_SYNTAX_CONFLICT_VAR_TYPE("42N23"),
    INVALID_SYNTAX_YIELD_ITEM_TYPE("42N24"),
    INVALID_SYNTAX_MULTIPLE_NODE_INSERT("42N25"),
    INVALID_SYNTAX_DUPLICATED_PROPERTY_NAME("42N26"),
    INVALID_SYNTAX_DUPLICATED_INDEX_PROPERTY("42N27"),
    INVALID_SYNTAX_ALTER_ELEMENT_MULTI_TIME("42N29"),
    INVALID_SYNTAX_ADD_PRIMARY_KEY_OR_MULTI_EDGE_KEY("42N30"),
    INVALID_SYNTAX_ADD_INVALID_PROPERTY("42N31"),
    INVALID_SYNTAX_ILLEGAL_BYTE_STRING("42N33"),
    INVALID_SYNTAX_LABEL_EXPR_ELEMENT_TYPE_EXPR_COEXIST("42N34"),
    INVALID_IDENTIFIER("42N35"),
    INVALID_SYNTAX_FIELD_NUMBER_MISMATCH("42N36"),
    INVALID_SYNTAX_FIELD_NOT_FOUND("42N37"),
    INVALID_SYNTAX_OPTION_REDEFINITION("42N38"),
    INVALID_SYNTAX_ILLEGAL_OPTION("42N39"),
    INVALID_SYNTAX_NESTED_VECTOR_TYPE("42N41"),
    INCONSISTENT_QUERY_CONJUNCTION("42N42"),
    INVALID_SYNTAX_NEST_QUERY_RETURN_GRAPH_ERROR("42N43"),
    INVALID_SYNTAX_BUILD_GRAPH_ERROR("42N44"),
    INVALID_SYNTAX_YIELD_CLAUSE_AFTER_GRAPH_PATTERN_NOT_SUPPORTED("42N45"),
    INVALID_SYNTAX_RETURN_OR_FINISH_CAN_ONLY_BE_LAST_STATEMENT("42N46"),
    INVALID_SYNTAX_LINEAR_QUERY_SHOULD_ENDS_WITH_RETURN_OR_FINISH("42N47"),
    INVALID_SYNTAX_DDL_MIXD_WITH_NON_DDL("42N48"),
    INVALID_SYNTAX_FOCUSED_MIXED_WITH_AMBIENT("42N49"),
    INVALID_SYNTAX_NEXT_CONNECTED_DDL_STATEMENT("42N50"),
    INVALID_SYNTAX_MATCH_COMPUTE_CLAUSE_ERROR("42N51"),
    INVALID_SYNTAX_INVALID_NODE_VAR_REFERENCE("42N54"),
    INVALID_SYNTAX_AGGREGATOR_NOT_DEFINED("42N56"),
    DEPENDENT_OBJECT_ERROR("G1000"),
    EDGES_STILL_EXIST("G1001"),
    ENDPOINT_NODE_IS_DELETED("G1002"),
    ENDPOINT_NODE_NOT_IN_CURRENT_WORKING_GRAPH("G1003"),
    GRAPH_TYPE_VIOLATION("G2000"),
    PART_NOT_FOUND("ND001"),
    NODE_ALREADY_EXIST("ND002"),
    EDGE_ALREADY_EXIST("ND003"),
    PROPERTY_NOT_FOUND("ND004"),
    LEADER_CHANGED("ND005"),
    BINDING_TABLE_WRITE_FAILED("ND006"),
    BINDING_TABLE_NO_SPACE("ND007"),
    PROPERTY_NOT_NULLABLE("ND008"),
    PART_NOT_FOUND_IN_ROUTER("ND009"),
    SYSTEM_PART_NOT_FOUND("ND010"),
    SYSTEM_PART_NOT_OWNER("ND011"),
    PART_EMPTY_IN_ROUTER("ND012"),
    NO_VALID_PEER_IN_ROUTER("ND013"),
    TRIM_LIST_OUT_OF_RANGE("NQ001"),
    INVALID_TEMPORAL_INSTANT_SUBTRACTION("NQ002"),
    KVSTORE_ERROR("TK000"),
    KVSTORE_BATCH_WRITE_FAILED("TK001"),
    KVSTORE_GET_PROPERTY_FAILED("TK002"),
    KVSTORE_SET_OPTION_FAILED("TK003"),
    KVSTORE_KEY_NOT_FOUND("TK004"),
    KVSTORE_COMMIT_FAILED("TK005"),
    KVSTORE_GET_FAILED("TK006"),
    KVSTORE_PUT_FAILED("TK007"),
    KVSTORE_REMOVE_FAILED("TK008"),
    KVSTORE_INGEST_FAILED("TK009"),
    KVSTORE_COMPACT_FAILED("TK010"),
    KVSTORE_FLUSH_FAILED("TK011"),
    KVSTORE_CHECKPOINT_FAILED("TK012"),
    KVSTORE_COLUMN_FAMILY_NOT_FOUND("TK013"),
    KVSTORE_OPEN_FAILED("TK014"),
    KVSTORE_OPTIONS_INVALID("TK015"),
    KVSTORE_LOCK_FAILED("TK016"),
    KVSTORE_EXPORT_TABLE_FAILED("TK017"),
    KVSTORE_OPEN_SST_FAILED("TK018"),
    KVSTORE_PREFIX_INVALID("TK019"),
    KVSTORE_NO_SPACE("TK020"),
    CATALOG_ERROR("NC000"),
    CATALOG_DIRECTORY_NOT_FOUND("NC001"),
    CATALOG_SCHEMA_NOT_FOUND("NC002"),
    CATALOG_NODE_TYPE_NOT_FOUND("NC003"),
    CATALOG_EDGE_TYPE_NOT_FOUND("NC004"),
    CATALOG_PRIMARY_KEY_NOT_FOUND("NC005"),
    CATALOG_PROPERTY_NOT_FOUND("NC006"),
    CATALOG_INDEX_NOT_FOUND("NC007"),
    CATALOG_PRIMARY_KEY_PROPERTY_NOT_FOUND("NC008"),
    CATALOG_ELEMENT_TYPE_FOR_INSERT_NOT_FOUND("NC009"),
    CATALOG_EPOCH_ERROR("NC010"),
    CATALOG_LABEL_NOT_FOUND("NC011"),
    CATALOG_NODE_TTL_NOT_SUPPORTED("NC012"),
    CATALOG_TTL_PROPERTY_EXIST("NC013"),
    CATALOG_FUNCTION_NOT_FOUND("NC014"),
    CATALOG_SCHEMA_ALREADY_EXISTS("NC101"),
    CATALOG_EDGE_TYPE_ALREADY_EXIST("NC102"),
    CATALOG_NODE_TYPE_ALREADY_EXIST("NC103"),
    CATALOG_GRAPH_TYPE_ALREADY_EXIST("NC104"),
    CATALOG_GRAPH_ALREADY_EXIST("NC105"),
    CATALOG_PROPERTY_ALREADY_EXIST("NC106"),
    CATALOG_NODE_INDEX_ALREADY_EXISTS("NC107"),
    CATALOG_EDGE_INDEX_ALREADY_EXISTS("NC108"),
    CATALOG_LABEL_ALREADY_EXIST("NC109"),
    CATALOG_PLUGIN_ALREADY_EXIST("NC110"),
    CATALOG_NODE_VECTOR_INDEX_ALREADY_EXISTS("NC111"),
    CATALOG_EDGE_VECTOR_INDEX_ALREADY_EXISTS("NC112"),
    CATALOG_PROCEDURE_ALREADY_EXISTS("NC113"),
    CATALOG_FUNCTION_ALREADY_EXISTS("NC114"),
    CATALOG_NODE_SPATIAL_INDEX_ALREADY_EXISTS("NC115"),
    CATALOG_EDGE_SPATIAL_INDEX_ALREADY_EXISTS("NC116"),
    CATALOG_GRAPH_TYPE_MISMATCH("NC201"),
    CATALOG_PRIMARY_KEY_NULLABLE("NC202"),
    CATALOG_INDEX_PROPERTY_TYPE_NOT_SUPPORTED("NC203"),
    CATALOG_PROPERTY_INVALID("NC204"),
    CATALOG_NODE_TYPE_USED("NC205"),
    CATALOG_INVALID_SPATIAL_INDEX("NC206"),
    CATALOG_CANCEL_JOB_FAILED("NC301"),
    CATALOG_VERSION_RETIRED("NC302"),
    CATALOG_DDL_TIMEOUT("NC303"),
    CATALOG_DDL_ILLEGAL("NC304"),
    CATALOG_REORG_FAILED("NC305"),
    CATALOG_MAXIMUM_PENDING_DDL_EXCEEDED("NC306"),
    CATALOG_JOB_PENDING("NC307"),
    CATALOG_NOT_READY("NC308"),
    CATALOG_REORG_INTERRUPT("NC309"),
    CATALOG_DDL_INTERRUPT("NC310"),
    RPC_FAILED("TN001"),
    RPC_REQUEST_INVALID("TN002"),
    RPC_REQUEST_HANDLER_NOT_FOUND("TN003"),
    RPC_RETRY_FAILED("TN004"),
    RPC_DESERIALIZE_ERROR("TN005"),
    RPC_DESERIALIZE_OBJECT_TYPE_ERROR("TN006"),
    RPC_STORAGE_SERVICE_NOT_FOUND("TN007"),
    INVALID_PARAMETER("NI000"),
    META_SERVICE_GROUP_ALREADY_EXISTS("NI001"),
    META_SERVICE_GROUP_NOT_FOUND("NI002"),
    META_SERVICE_GROUP_NAME_INVALID("NI003"),
    META_SERVICE_GROUP_IS_NOT_EMPTY("NI004"),
    META_SERVICE_HOST_NOT_ADDED("NI101"),
    META_SERVICE_REPORT_NOT_MATCH_ADDED("NI102"),
    META_SERVICE_ALREADY_EXISTS("NI103"),
    META_HOST_ALREADY_EXISTS("NI104"),
    META_HOST_NOT_FOUND("NI105"),
    META_AGENT_ALREADY_EXISTS("NI106"),
    META_SERVICE_STATIC_PORT_ALREADY_EXISTS("NI107"),
    META_SERVICE_DYNAMIC_PORT_ALREADY_EXISTS("NI108"),
    META_FAILED_ADD_SERVICE("NI109"),
    META_SERVICE_NOT_ADDED("NI110"),
    META_SERVICE_IN_USE("NI111"),
    META_SERVICE_NOT_IN_SERVICE_GROUP("NI112"),
    META_ACTIVE_SERVICE_NOT_ENOUGH("NI113"),
    META_INSUFFICIENT_SERVICE("NI114"),
    META_HOST_NAME_INVALID("NI115"),
    META_ADD_HOST_WITHOUT_ZONE("NI116"),
    META_REMOVE_HOST_WITH_VALID_SERVICES("NI117"),
    META_FAILED_BATCH_ADD_SERVICE("NI118"),
    META_FAILED_REPLACE_WITH_SINGLE_REPLICA("NI119"),
    META_FAILED_REPLACE_WITH_REPLICA_NOT_MATCH("NI120"),
    META_PART_CONFIG_INVALID("NI201"),
    META_NOT_ENOUGH_LOCATION("NI202"),
    META_PART_ALREADY_EXIST("NI203"),
    META_PART_LEADER_NOT_ENOUGH("NI204"),
    META_PART_NOT_ENOUGH("NI205"),
    META_BALANCE_PART_RUNNING("NI206"),
    META_BALANCE_LEADER_RUNNING("NI207"),
    META_NO_PART("NI208"),
    META_PART_NOT_EXIST("NI209"),
    META_BALANCE_LEADER_FAILED("NI210"),
    META_SERVICE_NOT_EXIST("NI211"),
    STORAGE_EXECUTOR_PARAMETER_INVALID("NI301"),
    STORAGE_EXECUTOR_PARAMETER_TYPE_INVALID("NI302"),
    CONFIGURATION_INVALID("NI401"),
    CONFIGURATION_ITEM_NOT_FOUND("NI402"),
    CONFIGURATION_ITEM_TYPE_INVALID("NI403"),
    CONFIGURATION_ITEM_RANGE_INVALID("NI404"),
    CONFIGURATION_INFO_FILE_FORMAT_ILLEGAL("NI405"),
    CONFIGURATION_INVALID_CONFIG_KEY("NI406"),
    CONFIGURATION_INVALID_AUDIT_CATEGORY("NI407"),
    CONFIGURATION_MISSING_CONFIG_KEY("NI408"),
    CONFIGURATION_ILLEGAL_FORMAT("NI409"),
    ARG_ILLEGAL_FILE_FORMAT("NI501"),
    META_DEFAULT_ZONE_ALREADY_EXIST("NI601"),
    META_ZONE_ALREADY_EXIST("NI602"),
    META_ZONE_REPLICAS_EXCEED_MAX_REPLICAS("NI603"),
    META_ZONE_REPLICAS_NOT_MATCH_MAX_REPLICAS("NI604"),
    META_ZONE_NAME_INVALID("NI605"),
    META_ZONE_REPLICAS_INVALID("NI606"),
    META_ZONE_PRIORITY_INVALID("NI607"),
    META_ZONE_NOT_EXIST("NI608"),
    META_DROP_ZONE_WITH_HOSTS("NI609"),
    META_DROP_INSIDE_ZONE("NI610"),
    META_ZONE_NOT_ENOUGH_LOCATION("NI611"),
    META_CREATE_CHANGE_EVENT_FAILED("NI612"),
    META_ZONE_NAME_CONFLICT_WITH_BUILT_IN_NAME("NI613"),
    META_OPERATOR_STATUS_INVALID("NI701"),
    META_ADD_OPERATOR_FAILED("NI702"),
    META_STEP_CHECK_FAILED("NI703"),
    META_OPERATOR_LIMITED("NI704"),
    META_OPERATOR_ALREADY_RUNNING("NI705"),
    META_STEP_TIMEOUT("NI706"),
    ADMIN_LIST_USER_ERROR("NI801"),
    GRAPH_COMPUTE_ERROR("NG000"),
    EDGE_PROPERTY_NOT_FOUND("NG001"),
    INVALID_EDGE_DISTANCE("NG002"),
    PLUGIN_ERROR("NP000"),
    PLUGIN_INVALID_TYPE("NP001"),
    PLUGIN_MULTIPLE_PLUGIN("NP002"),
    PLUGIN_CONFIG_NOT_FOUND("NP003"),
    PLUGIN_CONFIG_PARSE_ERROR("NP004"),
    PLUGIN_INIT_ERROR("NP005"),
    PLUGIN_DESTROY_ERROR("NP006"),
    PLUGIN_UNSUPPORT_AUTH_TYPE("NP007"),
    REPORT_PLUGIN_STATUS_FAILED("NP008"),
    GET_PLUGIN_STATUS_FAILED("NP009"),
    PROCEDURE_ERROR("NP101"),
    PROCEDURE_INVALID_ARGUMENT("NP102"),
    PROCEDURE_INVALID_ARGUMENT_ENCODE("NP104"),
    PROCEDURE_YIELD_COLUMN_ERROR("NP105"),
    PROCEDURE_UNKNOWN_YIELD_COLUMN("NP106"),
    PROCEDURE_RETURN_TYPE_MISMATCH("NP107"),
    PROCEDURE_INVALID_PROCEDURE_DEF("NP108"),
    PROCEDURE_DROP_MULTIPLE_PROCEDURE("NP109"),
    PROCEDURE_ALTER_MULTIPLE_PROCEDURE("NP110"),
    PROCEDURE_ALTER_CONFLICT_EXISTING("NP111"),
    UDF_ERROR("NP201"),
    MODULE_ERROR("NP301"),
    MODULE_ALREADY_LOADED("NP302"),
    MODULE_NOT_FOUND("NP303"),
    MODULE_BEING_USED("NP304"),
    MODULE_INVALID_PROC_NAME("NP305"),
    MODULE_INVALID_FUNC_NAME("NP306"),
    MODULE_INVALID_PLUGIN_NAME("NP307"),
    MODULE_INVALID_PLUGIN_API_VERSION("NP308"),
    MODULE_INVALID_NULL_PLUGIN("NP309"),
    MODULE_DLOPEN_ERROR("NP310"),
    MODULE_CANNOT_UNLOAD("NP311"),
    MODULE_INVALID_REGISTER("NP312"),
    CONNECTOR_ERROR("NP401"),
    CONNECTOR_PLUGIN_NOT_FOUND("NP402"),
    CONNECTOR_PLUGIN_UNSUPPORTED_OUTPUT_TYPE("NP403"),
    CONNECTOR_CSV_ERROR("NP404"),
    CONNECTOR_PARQUET_ERROR("NP405"),
    CONNECTOR_ORC_ERROR("NP406"),
    DATA_SINK_NOT_FOUND("NP407"),
    DATA_SINK_ALREADY_EXISTS("NP408"),
    AUTHENTICATE_ERROR("NH000"),
    AUTH_INVALID_PASSWORD("NH001"),
    AUTH_USER_EXIST("NH002"),
    AUTH_USER_NOT_EXIST("NH003"),
    AUTH_USER_DISABLED("NH004"),
    AUTH_USER_LOCKED("NH005"),
    AUTH_INVALID_USERNAME("NH006"),
    AUTH_INVALID_USERNAME_OR_PASSWORD("NH007"),
    AUTH_CANNOT_DISABLE_SYSTEM_USER("NH008"),
    AUTH_NEED_CHANGE_PASSWORD("NH009"),
    AUTH_DROP_SYS_USER_ERROR("NH010"),
    AUTH_USER_LOGIN_ATTEMPTS("NH011"),
    AUTH_DROP_GROUP_OWNER_ERROR("NH012"),
    AUTH_INVALID_HOME_SCHEMA("NH013"),
    AUTH_INVALID_AUTH_INFO("NH101"),
    AUTH_INVALID_TOKEN("NH201"),
    AUTH_PLUGIN_INTERNAL_ERROR("NH401"),
    AUTH_RETURN_CAS_URL("NH402"),
    AUTHORIZE_ERROR("NB000"),
    AUTHORIZE_INVALID_ROLENAME("NB001"),
    AUTHORIZE_INVALID_OBJECT("NB002"),
    AUTHORIZE_ROLE_EXIST("NB003"),
    AUTHORIZE_ROLE_NOT_EXIST("NB004"),
    AUTHORIZE_USER_NOT_EXIST("NB005"),
    AUTHORIZE_USER_EXIST("NB006"),
    AUTHORIZE_INSUFFICIENT_PRIVILEGE("NB101"),
    AUTHORIZE_CONSTRAINT("NB102"),
    AUTHORIZE_TOO_MANY_ROLES("NB103"),
    AUTHORIZE_TOO_LONG_COMMENT("NB104"),
    AUTHORIZE_SHOW_ROLE_ERROR("NB105"),
    AUTHORIZE_SHOW_PRIVILEGE_ERROR("NB106"),
    AUTHORIZE_ALTER_OWNER_ERROR("NB107"),
    AUTHORIZE_SHOW_OBJECTS_ERROR("NB108"),
    SESSION_ERROR("NE000"),
    CREATE_SESSION_FAILED("NE001"),
    UNSUPPORTED_PROTOCOL_VERSION("NE002"),
    CONFIG_ERROR("NV000"),
    CONFIG_NOT_EXIST("NV001"),
    CONFIG_TYPE_ERROR("NV002"),
    CONFIG_DATA_ERROR("NV003"),
    CONFIG_SET_SCOPE_ERROR("NV004"),
    CONFIG_DEPRECATED("NV005"),
    CONFIG_IMMUTABLE("NV006"),
    CONFIG_INVALID_ADDRESS("NV007"),
    ANALYTIC_ERROR("AN000"),
    ANALYTIC_COMMUNICATION_ERROR("AN001"),
    ANALYTIC_FEATURE_UNSUPPORTED("AN002"),
    ANALYTIC_INVALID_PARTITION_METHOD("AN101"),
    ANALYTIC_TASK_ERROR("AN102"),
    ANALYTIC_LOG_EXCEED_LIMIT("AN103"),
    ANALYTIC_WORKER_EXIST("AN201"),
    ANALYTIC_WORKER_NOT_FOUND("AN202"),
    ANALYTIC_READER_ERROR("AN203"),
    ANALYTIC_TASK_NOT_FOUND("AN204"),
    ANALYTIC_AGGREGATOR_NOT_FOUND("AN301"),
    ANALYTIC_AGGREGATOR_EXIST("AN302"),
    ANALYTIC_INVALID_AGGREGATOR_TYPE("AN303"),
    ANALYTIC_TABLE_NOT_FOUND("AN401"),
    ANALYTIC_TABLE_EXIST("AN402"),
    ANALYTIC_ACTIVE_SET_NOT_FOUND("AN501"),
    ANALYTIC_ACTIVE_SET_EXIST("AN502"),
    ANALYTIC_SHUFFLE_SEND_FAILED("AN601"),
    SHUFFLE_NOT_FOUND("AN602"),
    META_NOT_SUPPORTED("TM001"),
    META_NOT_INIT("TM002"),
    META_RESP_NOT_SET("TM003"),
    META_WRITE_KV_FAILED("TM004"),
    META_SERVICE_NOT_FOUND("TM005"),
    META_SERVICE_ID_ERROR("TM006"),
    META_GET_KV_PREFIX_FAILED("TM007"),
    META_PUT_SERVICE_ADDRESS_FAILED("TM008"),
    META_LIST_SERVICE_FAILED("TM009"),
    META_CANNOT_FIND_SERVICE("TM010"),
    GET_META_CLIENT_FAILED("TM011"),
    META_UNSUPPORTED_SERVICE("TM012"),
    META_SERVICE_FAIL_TO_ALLOC_ID("TM013"),
    STORAGE_CODEC_PROPERTY_NOT_NULLABLE("NO001"),
    STORAGE_CODEC_PROPERTY_NOT_SET("NO002"),
    STORAGE_CODEC_PROPERTY_NOT_FOUND("NO003"),
    STORAGE_CODEC_PROPERTY_TYPE_NOT_MATCH("NO004"),
    STORAGE_CODEC_PROPERTY_OUT_OF_RANGE("NO005"),
    STORAGE_CODEC_PROPERTY_UNABLE_TO_ENCODE("NO006"),
    STORAGE_CODEC_INDEX_ILLEGAL("NO007"),
    STORAGE_CODEC_INDEX_PROPERTIES_ILLEGAL("NO008"),
    STORAGE_CODEC_INDEX_PROPERTY_NOT_REQUIRED("NO009"),
    STORAGE_CODEC_DECODE_FAILED("NO010"),
    STORAGE_CODEC_PROPERTY_LIST_NEST_TYPE_NOT_FOUND("NO011"),
    STORAGE_CODEC_INDEX_CORRUPTION_NO_TERMINATOR("NO012"),
    STORAGE_CODEC_INDEX_PROPERTIES_ILLEGAL_PROPERTY_NOT_EXIST("NO013"),
    STORAGE_CODEC_INDEX_ILLEGAL_NOT_RESERVED_PROPERTY("NO014"),
    STORAGE_CODEC_WRITE_VECTOR_FAILED("NO015"),
    GET_ALL_PART_FAILED("NO101"),
    GET_PART_ROUTER_FAILED("NO102"),
    GET_ALL_LEADER_FAILED("NO103"),
    RAFT_INVALID_PEER("TA001"),
    RAFT_RPC_EXCEPTION("TA002"),
    RAFT_TIMEOUT("TA003"),
    RAFT_CATCHUP("TA004"),
    RAFT_LEADER_REMOVED("TA005"),
    RAFT_SET_PEER("TA006"),
    RAFT_NODE_STOP("TA007"),
    RAFT_HIGHER_TERM_REQUEST("TA008"),
    RAFT_HIGHER_TERM_RESPONSE("TA009"),
    RAFT_BAD_NODE("TA010"),
    RAFT_VOTE_FOR_CANDIDATE("TA011"),
    RAFT_NEW_LEADER("TA012"),
    RAFT_LEADER_CONFLICT("TA013"),
    RAFT_TRANSFER_LEADER("TA014"),
    RAFT_STOP("TA015"),
    RAFT_BUSY("TA016"),
    RAFT_INVALID("TA017"),
    RAFT_FAILED("TA018"),
    RAFT_SNAPSHOT_FAILED("TA019"),
    EXPR_EVAL_FAILED("22N02"),
    RUNTIME_ERROR("NR000"),
    EXPR_ERROR("NR001"),
    UNDEFINED_FUNCTION("NR002"),
    INVALID_FUNCTION_ARGUMENT("NR003"),
    INVALID_LOGICAL_EXPRESSION("NR004"),
    EXPR_COMPILE_FAILED("NR005"),
    RESOLVE_FUNCTION_FAILED("NR006"),
    EXPR_TYPE_INFER_FAILED("NR007"),
    INVALID_CAST_EXPR("NR008"),
    INVALID_CONST_EXPR("NR009"),
    INVALID_CONSTRUCT_PATH_EXPR_INPUT("NR010"),
    INVALID_CASE_EXPR_WHEN_INPUT("NR011"),
    INVALID_EXPRESSION_TYPE("NR012"),
    INVALID_CONSTRUCT_LIST_EXPR_INPUT("NR013"),
    INVALID_CASE_EXPR_THEN_INPUT("NR014"),
    INVALID_CONSTRUCT_RECORD_EXPR_INPUT("NR015"),
    EXCEED_MAX_STRING_BYTES("NR016"),
    EXCEED_MAX_LIST_LENGTH("NR017"),
    EXCEED_MAX_DECIMAL_DIGITS("NR018"),
    INVALID_DECIMAL_INPUT("NR019"),
    DECIMAL_OUT_OF_RANGE("NR020"),
    FLOAT_OUT_OF_RANGE("NR021"),
    INVALID_DATA_TYPE_INPUT("NR022"),
    INVALID_LAMBDA_EXPRESSION("NR023"),
    INVALID_DECIMAL_TYPE("NR024"),
    INVALID_ELEMENT_ID("NR025"),
    EXCEED_MAX_SET_LENGTH("NR026"),
    ELEMENT_ID_NOT_EXIST("NR027"),
    EXCEED_MAX_MAP_LENGTH("NR028"),
    INVALID_SPATIAL_CAST("NR029"),
    DDL_FAILED("NR100"),
    DROP_REFERENCED_SCHEMA("NR101"),
    DROP_REFERENCED_GRAPH_TYPE("NR102"),
    INVALID_SCHEMA_PATH("NR103"),
    INVALID_PLUGIN_TYPE("NR104"),
    PRESERVED_SCHEMA_PATH("NR105"),
    PROPERTY_TYPE_CONSTRAINT_VIOLATION("NR111"),
    ELEMENT_TYPE_NAME_CONSTRAINT_VIOLATION("NR112"),
    MODIFY_PROPERTY_TYPE_FAILED("NR113"),
    TEMP_GRAPH_ALREADY_EXIST("NR122"),
    TEMP_GRAPH_NOT_FOUND("NR123"),
    TEMP_GRAPH_BUILD_FAILED("NR124"),
    TEMP_GRAPH_INVALID_DATA_SOURCE("NR125"),
    TEMP_GRAPH_DROP_FAILED("NR126"),
    TEMP_GRAPH_CREATE_FAILED("NR127"),
    TEMP_GRAPH_DEADLOCK("NR128"),
    TEMP_GRAPH_IMPORT_FAILED("NR129"),
    TEMP_GRAPH_NOT_IMPORTED("NR150"),
    TEMP_GRAPH_INDEX_NOT_FOUND("NR151"),
    TEMP_GRAPH_LOCK_TIMEOUT("NR152"),
    CREATE_PLUGIN_FAILED("NR131"),
    DROP_PLUGIN_FAILED("NR132"),
    CREATE_FUNCTION_FAILED("NR141"),
    DROP_FUNCTION_FAILED("NR142"),
    GET_NODE_ID_FAILED("NR201"),
    SRC_NODE_NOT_EXISTED("NR202"),
    DST_NODE_NOT_EXISTED("NR203"),
    DML_NUM_OF_PROPERTY_NOT_MATCH("NR204"),
    PRIMARY_KEY_CONSTRAINT_VIOLATION("NR205"),
    MULTIEDGE_KEY_CONSTRAINT_VIOLATION("NR206"),
    NODE_IS_MISSING("NR207"),
    GET_NODE_ID_FROM_PRIMARY_KEY_FAILED("NR208"),
    INSERT_INFER_MORE_THAN_ONE_TYPE("NR209"),
    ENDPOINT_NODE_TYPES_MISMATCH("NR210"),
    INSERT_PROPERTY_NOT_FOUND("NR211"),
    ELEMENT_NOT_IN_CURRENT_GRAPH("NR212"),
    MULTI_GET_NODE_ID_FROM_PRIMARY_KEY_FAILED("NR213"),
    ANN_INDEX_MEMORY_QUOTA_EXCEEDED("NR214"),
    SET_INVALID_TYPE("NR231"),
    INVALID_DELETE_TYPE("NR251"),
    MEMORY_EXCEEDED("NR301"),
    QUERY_CANCELED("NR302"),
    BAD_PLAN_NODE_TYPE("NR303"),
    SPLIT_PLAN_TO_STORAGE_FAILED("NR304"),
    KILL_QUERY_FAILED("NR401"),
    KILL_SESSION_FAILED("NR402"),
    QUERY_ID_NOT_FOUND("NR403"),
    SESSION_NOT_FOUND("NR405"),
    SESSION_IS_BUSY("NR406"),
    ALTER_PASSWORD_FAILED("NR407"),
    ALTER_USER_FAILED("NR408"),
    INTERPRETER_ERROR("NR502"),
    VECTOR_DIMENSION_MISSMATCHED("TW501"),
    UNSUPPORTED_VECTOR_METRIC_TYPE("TW502"),
    UNSUPPORTED_VECTOR_DISTANCE_TYPE("TW503"),
    ANN_INDEX_CREATE_FAILED("TW504"),
    ANN_INDEX_BUILD_FAILED("TW505"),
    ANN_INDEX_ALREADY_EXIST("TW506"),
    ANN_INDEX_NOT_FOUND("TW507"),
    ANN_INDEX_ADD_FAILED("TW508"),
    ANN_INDEX_SEARCH_FAILED("TW509"),
    ANN_INDEX_WRITE_FAILED("TW510"),
    ANN_INDEX_READ_FAILED("TW511"),
    ANN_INDEX_REMOVE_FAILED("TW512"),
    ANN_INDEX_MANAGER_ADD_FAILED("TW513"),
    ANN_INDEX_MANAGER_REMOVE_FAILED("TW514"),
    ANN_INDEX_RECONSTRUCT_FAILED("TW515"),
    ANN_WAL_WRITE_FAILED("TW516"),
    ANN_WAL_READ_FAILED("TW517"),
    ANN_WAL_FLUSH_FAILED("TW518"),
    ANN_WAL_FSYNC_FAILED("TW519"),
    ANN_INDEX_MANAGER_NOT_READY("TW520"),
    ANN_INDEX_MANAGER_CREATE_CHECKPOINT_FAILED("TW521"),
    SEMANTIC_ERROR("NS000"),
    UNDEFINED_VARIABLE("NS001"),
    DUPLICATE_DEFINE_VARIABLE("NS002"),
    UNDEFINED_PARAMETER("NS003"),
    SEMANTIC_LINEAR_QUERY_COLUMN_SIZE_MISMATCH("NS004"),
    SEMANTIC_FILTER_CLAUSE_MUST_BE_BOOL_TYPE("NS005"),
    SEMANTIC_INVALID_EXPRESSION_TYPE("NS006"),
    SEMANTIC_LINEAR_QUERY_COLUMN_NAME_MISMATCH("NS007"),
    SEMANTIC_INCONSISTENT_GROUP_VARIABLE_DEFINITION("NS008"),
    SEMANTIC_GROUP_VARIABLE_REDEFINITION("NS009"),
    SEMANTIC_LINEAR_QUERY_COLUMN_TYPE_INCOMPATIBLE("NS010"),
    SEMANTIC_CONFLICT_GRAPHS("NS011"),
    SEMANTIC_ALTER_SCHEMA_OR_GRAPH("NS012"),
    SEMANTIC_NODE_PRIMARY_KEY_PROPERTY_NUM_MISMATCH("NS101"),
    SEMANTIC_NODE_PRIMARY_KEY_PROPERTY_NOT_FOUND("NS102"),
    SEMANTIC_GRAPH_PATTERN_QUANTIFIER_EXCEED_LOW_BOUND("NS103"),
    SEMANTIC_GRAPH_PATTERN_QUANTIFIER_LOW_BOUND_EXCEED_UP_BOUND("NS104"),
    SEMANTIC_INVALID_EDGE_PATTERN("NS105"),
    SEMANTIC_RETURN_ALL_WITH_GROUPBY("NS106"),
    SEMANTIC_RETURN_ALL_WITH_NO_VARS_IN_SCOPE("NS107"),
    SEMANTIC_RETURN_DUPLICATE_COLUMN("NS109"),
    SEMANTIC_INVALID_EDGE_PREDICATE("NS110"),
    PATTERN_NOT_SUPPORTED("NS111"),
    SEMANTIC_NESTED_QUANTIFIED_PATH_PATTERN("NS112"),
    SEMANTIC_NESTED_QUESTIONED_PATH_PATTERN("NS113"),
    SEMANTIC_EXPORT_EMPTY_ITEMS("NS114"),
    SEMANTIC_EXPORT_DUPLICATE_COLUMN("NS115"),
    SEMANTIC_NO_AGG_FOUND_WITH_GROUPBY("NS202"),
    SEMANTIC_GROUPBY_NO_BINDING("NS203"),
    SEMANTIC_GROUPBY_CONTAIN_AGG_EXPR("NS204"),
    SEMANTIC_GROUPBY_MISMATCH("NS205"),
    SEMANTIC_IMPLICIT_AGG_IN_RETURN("NS206"),
    SEMANTIC_VAR_PROP_SETITEM_ERROR("NS207"),
    SEMANTIC_ASSIGN_EXPR_TYPE_ERROR("NS208"),
    SEMANTIC_CURRENT_WORKING_GRAPH_NOT_FOUND("NS209"),
    INVALID_LABEL_EXPR_INPUT("NS210"),
    INVALID_TYPE_EXPR_INPUT("NS211"),
    INVALID_OFFSET_EXPR_TYPE("NS212"),
    INVALID_LIMIT_EXPR_TYPE("NS213"),
    INVALID_NUM_OF_PATHS_EXPR_TYPE("NS214"),
    INVALID_NUM_OF_GROUPS_EXPR_TYPE("NS215"),
    SEMANTIC_RETURN_COLUMN_CONFLICT("NS216"),
    SEMANTIC_IF_STATEMENT_BRANCH_MISMATCH("NS217"),
    SEMANTIC_INVALID_VALUE_QUERY_EXPRESSION("NS218"),
    SEMANTIC_UNBOUNDED_QUANTIFIER_IN_NON_RESTRICTIVE_NON_SELECTIVE_PATH_PATTERN("NS219"),
    SEMANTIC_REPEATED_EDGE_VARIABLE_IN_TRAIL_PATH_MODE("NS221"),
    SEMANTIC_REPEATED_NODE_VARIABLE_IN_ACYCLIC_PATH_MODE("NS222"),
    SEMANTIC_REPEATED_NODE_VARIABLE_IN_SIMPLE_PATH_MODE("NS223"),
    SEMANTIC_REPEATED_EDGE_VARIABLE_IN_DIFFERENT_EDGES_MATCH_MODE("NS224"),
    SEMANTIC_SINGLE_SELECTIVE_PATTERN_IN_DIFFERENT_EDGES_MATCH_MODE("NS225"),
    SEMANTIC_VECTOR_DIM_MISMATCH("NS226"),
    SEMANTIC_ILLEGAL_VECTOR_DISTANCE_FUNC_ARGS("NS227"),
    INVALID_LABEL_EXPR("NS228"),
    INVALID_TYPE_EXPR("NS229"),
    INVALID_PROPERTY_EXPR("NS230"),
    INVALID_VARIABLE_ACCESS("NS231"),
    INVALID_AGGREGATOR_OPERATION("NS232"),
    INVALID_AGGREGATOR_DEFINITION("NS233"),
    INVALID_ANN_INDEX_BUILD_OPTION("NS234"),
    INVALID_SAMPLE("NS235"),
    INVALID_BINDING_TABLE_VARIABLE_DEFINITION("NS236"),
    INVALID_MEMBER_FUNCTION("NS237"),
    INVALID_COMPUTE_BLOCK("NS238"),
    INVALID_GRAPH_PATTERN("NS239"),
    SET_PROPERTY_NOT_EXIST("NS240"),
    ONLY_DQL_ALLOWED_IN_SUBQUERY("NS241"),
    INVALID_VARIABLE_DEFINITION("NS242"),
    SEMANTIC_APPEND_COLUMN_MISMATCH("NS243"),
    INVALID_SET_VARIABLE_STATEMENT("NS244"),
    SEMANTIC_EXPORT_COLUMN_MISMATCH("NS245"),
    NON_FINAL_STMT_MUST_NOT_END_WITH_RETURN("NS246"),
    WHILE_BODY_STMT_MUST_NOT_END_WITH_RETURN("NS247"),
    INVALID_ORDERBY_FACTOR("NS248"),
    PLAN_GENERATE_FAILED("NZ001"),
    UNSUPPORTED("NT000"),
    UNSUPPORTED_INDEX_PROPERTY_TYPE("NT001"),
    UNSUPPORTED_NODE_TYPE_WITHOUT_PRIMARY_KEY("NT002"),
    UNSUPPORTED_GRAPH_TYPE_SOURCE("NT003"),
    UNSUPPORTED_EDGE_DIRECTION("NT004"),
    UNSUPPORTED_PRIMARY_KEY("NT005"),
    UNSUPPORTED_MODIFY_PRIMARY_KEY("NT006"),
    UNSUPPORTED_MODIFY_MULTIEDGE_KEY("NT007"),
    UNSUPPORTED_MODIFY_PROPERTY_USED_BY_INDEX("NT008"),
    UNSUPPORTED_MODIFY_PROPERTY_NULLABLE_TO_NON_NULLABLE("NT009"),
    UNSUPPORTED_DEFINE_DEFAULT_VALUE_ON_PRIMARY_KEY("NT010"),
    UNSUPPORTED_DEFINE_DEFAULT_VALUE_ON_MULTIEDGE_KEY("NT011"),
    UNSUPPORTED_NULLABLE_PRIMARY_KEY("NT012"),
    UNSUPPORTED_NULLABLE_MULTIEDGE_KEY("NT013"),
    UNSUPPORTED_MULTIEDGE_KEY("NT014"),
    UNSUPPORTED_RESERVED_PROPERTY_NAME("NT015"),
    UNSUPPORTED_RENAME_PROPERTY_USED_BY_VECTOR_INDEX("NT016"),
    UNSUPPORTED_MULTIPLE_DDL_STATEMENTS("NT017"),
    UNSUPPORTED_NONNULL_DEFAULT_VALUE_FOR_VECTOR_PROPERTY("NT018"),
    UNSUPPORTED_DATA_MODIFY_STATEMENT("NT103"),
    UNSUPPORTED_MULTIPLE_PATH_PATTERN("NT104"),
    UNSUPPORTED_UPDATE_PRIMARY_KEY("NT105"),
    UNSUPPORTED_SET_ALL_SET_LABEL("NT106"),
    UNSUPPORTED_UPDATE_MULTIEDGE_KEY("NT107"),
    UNSUPPORTED_AGGREGATION_EXPRESSION("NT201"),
    UNSUPPORTED_AGGREGATION_EXPRESSION_NESTED("NT202"),
    AGGREGATION_EXPRESSION_NOT_ALLOWED("NT203"),
    UNDEFINED_AGG_FUNCTION("NT204"),
    UNSUPPORTED_TRIM_NON_ASCII_CHAR("NT205"),
    UNSUPPORTED_TYPE_GET_PROP("NT206"),
    UNSUPPORTED_PATH_FACTOR("NT301"),
    UNSUPPORTED_MATCH_COMPUTE_GRAPH_PATTERN("NT302"),
    UNSUPPORTED_CHARSET("NT401"),
    UNSUPPORTED_COLLATION("NT402"),
    UNSUPPORTED_CHARSET_COLLATION_NOT_MATCH("NT403"),
    UNSUPPORTED_TEMP_GRAPH_OPERATION("NT501"),
    UNSUPPORTED_MUTABLE_TEMP_GRAPH_PROPERTY_TYPE("NT502"),
    UNSUPPORTED_EXECUTION_MODE("NT601"),
    SYSTEM_ERROR("TY000"),
    NO_VALIDATOR("TY001"),
    STATS_ERROR("TY002"),
    FILE_ERROR("TY101"),
    FILE_NOT_FOUND("TY102"),
    FILE_IS_EMPTY("TY103"),
    FILE_READ_PERMISSION("TY104"),
    FILE_READ_LINK("TY105"),
    FILE_READ_PATH("TY106"),
    FILE_OPEN_DIR("TY107"),
    FILE_OPEN_FAILED("TY108"),
    FILE_TYPE_NOT_SUPPORT("TY109"),
    FILE_FILE_STATE("TY110"),
    FILE_CREATE_DIR_FAILED("TY111"),
    FILE_READ_SERVICE_ID_FILE_ERROR("TY112"),
    FILE_PARSE_SERVICE_ID_FILE_ERROR("TY113"),
    FILE_SAVE_SERVICE_ID_FILE_ERROR("TY114"),
    FILE_REMOVE_DIR_FAILED("TY115"),
    FILE_REMOVE_FAILED("TY116"),
    FILE_CLOSE_FAILED("TY117"),
    MEMORY_ERROR("TY201"),
    MEMORY_STATIC_CONFIG_ERROR("TY202"),
    MEMORY_BACKGROUND_CHECK("TY203"),
    MEMORY_SYSTEM_INFO("TY204"),
    MEMORY_VECTOR_INVALID_SIZE("TY205"),
    MEMORY_DYNAMIC_CONFIG_ERROR("TY206"),
    NETWORK_ERROR("TY301"),
    NETWORK_CREATE_SOCKET("TY302"),
    NETWORK_UNKNOWN_ADDR("TY303"),
    NETWORK_BIND_FAILED("TY304"),
    NETWORK_LISTEN_FAILED("TY305"),
    NETWORK_NBIO_STOPPED("TY306"),
    NETWORK_CONN_CLOSED("TY307"),
    NETWORK_PROTOCOL("TY308"),
    NETWORK_TIMEOUT("TY309"),
    NETWORK_DISCONNECTED("TY310"),
    NETWORK_ADDR_NOT_FOUND("TY311"),
    NETWORK_INVALID_HOST("TY312"),
    NETWORK_TLS_ERROR("TY313"),
    READ_METRIC_FAILED("TY401"),
    INVALID_METRIC_FORMAT("TY403"),
    THREAD_ERROR("TY501"),
    THREAD_CREATE_FAILED("TY502"),
    SYS_GRAPH_ERROR("TY601"),
    HTTP_INVALID_AUTH_TOKEN("NX001"),
    HTTP_BAD_REQUEST("NX002"),
    HTTP_REQUEST_TIMEOUT("NX003"),
    HTTP_SERVER_INTERNAL_ERROR("NX100"),
    PARSE_OPENAPI_SPEC_FAILED("NX101"),
    PARSE_GQL_TPL_FAILED("NX102"),
    HTTP_RESP_PAYLOAD_TOO_LARGE_ERROR("NX103"),
    LICENSE_ENCRYPTION_ERROR("NL001"),
    LICENSE_MANAGER_ERROR("NL101"),
    LICENSE_MANAGER_NETWORK_ERROR("NL102"),
    LICENSE_QUOTA_EXCEEDED("NL201"),
    LICENSE_EXPIRED("NL202"),
    LICENSE_INVALID("NL203"),
    LOAD_LM_RESP_FROM_KV_FAILED("NL301"),
    JOB_ERROR("NJ000"),
    JOB_TYPE_UNKNOWN("NJ001"),
    JOB_NOT_FOUND("NJ002"),
    JOB_TASK_NOT_FOUND("NJ003"),
    JOB_IS_NOT_RUNNING("NJ004"),
    JOB_DESCRIPTION_INVALID("NJ005"),
    JOB_ALREADY_STOPPED("NJ006"),
    JOB_MANAGER_NOT_RUNNING("NJ007"),
    JOB_TASK_NOT_ACTIVE("NJ008"),
    JOB_NO_STATS_FOR_GRAPH("NJ009"),
    JOB_HAS_NO_TASKS("NJ010"),
    TASK_NOT_FOUND_IN_STORAGE("NJ011"),
    TASK_STOPPED("NJ012"),
    TASK_STILL_RUNNING("NJ013"),
    TASK_REPORT_FAILED("NJ014"),
    BACKUP_ERROR("NF000"),
    BACKUP_RECORD_EXISTS("NF001"),
    BACKUP_RUNNING_JOBS("NF002"),
    BACKUP_META_TABLE_EMPTY("NF003"),
    BACKUP_LOST_PART("NF004"),
    BACKUP_DUPLICATE_PART("NF005"),
    BACKUP_RESTORE_INVALID_REQUEST("NF006"),
    BACKUP_REMAP_PART_FAILED("NF007"),
    BACKUP_RESTORE_TABLE_FAILED("NF008"),
    BACKUP_DROP_NAME_EMPTY("NF009"),
    BACKUP_DROP_NAME_NOT_EXIST("NF010"),
    BACKUP_WAL_HAS_GAP("NF011"),
    BACKUP_WAL_IS_BROKEN("NF012"),
    BACKUP_WAL_NOT_FOUND("NF013"),
    REPLAY_WAL_FAILED("NF014"),
    UNKNOWN("NU000"),
    UNKNOWN_FOR_CLIENT(null);

    public String code;
    private static Map<String, ErrorCode> errorCodeMap;

    private ErrorCode(String c) {
        this.code = c;
    }

    public static ErrorCode find(String code) {
        if (errorCodeMap.containsKey(code)) {
            return errorCodeMap.get(code);
        }
        ErrorCode.UNKNOWN_FOR_CLIENT.code = code;
        return UNKNOWN_FOR_CLIENT;
    }

    public boolean isRetryable() {
        return this.isSessionError() || this.isRpcError() || this.isRaftError();
    }

    public boolean isSemanticError() {
        return this.code.startsWith("NS");
    }

    public boolean isSyntaxError() {
        return this.code.startsWith("42");
    }

    public boolean isSessionError() {
        return this.code.startsWith("NE");
    }

    public boolean isRpcError() {
        return this.code.startsWith("TN");
    }

    public boolean isRaftError() {
        return this.code.startsWith("TA");
    }

    public boolean isNoDataError() {
        return this.code.startsWith("02");
    }

    static {
        errorCodeMap = new HashMap<String, ErrorCode>();
        for (ErrorCode value : ErrorCode.values()) {
            errorCodeMap.put(value.code, value);
        }
    }
}

