/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.data;

import com.vesoft.nebula.driver.graph.data.BaseDataObject;
import com.vesoft.nebula.driver.graph.data.ValueWrapper;
import com.vesoft.nebula.driver.graph.decode.struct.ResultGraphSchemas;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Node
extends BaseDataObject {
    private final int graphId;
    private final String graphName;
    private final int nodeTypeId;
    private final String nodeTypeName;
    private final List<String> labels;
    private final long nodeId;
    private final Map<String, ValueWrapper> properties;

    public Node(int graphId, int nodeTypeId, long nodeId, Map<String, ValueWrapper> properties, ResultGraphSchemas graphSchemas) {
        this.graphId = graphId;
        this.graphName = graphSchemas.getGraphSchema(graphId).getGraphName();
        this.nodeTypeId = nodeTypeId;
        this.nodeTypeName = graphSchemas.getGraphSchema(graphId).getNodeSchema(nodeTypeId).getNodeTypeName();
        this.labels = graphSchemas.getGraphSchema(graphId).getNodeSchema(nodeTypeId).getNodeLabels();
        this.nodeId = nodeId;
        this.properties = properties;
    }

    public String getGraph() {
        return this.graphName;
    }

    public String getType() {
        return this.nodeTypeName;
    }

    public int getNodeTypeId() {
        return this.nodeTypeId;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public long getId() {
        return this.nodeId;
    }

    public List<String> getColumnNames() throws UnsupportedEncodingException {
        ArrayList<String> keys = new ArrayList<String>(this.properties.keySet());
        return keys;
    }

    public List<ValueWrapper> getValues() {
        ArrayList<ValueWrapper> values = new ArrayList<ValueWrapper>();
        for (Map.Entry<String, ValueWrapper> kv : this.properties.entrySet()) {
            values.add(kv.getValue());
        }
        return values;
    }

    public Map<String, ValueWrapper> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return this.getId() == node.getId();
    }

    public int hashCode() {
        return Objects.hash(this.graphId, this.nodeTypeId, this.nodeId, this.getDecodeType());
    }

    public String toString() {
        Map<String, ValueWrapper> props = this.getProperties();
        ArrayList<String> propStrs = new ArrayList<String>();
        for (String propName : props.keySet()) {
            propStrs.add(propName + ":" + props.get(propName).toString());
        }
        return String.format("(%d@%s:%s{%s})", this.getId(), this.getType(), String.join((CharSequence)"&", this.getLabels()), String.join((CharSequence)",", propStrs));
    }
}

