/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.data;

import com.vesoft.nebula.driver.graph.utils.ZoneOffsetUtil;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Objects;

public class NZonedTime {
    private final int hour;
    private final int minute;
    private final int second;
    private final int microSec;
    private final ZoneOffset timeZoneOffset;

    public NZonedTime(int hour, int minute, int second, int microSec, ZoneOffset timeZoneOffset) {
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.microSec = microSec;
        this.timeZoneOffset = timeZoneOffset;
    }

    public NZonedTime(LocalTime localTime, ZoneOffset timeZoneOffset) {
        this.hour = localTime.getHour();
        this.minute = localTime.getMinute();
        this.second = localTime.getSecond();
        this.microSec = localTime.getNano() / 1000;
        this.timeZoneOffset = timeZoneOffset;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getMicrosec() {
        return this.microSec;
    }

    public int getOffset() {
        return this.timeZoneOffset.getTotalSeconds();
    }

    public String toString() {
        return String.format("%02d:%02d:%02d.%06d%s", this.hour, this.minute, this.second, this.microSec, ZoneOffsetUtil.buildOffset(this.getOffset()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NZonedTime that = (NZonedTime)o;
        return this.hour == that.getHour() && this.minute == that.getMinute() && this.second == that.getSecond() && this.microSec == that.getMicrosec() && this.getOffset() == that.getOffset();
    }

    public int hashCode() {
        return Objects.hash(this.hour, this.minute, this.second, this.microSec, this.getOffset());
    }
}

