/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.scan;

import com.vesoft.nebula.driver.graph.data.HostAddress;
import com.vesoft.nebula.driver.graph.data.ResultSet;
import com.vesoft.nebula.driver.graph.scan.ScanEdgeResult;
import com.vesoft.nebula.driver.graph.scan.ScanNodeResultIterator;
import com.vesoft.nebula.driver.graph.scan.ScanResultIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanEdgeResultIterator
extends ScanResultIterator {
    private static final Logger logger = LoggerFactory.getLogger(ScanNodeResultIterator.class);
    private static final String SCAN_EDGE_TEMPLATE = "USE %s CALL cursor_edge_scan(\"%s\",\"%s\",%s,%d,\"%s\", %d) return *";

    public ScanEdgeResultIterator(String graphName, String label, List<String> propNames, List<Integer> parts, int batchSize, int parallel, List<HostAddress> servers, String userName, Map<String, Object> authOptions, long requestTimeoutMs) {
        super(graphName, label, propNames, parts, batchSize, parallel, servers, userName, authOptions, requestTimeoutMs);
    }

    public ScanEdgeResult next() {
        if (!this.hasNext) {
            throw new NoSuchElementException("iterator has no more data");
        }
        List<ResultSet> results = Collections.synchronizedList(new ArrayList(this.partCursor.size()));
        List<Exception> exceptions = Collections.synchronizedList(new ArrayList(this.partCursor.size()));
        CountDownLatch countDownLatch = new CountDownLatch(this.partCursor.size());
        for (Map.Entry partCur : this.partCursor.entrySet()) {
            this.threadPool.submit(() -> {
                try {
                    ResultSet result = this.scan(SCAN_EDGE_TEMPLATE, partCur);
                    if (result.isSucceeded()) {
                        String cursor = this.getCursor(result);
                        this.partCursor.put(partCur.getKey(), cursor);
                        results.add(result);
                    } else {
                        logger.error(String.format("Scan part %d of edge %s failed for %s, scan again in the next next()", partCur.getKey(), this.labelName, result.getErrorMessage()));
                        exceptions.add(new Exception(String.format("part %d of %s scan error: %s", partCur.getKey(), this.labelName, result.getErrorMessage())));
                    }
                }
                catch (Exception e) {
                    logger.error(String.format("Scan node error for %s", e.getMessage()), (Throwable)e);
                    exceptions.add(new Exception(String.format("part %d of %s scan failed: %s", partCur.getKey(), this.labelName, e.getMessage()), e));
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            logger.error("scan interrupted:", (Throwable)interruptedException);
            throw new RuntimeException("scan interrupted", interruptedException);
        }
        if (!exceptions.isEmpty()) {
            ArrayList<String> exceptionMsg = new ArrayList<String>();
            for (Exception exception : exceptions) {
                exceptionMsg.add(exception.getMessage());
            }
            throw new RuntimeException("scan node failed for current iterator: " + exceptionMsg);
        }
        this.hasNext = false;
        ArrayList partKeyNeedToRemove = new ArrayList();
        for (Map.Entry entry : this.partCursor.entrySet()) {
            if (!"".equals(entry.getValue())) {
                this.hasNext = true;
                break;
            }
            partKeyNeedToRemove.add(entry.getKey());
        }
        for (Integer n : partKeyNeedToRemove) {
            this.partCursor.remove(n);
        }
        if (!this.hasNext && !this.threadPool.isShutdown()) {
            this.threadPool.shutdown();
        }
        return new ScanEdgeResult(results, this.propNames);
    }
}

