/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.data;

import com.vesoft.nebula.proto.common.Duration;
import java.util.Objects;

public class NDuration {
    private final Duration duration;

    public NDuration(Duration duration) {
        this.duration = duration;
    }

    public boolean isMonthBased() {
        return this.duration.getIsMonthBased();
    }

    public int getYear() {
        return this.duration.getYear();
    }

    public int getMonth() {
        return this.duration.getMonth();
    }

    public int getDay() {
        return this.duration.getDay();
    }

    public int getHour() {
        return this.duration.getHour();
    }

    public int getMinute() {
        return this.duration.getMinute();
    }

    public int getSecond() {
        return this.duration.getSec();
    }

    public int getMicrosecond() {
        return this.duration.getMicrosec();
    }

    public String toString() {
        StringBuilder durationStr = new StringBuilder();
        durationStr.append("P");
        if (this.isMonthBased()) {
            if (this.getYear() != 0) {
                durationStr.append(this.getYear()).append("Y");
            }
            if (this.getMonth() != 0) {
                durationStr.append(this.getMonth()).append("M");
            }
        } else {
            if (this.getDay() != 0) {
                durationStr.append(this.getDay()).append("D");
            }
            if (this.getHour() != 0 || this.getMinute() != 0 || this.getSecond() != 0 || this.getMicrosecond() != 0) {
                durationStr.append("T");
            }
            if (this.getHour() != 0) {
                durationStr.append(this.getHour()).append("H");
            }
            if (this.getMinute() != 0) {
                durationStr.append(this.getMinute()).append("M");
            }
            if (this.getSecond() != 0 || this.getMicrosecond() != 0) {
                if (this.getMicrosecond() == 0) {
                    durationStr.append(this.getSecond()).append("S");
                } else {
                    boolean isMinus;
                    int totalMicroseconds = this.getSecond() * 1000000 + this.getMicrosecond();
                    boolean bl = isMinus = totalMicroseconds < 0;
                    if (isMinus) {
                        totalMicroseconds = -totalMicroseconds;
                    }
                    int seconds = totalMicroseconds / 1000000;
                    int microSec = totalMicroseconds % 1000000;
                    if (isMinus) {
                        durationStr.append(String.format("-%d.%06d", seconds, microSec));
                    } else {
                        durationStr.append(String.format("%d.%06d", seconds, microSec));
                    }
                    while (durationStr.charAt(durationStr.length() - 1) == '0') {
                        durationStr.setLength(durationStr.length() - 1);
                    }
                    durationStr.append("S");
                }
            }
        }
        return durationStr.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NDuration that = (NDuration)o;
        return this.duration.getIsMonthBased() == that.isMonthBased() && this.duration.getYear() == that.getYear() && this.duration.getMonth() == that.getMonth() && this.duration.getDay() == that.getDay() && this.duration.getHour() == that.getHour() && this.duration.getMinute() == that.getMinute() && this.duration.getSec() == that.getSecond() && this.duration.getMicrosec() == that.getMicrosecond();
    }

    public int hashCode() {
        return Objects.hash(this.duration);
    }
}

