/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.scan;

import com.vesoft.nebula.client.graph.data.Relationship;
import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import com.vesoft.nebula.client.graph.data.Vertex;
import com.vesoft.nebula.client.graph.scan.ScanResult;
import com.vesoft.nebula.client.graph.scan.TableRow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ScanEdgeResult
extends ScanResult {
    private List<String> propNames = new ArrayList<String>();
    private List<String> returnColumns = new ArrayList<String>();

    public ScanEdgeResult(List<ResultSet> results, List<String> propNames) {
        super(results);
        this.propNames = propNames;
        this.returnColumns.add("src");
        this.returnColumns.add("dst");
        this.returnColumns.addAll(propNames);
    }

    public List<String> getPropNames() {
        return this.returnColumns;
    }

    @Override
    protected void convertResultToRow() {
        if (this.isEmpty) {
            return;
        }
        if (this.tableRows.isEmpty()) {
            for (ResultSet resultSet : this.results) {
                while (resultSet.hasNext()) {
                    ResultSet.Record record = resultSet.next();
                    ArrayList<ValueWrapper> rowValues = new ArrayList<ValueWrapper>();
                    Vertex srcNode = record.get("Src").asNode();
                    Vertex dstNode = record.get("Dst").asNode();
                    Relationship edge = record.get("Edge").asEdge();
                    for (String key : srcNode.getProperties().keySet()) {
                        rowValues.add(srcNode.getProperties().get(key));
                    }
                    for (String key : dstNode.getProperties().keySet()) {
                        rowValues.add(dstNode.getProperties().get(key));
                    }
                    HashMap<String, ValueWrapper> properties = edge.getProperties();
                    for (String propName : this.propNames) {
                        rowValues.add((ValueWrapper)properties.get(propName));
                    }
                    this.tableRows.add(new TableRow(rowValues));
                }
            }
        }
    }
}

