/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.data;

import com.google.common.base.Charsets;
import com.vesoft.nebula.client.graph.data.NDate;
import com.vesoft.nebula.client.graph.data.NDateTime;
import com.vesoft.nebula.client.graph.data.NDuration;
import com.vesoft.nebula.client.graph.data.NPath;
import com.vesoft.nebula.client.graph.data.NRecord;
import com.vesoft.nebula.client.graph.data.NTime;
import com.vesoft.nebula.client.graph.data.NZonedDateTime;
import com.vesoft.nebula.client.graph.data.NZonedTime;
import com.vesoft.nebula.client.graph.data.Relationship;
import com.vesoft.nebula.client.graph.data.Vertex;
import com.vesoft.nebula.client.graph.exception.InvalidValueException;
import com.vesoft.nebula.proto.common.Value;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;

public class ValueWrapper {
    private final Value value;
    private final Charset charset = Charsets.UTF_8;

    public String getDataType() {
        if (this.value.getDataCase() == Value.DataCase.DATA_NOT_SET) {
            return "DATA_NOT_SET";
        }
        if (this.value.getDataCase() == Value.DataCase.BOOL_VALUE) {
            return "BOOLEAN";
        }
        if (this.value.getDataCase() == Value.DataCase.INT8_VALUE || this.value.getDataCase() == Value.DataCase.UINT8_VALUE) {
            return "BYTE";
        }
        if (this.value.getDataCase() == Value.DataCase.INT16_VALUE || this.value.getDataCase() == Value.DataCase.UINT16_VALUE) {
            return "SHORT";
        }
        if (this.value.getDataCase() == Value.DataCase.INT32_VALUE || this.value.getDataCase() == Value.DataCase.UINT32_VALUE) {
            return "INT";
        }
        if (this.value.getDataCase() == Value.DataCase.INT64_VALUE || this.value.getDataCase() == Value.DataCase.UINT64_VALUE) {
            return "LONG";
        }
        if (this.value.getDataCase() == Value.DataCase.FLOAT_VALUE) {
            return "FLOAT";
        }
        if (this.value.getDataCase() == Value.DataCase.DOUBLE_VALUE) {
            return "DOUBLE";
        }
        if (this.value.getDataCase() == Value.DataCase.STRING_VALUE) {
            return "STRING";
        }
        if (this.value.getDataCase() == Value.DataCase.NODE_VALUE) {
            return "NODE";
        }
        if (this.value.getDataCase() == Value.DataCase.EDGE_VALUE) {
            return "EDGE";
        }
        if (this.value.getDataCase() == Value.DataCase.LIST_VALUE) {
            return "LIST";
        }
        if (this.value.getDataCase() == Value.DataCase.DURATION_VALUE) {
            return "DURATION";
        }
        if (this.value.getDataCase() == Value.DataCase.LOCAL_TIME_VALUE) {
            return "LOCAL_TIME";
        }
        if (this.value.getDataCase() == Value.DataCase.LOCAL_DATETIME_VALUE) {
            return "LOCAL_DATETIME";
        }
        if (this.value.getDataCase() == Value.DataCase.ZONED_TIME_VALUE) {
            return "ZONED_TIME";
        }
        if (this.value.getDataCase() == Value.DataCase.ZONED_DATETIME_VALUE) {
            return "ZONED_DATETIME";
        }
        if (this.value.getDataCase() == Value.DataCase.DATE_VALUE) {
            return "DATE";
        }
        if (this.value.getDataCase() == Value.DataCase.RECORD_VALUE) {
            return "RECORD";
        }
        if (this.value.getDataCase() == Value.DataCase.PATH_VALUE) {
            return "PATH";
        }
        if (this.value.getDataCase() == Value.DataCase.DECIMAL_VALUE) {
            return "DECIMAL";
        }
        if (this.value.getDataCase() == Value.DataCase.VECTOR_VALUE) {
            return "VECTOR";
        }
        throw new IllegalArgumentException("Unknown field id " + this.value.getDataCase());
    }

    public ValueWrapper(Value value) {
        this.value = value;
    }

    public Value getValue() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.value.getDataCase() == Value.DataCase.DATA_NOT_SET;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isBoolean() {
        return this.value.getDataCase() == Value.DataCase.BOOL_VALUE;
    }

    public boolean isLong() {
        return this.value.getDataCase() == Value.DataCase.INT64_VALUE || this.value.getDataCase() == Value.DataCase.UINT64_VALUE;
    }

    public boolean isInt() {
        return this.value.getDataCase() == Value.DataCase.INT32_VALUE || this.value.getDataCase() == Value.DataCase.UINT32_VALUE || this.value.getDataCase() == Value.DataCase.INT16_VALUE || this.value.getDataCase() == Value.DataCase.UINT16_VALUE || this.value.getDataCase() == Value.DataCase.INT8_VALUE || this.value.getDataCase() == Value.DataCase.UINT8_VALUE;
    }

    public boolean isFloat() {
        return this.value.getDataCase() == Value.DataCase.FLOAT_VALUE;
    }

    public boolean isDouble() {
        return this.value.getDataCase() == Value.DataCase.DOUBLE_VALUE;
    }

    public boolean isString() {
        return this.value.getDataCase() == Value.DataCase.STRING_VALUE;
    }

    public boolean isList() {
        return this.value.getDataCase() == Value.DataCase.LIST_VALUE;
    }

    public boolean isNode() {
        return this.value.getDataCase() == Value.DataCase.NODE_VALUE;
    }

    public boolean isEdge() {
        return this.value.getDataCase() == Value.DataCase.EDGE_VALUE;
    }

    public boolean isLocalTime() {
        return this.value.getDataCase() == Value.DataCase.LOCAL_TIME_VALUE;
    }

    public boolean isZonedTime() {
        return this.value.getDataCase() == Value.DataCase.ZONED_TIME_VALUE;
    }

    public boolean isLocalDateTime() {
        return this.value.getDataCase() == Value.DataCase.LOCAL_DATETIME_VALUE;
    }

    public boolean isZonedDateTime() {
        return this.value.getDataCase() == Value.DataCase.ZONED_DATETIME_VALUE;
    }

    public boolean isDate() {
        return this.value.getDataCase() == Value.DataCase.DATE_VALUE;
    }

    public boolean isRecord() {
        return this.value.getDataCase() == Value.DataCase.RECORD_VALUE;
    }

    public boolean isDuration() {
        return this.value.getDataCase() == Value.DataCase.DURATION_VALUE;
    }

    public boolean isPath() {
        return this.value.getDataCase() == Value.DataCase.PATH_VALUE;
    }

    public boolean isDecimal() {
        return this.value.getDataCase() == Value.DataCase.DECIMAL_VALUE;
    }

    public boolean isVector() {
        return this.value.getDataCase() == Value.DataCase.RECORD_VALUE;
    }

    public boolean asBoolean() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.BOOL_VALUE) {
            return this.value.getBoolValue();
        }
        throw new InvalidValueException("Cannot get field `boolean` because value's type is " + this.getDataType());
    }

    public int asInt() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.INT8_VALUE) {
            return this.value.getInt8Value();
        }
        if (this.value.getDataCase() == Value.DataCase.INT16_VALUE) {
            return this.value.getInt16Value();
        }
        if (this.value.getDataCase() == Value.DataCase.INT32_VALUE) {
            return this.value.getInt32Value();
        }
        if (this.value.getDataCase() == Value.DataCase.UINT8_VALUE) {
            return this.value.getUint8Value();
        }
        if (this.value.getDataCase() == Value.DataCase.UINT16_VALUE) {
            return this.value.getUint16Value();
        }
        if (this.value.getDataCase() == Value.DataCase.UINT32_VALUE) {
            return this.value.getUint32Value();
        }
        throw new InvalidValueException("Cannot get field `int` because value's type is " + this.getDataType());
    }

    public long asLong() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.INT64_VALUE) {
            return this.value.getInt64Value();
        }
        if (this.value.getDataCase() == Value.DataCase.UINT64_VALUE) {
            return this.value.getUint64Value();
        }
        throw new InvalidValueException("Cannot get field `long` because value's type is " + this.getDataType());
    }

    public String asString() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.STRING_VALUE) {
            return this.value.getStringValue().toString(this.charset);
        }
        throw new InvalidValueException("Cannot get field `string` because value's type is " + this.getDataType());
    }

    public float asFloat() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.FLOAT_VALUE) {
            return this.value.getFloatValue();
        }
        throw new InvalidValueException("Cannot get field `float` because value's type is " + this.getDataType());
    }

    public double asDouble() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.DOUBLE_VALUE) {
            return this.value.getDoubleValue();
        }
        throw new InvalidValueException("Cannot get field `double` because value's type is " + this.getDataType());
    }

    public List<ValueWrapper> asList() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.LIST_VALUE) {
            ArrayList<ValueWrapper> values = new ArrayList<ValueWrapper>();
            for (Value value : this.value.getListValue().getValuesList()) {
                values.add(new ValueWrapper(value));
            }
            return values;
        }
        throw new InvalidValueException("Cannot get field `list` because value's type is " + this.getDataType());
    }

    public Vertex asNode() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.NODE_VALUE) {
            return new Vertex(this.value.getNodeValue());
        }
        throw new InvalidValueException("cannot get field `node` because value's type is " + this.getDataType());
    }

    public Relationship asEdge() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.EDGE_VALUE) {
            return new Relationship(this.value.getEdgeValue());
        }
        throw new InvalidValueException("cannot get field `edge` because value's type is " + this.getDataType());
    }

    public NTime asLocalTime() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.LOCAL_TIME_VALUE) {
            return new NTime(this.value.getLocalTimeValue());
        }
        throw new InvalidValueException("cannot get field `localtime` because value's type is " + this.getDataType());
    }

    public NZonedTime asZonedTime() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.ZONED_TIME_VALUE) {
            return new NZonedTime(this.value.getZonedTimeValue());
        }
        throw new InvalidValueException("cannot get field `zonedtime` because value's type is " + this.getDataType());
    }

    public NDate asDate() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.DATE_VALUE) {
            return new NDate(this.value.getDateValue());
        }
        throw new InvalidValueException("cannot get field `date` because value's type is " + this.getDataType());
    }

    public NDateTime asLocalDateTime() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.LOCAL_DATETIME_VALUE) {
            return new NDateTime(this.value.getLocalDatetimeValue());
        }
        throw new InvalidValueException("cannot get field `localdatetime` because value's type is " + this.getDataType());
    }

    public NZonedDateTime asZonedDateTime() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.ZONED_DATETIME_VALUE) {
            return new NZonedDateTime(this.value.getZonedDatetimeValue());
        }
        throw new InvalidValueException("cannot get field `zoneddatetime` because value's type is " + this.getDataType());
    }

    public NDuration asDuration() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.DURATION_VALUE) {
            return new NDuration(this.value.getDurationValue());
        }
        throw new InvalidValueException("cannot get field `duration` because value's type is " + this.getDataType());
    }

    public NRecord asRecord() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.RECORD_VALUE) {
            return new NRecord(this.value.getRecordValue());
        }
        throw new InvalidValueException("cannot get field `record` because value's type is " + this.getDataType());
    }

    public NPath asPath() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.PATH_VALUE) {
            return new NPath(this.value.getPathValue());
        }
        throw new InvalidValueException("cannot get field `path` because value's type is " + this.getDataType());
    }

    public BigDecimal asDecimal() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.DECIMAL_VALUE) {
            return new BigDecimal(this.value.getDecimalValue().getSval());
        }
        throw new InvalidValueException("cannot get field `decimal` because value's type is " + this.getDataType());
    }

    public Vector asVector() throws InvalidValueException {
        if (this.value.getDataCase() == Value.DataCase.VECTOR_VALUE) {
            return new Vector<Float>(this.value.getVectorValue().getValuesList());
        }
        throw new InvalidValueException("cannot get field `vector` because value's type is " + this.getDataType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueWrapper that = (ValueWrapper)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        if (this.isNull()) {
            return null;
        }
        if (this.isBoolean()) {
            return String.valueOf(this.asBoolean());
        }
        if (this.isInt()) {
            return String.valueOf(this.asInt());
        }
        if (this.isLong()) {
            return String.valueOf(this.asLong());
        }
        if (this.isFloat()) {
            return String.valueOf(this.asFloat());
        }
        if (this.isDouble()) {
            return String.valueOf(this.asDouble());
        }
        if (this.isString()) {
            return this.asString();
        }
        if (this.isList()) {
            return this.asList().toString();
        }
        if (this.isRecord()) {
            return this.asRecord().toString();
        }
        if (this.isNode()) {
            return this.asNode().toString();
        }
        if (this.isEdge()) {
            return this.asEdge().toString();
        }
        if (this.isLocalTime()) {
            return this.asLocalTime().toString();
        }
        if (this.isZonedTime()) {
            return this.asZonedTime().toString();
        }
        if (this.isLocalDateTime()) {
            return this.asLocalDateTime().toString();
        }
        if (this.isZonedDateTime()) {
            return this.asZonedDateTime().toString();
        }
        if (this.isDate()) {
            return this.asDate().toString();
        }
        if (this.isDuration()) {
            return this.asDuration().toString();
        }
        if (this.isPath()) {
            return this.asPath().toString();
        }
        if (this.isDecimal()) {
            return this.asDecimal().toString();
        }
        if (this.isRecord()) {
            return this.asRecord().toString();
        }
        return "Unknown type: " + this.getDataType();
    }
}

