/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph;

import java.util.HashMap;
import java.util.Map;

public enum ErrorCode {
    SUCCESSFUL_COMPLETION("00000"),
    OMITTED_RESULT("00001"),
    WARNING("01000"),
    WARNING_STRING_DATA_RIGHT_TRUNCATION("01004"),
    CATALOG_GRAPH_NOT_FOUND("01G03"),
    CATALOG_GRAPH_TYPE_NOT_FOUND("01G04"),
    NULL_VALUE_ELIMINATED_IN_SET_FUNCTION("01G11"),
    NO_DATA("02000"),
    INFORMATIONAL("03000"),
    CONNECTION_EXCEPTION("08000"),
    TRANSACTION_RESOLUTION_UNKNOWN("08007"),
    DATA_EXCEPTION("22000"),
    DATA_STRING_DATA_RIGHT_TRUNCATION("22001"),
    NUMERIC_VALUE_OUT_OF_RANGE("22003"),
    NULL_VALUE_NOT_ALLOWED("22004"),
    INVALID_DATE_TIME_OR_DATETIME_FORMAT("22007"),
    DATETIME_FIELD_OVERFLOW("22008"),
    PARSE_TEMPORAL_FAIL("22009"),
    SUBSTRING_ERROR("22011"),
    DIVISION_BY_ZERO("22012"),
    INTERVAL_FIELD_OVERFLOW("22015"),
    INVALID_CHARACTER_VALUE_FOR_CAST("22018"),
    INVALID_ARGUMENT_FOR_NATURAL_LOGARITHM("2201E"),
    INVALID_ARGUMENT_FOR_POWER_FUNCTION("2201F"),
    TRIM_ERROR("22027"),
    ARRAY_DATA_RIGHT_TRUNCATION("2202F"),
    NEGATIVE_LIMIT_VALUE("22G02"),
    INVALID_VALUE_TYPE("22G03"),
    VALUES_NOT_COMPARABLE("22G04"),
    INVALID_DATE_TIME_OR_DATETIME_FUNCTION_FIELD_NAME("22G05"),
    INVALID_DATETIME_FUNCTION_VALUE("22G06"),
    INVALID_DURATION_FUNCTION_FIELD_NAME("22G07"),
    LIST_DATA_RIGHT_TRUNCATION("22G0B"),
    LIST_ELEMENT_ERROR("22G0C"),
    INVALID_NUMBER_OF_PATHS_OR_GROUPS("22G0F"),
    INVALID_DURATION_FORMAT("22G0H"),
    MULTIPLE_ASSIGNMENTS_TO_A_GRAPH_ELEMENT_PROPERTY("22G0M"),
    DATA_NUMBER_OF_NODE_LABELS_BELOW_SUPPORTED_MINIMUM("22G0N"),
    DATA_NUMBER_OF_NODE_LABELS_EXCEEDS_SUPPORTED_MAXIMUM("22G0P"),
    DATA_NUMBER_OF_EDGE_LABELS_BELOW_SUPPORTED_MINIMUM("22G0Q"),
    DATA_NUMBER_OF_EDGE_LABELS_EXCEEDS_SUPPORTED_MAXIMUM("22G0R"),
    DATA_NUMBER_OF_NODE_PROPERTIES_EXCEEDS_SUPPORTED_MAXIMUM("22G0S"),
    DATA_NUMBER_OF_EDGE_PROPERTIES_EXCEEDS_SUPPORTED_MAXIMUM("22G0T"),
    RECORD_FIELDS_DO_NOT_MATCH("22G0U"),
    REFERENCE_VALUE_INVALID_BASE_TYPE("22G0V"),
    REFERENCE_VALUE_INVALID_CONSTRAINED_TYPE("22G0W"),
    RECORD_DATA_FIELD_UNASSIGNABLE("22G0X"),
    RECORD_DATA_FIELD_MISSING("22G0Y"),
    MALFORMED_PATH("22G0Z"),
    PATH_DATE_RIGHT_TRUNCATION("22G10"),
    REFERENCE_VALUE_REFERENT_DELETED("22G11"),
    INVALID_GROUP_VARIABLE_VALUE("22G13"),
    INCOMPATIBLE_TEMPORAL_INSTANT_UNIT_GROUPS("22G14"),
    INVALID_CAST("22G15"),
    INVALID_TRANSACTION_STATE("25000"),
    ACTIVE_GQL_TRANSACTION("25G01"),
    CATALOG_AND_DATA_STATEMENT_MIXING_NOT_SUPPORTED("25G02"),
    READ_ONLY_GQL_TRANSACTION("25G03"),
    ACCESSING_MULTIPLE_GRAPHS_NOT_SUPPORTED("25G04"),
    INVALID_TRANSACTION_TERMINATION("2D000"),
    TRANSACTION_ROLLBACK("40000"),
    STATEMENT_COMPLETION_UNKNOWN("40003"),
    SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION("42000"),
    INVALID_SYNTAX("42001"),
    INVALID_REFERENCE("42002"),
    USE_OF_VISUALLY_CONFUSABLE_IDENTIFIERS("42004"),
    SYNTAX_NUMBER_OF_EDGE_LABELS_BELOW_SUPPORTED_MINIMUM("42006"),
    SYNTAX_NUMBER_OF_EDGE_LABELS_EXCEEDS_SUPPORTED_MAXIMUM("42007"),
    SYNTAX_NUMBER_OF_EDGE_PROPERTIES_EXCEEDS_SUPPORTED_MAXIMUM("42008"),
    SYNTAX_NUMBER_OF_NODE_LABELS_BELOW_SUPPORTED_MINIMUM("42009"),
    SYNTAX_NUMBER_OF_NODE_LABELS_EXCEEDS_SUPPORTED_MAXIMUM("42010"),
    SYNTAX_NUMBER_OF_NODE_PROPERTIES_EXCEEDS_SUPPORTED_MAXIMUM("42011"),
    NUMBER_OF_NODE_TYPE_KEY_LABELS_BELOW_SUPPORTED_MINIMUM("42012"),
    NUMBER_OF_NODE_TYPE_KEY_LABELS_EXCEEDS_SUPPORTED_MAXIMUM("42013"),
    NUMBER_OF_EDGE_TYPE_KEY_LABELS_BELOW_SUPPORTED_MINIMUM("42014"),
    NUMBER_OF_EDGE_TYPE_KEY_LABELS_EXCEEDS_SUPPORTED_MAXIMUM("42015"),
    EMPTY_STATEMENT("42N01"),
    INVALID_SYNTAX_MULTIPLE_PRIMARY_KEY("42N02"),
    INVALID_SYNTAX_PRIMARY_KEY_NOT_FOUND_IN_PROPS("42N03"),
    INVALID_SYNTAX_SRC_TYPE_OF_EDGE_NOT_SPECIFIED("42N04"),
    INVALID_SYNTAX_DST_TYPE_OF_EDGE_NOT_SPECIFIED("42N05"),
    INVALID_SYNTAX_UNKNOWN_ELEMENT_TYPE("42N06"),
    INVALID_SYNTAX_INDEX_TYPE_ALIAS_ILLEGAL("42N07"),
    INVALID_SYNTAX_DUPLICATE_PROPERTY("42N08"),
    INVALID_SYNTAX_NEST_QUERY_LAST_STATEMENT_ERROR("42N09"),
    INVALID_SYNTAX_NEST_QUERY_RESULT_STATEMENT_ERROR("42N10"),
    INVALID_SYNTAX_NEST_QUERY_COLUMN_SIZE_ERROR("42N11"),
    INVALID_SYNTAX_NEST_QUERY_RETURN_AGG_ERROR("42N12"),
    INVALID_SYNTAX_NEST_QUERY_RETURN_LIMIT_ERROR("42N13"),
    INVALID_SYNTAX_VAR_TYPE_CONFLICT("42N14"),
    INVALID_SYNTAX_EQUI_JOIN_ON_CONDITIONAL_VAR("42N15"),
    INVALID_SYNTAX_EQUI_JOIN_ON_GROUP_VAR("42N16"),
    INVALID_SYNTAX_VAR_TYPE_ERROR("42N17"),
    INVALID_SYNTAX_VAR_NOT_DEFINED("42N18"),
    INVALID_SYNTAX_INSERT_BOUND_NODE("42N19"),
    INVALID_SYNTAX_VAR_INVALID_NODE_TYPE("42N20"),
    INVALID_SYNTAX_VAR_REFER_MULTIPLE_NODE_TYPE("42N21"),
    INVALID_SYNTAX_REDEFINED_VAR("42N22"),
    INVALID_SYNTAX_CONFLICT_VAR_TYPE("42N23"),
    INVALID_SYNTAX_YIELD_ITEM_TYPE("42N24"),
    INVALID_SYNTAX_MULTIPLE_NODE_INSERT("42N25"),
    INVALID_SYNTAX_DUPLICATED_PROPERTY_NAME("42N26"),
    INVALID_SYNTAX_DUPLICATED_INDEX_PROPERTY("42N27"),
    INVALID_SYNTAX_CONFLICT_PROPERTY_VALUE_TYPE("42N28"),
    DEPENDENT_OBJECT_ERROR("G1000"),
    EDGES_STILL_EXIST("G1001"),
    ENDPOINT_NODE_IS_DELETED("G1002"),
    ENDPOINT_NODE_NOT_IN_CURRENT_WORKING_GRAPH("G1003"),
    GRAPH_TYPE_VIOLATION("G2000"),
    PART_NOT_FOUND("ND001"),
    NODE_ALREADY_EXIST("ND002"),
    EDGE_ALREADY_EXIST("ND003"),
    PROPERTY_NOT_FOUND("ND004"),
    LEADER_CHANGED("ND005"),
    BINDING_TABLE_WRITE_FAILED("ND006"),
    BINDING_TABLE_NO_SPACE("ND007"),
    CATALOG_DIRECTORY_NOT_FOUND("NC001"),
    CATALOG_SCHEMA_NOT_FOUND("NC002"),
    CATALOG_NODE_TYPE_NOT_FOUND("NC003"),
    CATALOG_EDGE_TYPE_NOT_FOUND("NC004"),
    CATALOG_PRIMARY_KEY_NOT_FOUND("NC005"),
    CATALOG_PROPERTY_NOT_FOUND("NC006"),
    CATALOG_INDEX_NOT_FOUND("NC007"),
    CATALOG_PRIMARY_KEY_PROPERTY_NOT_FOUND("NC008"),
    CATALOG_ELEMENT_TYPE_FOR_INSERT_NOT_FOUND("NC009"),
    CATALOG_SCHEMA_ALREADY_EXISTS("NC101"),
    CATALOG_EDGE_TYPE_ALREADY_EXIST("NC102"),
    CATALOG_NODE_TYPE_ALREADY_EXIST("NC103"),
    CATALOG_GRAPH_TYPE_ALREADY_EXIST("NC104"),
    CATALOG_GRAPH_ALREADY_EXIST("NC105"),
    CATALOG_PROPERTY_TYPE_ALREADY_EXIST("NC106"),
    CATALOG_NODE_INDEX_ALREADY_EXISTS("NC107"),
    CATALOG_EDGE_INDEX_ALREADY_EXISTS("NC108"),
    CATALOG_GRAPH_TYPE_MISMATCH("NC201"),
    CATALOG_PRIMARY_KEY_NULLABLE("NC202"),
    CATALOG_INDEX_PROPERTY_TYPE_NOT_SUPPORTED("NC203"),
    CATALOG_PROPERTY_INVALID("NC204"),
    CATALOG_CANCEL_JOB_FAILED("NC301"),
    CATALOG_DDL_MANAGER_STOPPED("NC302"),
    CATALOG_STATE_PERMISSION_DENIED("NC303"),
    CATALOG_VERSION_RETIRED("NC304"),
    META_CLUSTER_ALREADY_EXISTS("NI001"),
    META_CLUSTER_NOT_FOUND("NI002"),
    META_SERVICE_HOST_NOT_ADDED("NI101"),
    META_SERVICE_REPORT_NOT_MATCH_ADDED("NI102"),
    META_SERVICE_ALREADY_EXISTS("NI103"),
    META_PART_CONFIG_INVALID("NI201"),
    STORAGE_EXECUTOR_PARAMETER_INVALID("NI301"),
    STORAGE_EXECUTOR_PARAMETER_TYPE_INVALID("NI302"),
    STORAGE_EXECUTOR_PARAMETER_PRIMARY_KEY_INVALID("NI303"),
    CONFIGURATION_INVALID("NI401"),
    CONFIGURATION_ITEM_NOT_FOUND("NI402"),
    CONFIGURATION_ITEM_TYPE_INVALID("NI403"),
    CONFIGURATION_ITEM_RANGE_INVALID("NI404"),
    CONFIGURATION_INFO_FILE_FORMAT_ILLEGAL("NI405"),
    CONFIGURATION_INVALID_CONFIG_KEY("NI406"),
    CONFIGURATION_INVALID_AUDIT_CATEGORY("NI407"),
    CONFIGURATION_MISSING_CONFIG_KEY("NI408"),
    CONFIGURATION_ILLEGAL_FORMAT("NI409"),
    JOB_DESCRIPTION_INVALID("NJ001"),
    GRAPH_COMPUTE_ERROR("NG000"),
    PLUGIN_ERROR("NP000"),
    PLUGIN_INVALID_TYPE("NP001"),
    PLUGIN_MULTIPLE_PLUGIN("NP002"),
    PLUGIN_CONFIG_NOT_FOUND("NP003"),
    PLUGIN_CONFIG_PARSE_ERROR("NP004"),
    PLUGIN_INIT_ERROR("NP005"),
    PLUGIN_DESTROY_ERROR("NP006"),
    PLUGIN_UNSUPPORT_AUTH_TYPE("NP007"),
    PROCEDURE_ERROR("NP101"),
    PROCEDURE_INVALID_ARGUMENT("NP102"),
    PROCEDURE_NOT_FOUND("NP103"),
    PROCEDURE_NO_OUTPUT("NP104"),
    PROCEDURE_NUM_ARGS_NOT_ENOUGH("NP105"),
    PROCEDURE_NUM_ARGS_EXCEEDED("NP106"),
    PROCEDURE_INVALID_ARGUMENT_TYPE("NP107"),
    PROCEDURE_INVALID_ARGUMENT_ENCODE("NP108"),
    PROCEDURE_YIELD_COLUMN_ERROR("NP109"),
    PROCEDURE_UNKNOWN_YIELD_COLUMN("NP110"),
    UDF_ERROR("NP201"),
    MODULE_ERROR("NP301"),
    MODULE_ALREADY_LOADED("NP302"),
    MODULE_NOT_FOUND("NP303"),
    MODULE_BEING_USED("NP304"),
    MODULE_INVALID_PROC_NAME("NP305"),
    MODULE_INVALID_FUNC_NAME("NP306"),
    MODULE_INVALID_PLUGIN_NAME("NP307"),
    MODULE_INVALID_PLUGIN_API_VERSION("NP308"),
    MODULE_INVALID_NULL_PLUGIN("NP309"),
    MODULE_DLOPEN_ERROR("NP310"),
    AUTH_INVALID_PASSWORD("NH001"),
    AUTH_USER_EXIST("NH002"),
    AUTH_USER_NOT_EXIST("NH003"),
    AUTH_USER_DISABLED("NH004"),
    AUTH_USER_LOCKED("NH005"),
    AUTH_INVALID_USERNAME("NH006"),
    AUTH_INVALID_USERNAME_OR_PASSWORD("NH007"),
    AUTH_CANNOT_DISABLE_SYSTEM_USER("NH008"),
    AUTH_NEED_CHANGE_PASSWORD("NH009"),
    AUTH_INVALID_AUTH_INFO("NH101"),
    AUTH_INVALID_TOKEN("NH201"),
    AUTH_INIT_ERROR("NH301"),
    SESSION_ERROR("NE000"),
    CREATE_SESSION_FAILED("NE001"),
    STORAGE_CODEC_PROPERTY_NOT_NULLABLE("NO001"),
    STORAGE_CODEC_PROPERTY_NOT_SET("NO002"),
    STORAGE_CODEC_PROPERTY_NOT_FOUND("NO003"),
    STORAGE_CODEC_PROPERTY_TYPE_NOT_MATCH("NO004"),
    STORAGE_CODEC_PROPERTY_OUT_OF_RANGE("NO005"),
    STORAGE_CODEC_PROPERTY_UNABLE_TO_ENCODE("NO006"),
    STORAGE_CODEC_INDEX_ILLEGAL("NO007"),
    STORAGE_CODEC_INDEX_PROPERTIES_ILLEGAL("NO008"),
    STORAGE_CODEC_INDEX_PROPERTY_NOT_REQUIRED("NO009"),
    STORAGE_CODEC_DECODE_FAILED("NO010"),
    STORAGE_CODEC_PROPERTY_LIST_NEST_TYPE_NOT_FOUND("NO011"),
    STORAGE_CODEC_INDEX_CORRUPTION_NO_TERMINATOR("NO012"),
    STORAGE_CODEC_INDEX_PROPERTIES_ILLEGAL_PROPERTY_NOT_EXIST("NO013"),
    STORAGE_CODEC_INDEX_ILLEGAL_NOT_RESERVED_PROPERTY("NO014"),
    STORAGE_CODEC_WRITE_VECTOR_FAILED("NO015"),
    GET_ALL_PART_FAILED("NO101"),
    GET_PART_ROUTER_FAILED("NO102"),
    GET_ALL_LEADER_FAILED("NO103"),
    EXPR_EVAL_FAILED("22N02"),
    RUNTIME_ERROR("NR000"),
    EXPR_ERROR("NR001"),
    UNDEFINED_FUNCTION("NR002"),
    INVALID_FUNCTION_ARGUMENT("NR003"),
    INVALID_LOGICAL_EXPRESSION("NR004"),
    EXPR_COMPILE_FAILED("NR005"),
    RESOLVE_FUNCTION_FAILED("NR006"),
    EXPR_TYPE_INFER_FAILED("NR007"),
    INVALID_CAST_EXPR("NR008"),
    INVALID_CONST_EXPR("NR009"),
    INVALID_CONSTRUCT_PATH_EXPR_INPUT("NR010"),
    INVALID_CASE_EXPR_WHEN_INPUT("NR011"),
    INVALID_EXPRESSION_TYPE("NR012"),
    INVALID_CONSTRUCT_LIST_EXPR_INPUT("NR013"),
    INVALID_CASE_EXPR_THEN_INPUT("NR014"),
    CREATE_NODE_INDEX_FAILED("NR100"),
    CREATE_EDGE_INDEX_FAILED("NR101"),
    CREATE_GRAPH_TYPE_FAILED("NR102"),
    CREATE_GRAPH_FAILED("NR103"),
    DROP_REFERNCED_GRAPH_TYPE("NR104"),
    DROP_GRAPH_TYPE_FAILED("NR105"),
    DROP_GRAPH_FAILED("NR106"),
    DROP_INDEX_FAILED("NR107"),
    CATALOG_MIRROR_GRAPH_ALREADY_EXIST("NR108"),
    CATALOG_MIRROR_GRAPH_NOT_FOUND("NR109"),
    CATALOG_GRAPH_ALREADY_HAVE_MIRROR_GRAPH("NR110"),
    CATALOG_GRAPH_DO_NOT_HAVE_MIRROR_GRAPH("NR111"),
    CATALOG_MIRROR_GRAPH_NAME_CONFLICT("NR112"),
    CATALOG_MIRROR_GRAPH_BASE_GRAPH_EMPTY("NR113"),
    DISCRIMINATOR_NOT_FOUND_IN_PROPS("NR114"),
    INSERT_NODE_FAILED("NR201"),
    GET_NODE_ID_FAILED("NR202"),
    INSERT_EDGE_FAILED("NR203"),
    SRC_NODE_NOT_EXISTED("NR204"),
    DST_NODE_NOT_EXISTED("NR205"),
    DML_NUM_OF_PROPERTY_NOT_MATCH("NR206"),
    DML_PROPERTY_NOT_NULLABLE("NR207"),
    PRIMARY_KEY_CONSTRAINT_VIOLATION("NR208"),
    EDGE_RANK_CONSTRAINT_VIOLATION("NR209"),
    NODE_IS_MISSING("NR210"),
    GET_NODE_ID_FROM_PRIMARY_KEY_FAILED("NR211"),
    INSERT_INFER_MORE_THAN_ONE_TYPE("NR212"),
    ENDPOINT_NODE_TYPES_MISMATCH("NR213"),
    SET_FAILED("NR231"),
    SET_INVALID_TYPE("NR232"),
    DELETE_NODE_FAILED("NR251"),
    DELETE_EDGE_FAILED("NR252"),
    INVALID_DELETE_TYPE("NR253"),
    MEMORY_EXCEEDED("NR301"),
    QUERY_CANCELED("NR302"),
    BAD_PLAN_NODE_TYPE("NR303"),
    SPLIT_PLAN_TO_STORAGE_FAILED("NR304"),
    KILL_QUERY_FAILED("NR401"),
    KILL_SESSION_FAILED("NR402"),
    QUERY_ID_NOT_FOUND("NR403"),
    MAX_EXECUTION_TIME_EXCEEDED("NR404"),
    SESSION_NOT_FOUND("NR405"),
    SESSION_IS_BUSY("NR406"),
    SEMANTIC_ERROR("NS000"),
    UNDEFINED_VARIABLE("NS001"),
    DUPLICATE_DEFINE_VARIABLE("NS002"),
    UNDEFINED_PARAMETER("NS003"),
    SEMANTIC_LINEAR_QUERY_COLUMN_SIZE_MISMATCH("NS004"),
    SEMANTIC_FILTER_CLAUSE_MUST_BE_BOOL_TYPE("NS005"),
    SEMANTIC_INVALID_EXPRESSION_TYPE("NS006"),
    SEMANTIC_NODE_PRIMARY_KEY_PROPERTY_NUM_MISMATCH("NS101"),
    SEMANTIC_NODE_PRIMARY_KEY_PROPERTY_NOT_FOUND("NS102"),
    SEMANTIC_GRAPH_PATTERN_QUANTIFIER_EXCEED_LOW_BOUND("NS103"),
    SEMANTIC_GRAPH_PATTERN_QUANTIFIER_LOW_BOUND_EXCEED_UP_BOUND("NS104"),
    SEMANTIC_INVALID_EDGE_PATTERN("NS105"),
    SEMANTIC_RETURN_ALL_WITH_GROUPBY("NS106"),
    SEMANTIC_RETURN_ALL_WITH_NO_VARS_IN_SCOPE("NS107"),
    SEMANTIC_RETURN_ALL_WITH_EMPTY_GROUPBY("NS108"),
    SEMANTIC_RETURN_DUPLICATE_COLUMN("NS109"),
    SEMANTIC_INVALID_EDGE_PREDICATE("NS110"),
    SEMANTIC_EMPTY_GROUPBY_MISMATCH("NS201"),
    SEMANTIC_NO_AGG_FOUND_WITH_GROUPBY("NS202"),
    SEMANTIC_GROUPBY_NO_BINDING("NS203"),
    SEMANTIC_GROUPBY_CONTAIN_AGG_EXPR("NS204"),
    SEMANTIC_GROUPBY_MISMATCH("NS205"),
    SEMANTIC_IMPLICIT_AGG_IN_RETURN("NS206"),
    SEMANTIC_VAR_PROP_SETITEM_ERROR("NS207"),
    SEMANTIC_ASSIGN_EXPR_TYPE_ERROR("NS208"),
    SEMANTIC_CURRENT_WORKING_GRAPH_NOT_FOUND("NS209"),
    UNSUPPORTED("NT000"),
    UNSUPPORTED_INDEX_PROPERTY_TYPE("NT001"),
    UNSUPPORTED_NODE_TYPE_WITHOUT_PRIMARY_KEY("NT002"),
    UNSUPPORTED_GRAPH_TYPE_EXPR("NT003"),
    UNSUPPORTED_GRAPH_TYPE_INITIALIZER("NT004"),
    UNSUPPORTED_EDGE_DIRECTION("NT005"),
    UNSUPPORTED_DUPLICATE_LABEL_AND_PROPERTY_SET("NT006"),
    UNSUPPORTED_INSERT_EDGE_STATEMENT("NT101"),
    UNSUPPORTED_INSERT_NODE_STATEMENT("NT102"),
    UNSUPPORTED_DATE_MODIFY_STATEMENT("NT103"),
    UNSUPPORTED_MULTIPLE_PATH_PATTERN("NT104"),
    UNSUPPORTED_UPDATE_PRIMARY_KEY("NT105"),
    UNSUPPORTED_SET_MULTIPLE_NODE_TYPE("NT106"),
    UNSUPPORTED_SET_ALL_SET_LABEL("NT107"),
    UNSUPPORTED_UPDATE_MULTIEDGE_KEY("NT107"),
    UNSUPPORTED_AGGREGATION_EXPRESSION("NT201"),
    UNSUPPORTED_AGGREGATION_EXPRESSION_NESTED("NT202"),
    AGGREGATION_EXPRESSION_NOT_ALLOWED("NT203"),
    UNDEFINED_AGG_FUNCTION("NT204"),
    UNSUPPORTED_TRIM_NON_ASCII_CHAR("NT205"),
    UNSUPPORTED_TYPE_GET_PROP("NT206"),
    UNSUPPORTED_PATH_FACTOR("NT301"),
    UNSUPPORTED_CHARSET("NT401"),
    UNSUPPORTED_COLLATION("NT402"),
    UNSUPPORTED_CHARSET_COLLATION_NOT_MATCH("NT403"),
    LICENSE_ENCRYPTION_ERROR("NL001"),
    LICENSE_MANAGER_ERROR("NL101"),
    JOB_ERROR("NJ000"),
    JOB_TYPE_UNKNOWN("NJ001"),
    JOB_NOT_FOUND("NJ002"),
    JOB_TASK_NOT_FOUND("NJ003"),
    JOB_CAN_NOT_RUN("NJ004"),
    TASK_NOT_IN_STOR("NJ011"),
    TASK_REBUILD_INDEX_IS_RUNNING("NJ012"),
    JOB_PLACEHOLDER_ERROR("NJ099"),
    UNKNOWN_FOR_CLIENT(null);

    public final String code;
    private static Map<String, ErrorCode> errorCodeMap;

    private ErrorCode(String c) {
        this.code = c;
    }

    public static ErrorCode find(String code) {
        if (errorCodeMap.containsKey(code)) {
            return errorCodeMap.get(code);
        }
        return UNKNOWN_FOR_CLIENT;
    }

    public boolean isRetryable() {
        return this.isSessionError() || this.isRpcError() || this.isRaftError();
    }

    public boolean isSemanticError() {
        return this.code.startsWith("NS");
    }

    public boolean isSyntaxError() {
        return this.code.startsWith("42");
    }

    public boolean isSessionError() {
        return this.code.startsWith("NE");
    }

    public boolean isRpcError() {
        return this.code.startsWith("NN");
    }

    public boolean isRaftError() {
        return this.code.startsWith("NA");
    }

    public boolean isNoDataError() {
        return this.code.startsWith("02");
    }

    static {
        errorCodeMap = new HashMap<String, ErrorCode>();
        for (ErrorCode value : ErrorCode.values()) {
            errorCodeMap.put(value.code, value);
        }
    }
}

