/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.HostAddr;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DrainerClientInfo
implements TBase,
Serializable,
Cloneable,
Comparable<DrainerClientInfo> {
    private static final TStruct STRUCT_DESC = new TStruct("DrainerClientInfo");
    private static final TField HOST_FIELD_DESC = new TField("host", 12, 1);
    private static final TField SPACE_NAME_FIELD_DESC = new TField("space_name", 11, 2);
    public HostAddr host;
    public byte[] space_name;
    public static final int HOST = 1;
    public static final int SPACE_NAME = 2;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public DrainerClientInfo() {
    }

    public DrainerClientInfo(HostAddr host, byte[] space_name) {
        this();
        this.host = host;
        this.space_name = space_name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DrainerClientInfo(DrainerClientInfo other) {
        if (other.isSetHost()) {
            this.host = TBaseHelper.deepCopy(other.host);
        }
        if (other.isSetSpace_name()) {
            this.space_name = TBaseHelper.deepCopy(other.space_name);
        }
    }

    @Override
    public DrainerClientInfo deepCopy() {
        return new DrainerClientInfo(this);
    }

    public HostAddr getHost() {
        return this.host;
    }

    public DrainerClientInfo setHost(HostAddr host) {
        this.host = host;
        return this;
    }

    public void unsetHost() {
        this.host = null;
    }

    public boolean isSetHost() {
        return this.host != null;
    }

    public void setHostIsSet(boolean __value) {
        if (!__value) {
            this.host = null;
        }
    }

    public byte[] getSpace_name() {
        return this.space_name;
    }

    public DrainerClientInfo setSpace_name(byte[] space_name) {
        this.space_name = space_name;
        return this;
    }

    public void unsetSpace_name() {
        this.space_name = null;
    }

    public boolean isSetSpace_name() {
        return this.space_name != null;
    }

    public void setSpace_nameIsSet(boolean __value) {
        if (!__value) {
            this.space_name = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetHost();
                    break;
                }
                this.setHost((HostAddr)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetSpace_name();
                    break;
                }
                this.setSpace_name((byte[])__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getHost();
            }
            case 2: {
                return this.getSpace_name();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof DrainerClientInfo)) {
            return false;
        }
        DrainerClientInfo that = (DrainerClientInfo)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetHost(), that.isSetHost(), this.host, that.host)) {
            return false;
        }
        return TBaseHelper.equalsSlow(this.isSetSpace_name(), that.isSetSpace_name(), this.space_name, that.space_name);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.host, this.space_name});
    }

    @Override
    public int compareTo(DrainerClientInfo other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetHost()).compareTo(other.isSetHost());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.host, other.host);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSpace_name()).compareTo(other.isSetSpace_name());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.space_name, other.space_name);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 12) {
                        this.host = new HostAddr();
                        this.host.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 11) {
                        this.space_name = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.host != null) {
            oprot.writeFieldBegin(HOST_FIELD_DESC);
            this.host.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.space_name != null) {
            oprot.writeFieldBegin(SPACE_NAME_FIELD_DESC);
            oprot.writeBinary(this.space_name);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("DrainerClientInfo");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("host");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getHost() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getHost(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("space_name");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getSpace_name() == null) {
            sb.append("null");
        } else {
            int __space_name_size = Math.min(this.getSpace_name().length, 128);
            for (int i = 0; i < __space_name_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getSpace_name()[i]).length() > 1 ? Integer.toHexString(this.getSpace_name()[i]).substring(Integer.toHexString(this.getSpace_name()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getSpace_name()[i]).toUpperCase());
            }
            if (this.getSpace_name().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("host", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(2, new FieldMetaData("space_name", 3, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(DrainerClientInfo.class, metaDataMap);
    }

    public static class Builder {
        private HostAddr host;
        private byte[] space_name;

        public Builder setHost(HostAddr host) {
            this.host = host;
            return this;
        }

        public Builder setSpace_name(byte[] space_name) {
            this.space_name = space_name;
            return this;
        }

        public DrainerClientInfo build() {
            DrainerClientInfo result = new DrainerClientInfo();
            result.setHost(this.host);
            result.setSpace_name(this.space_name);
            return result;
        }
    }
}

