/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.transport;

import com.facebook.thrift.transport.OkHttp3Util;
import com.facebook.thrift.transport.TTransport;
import com.facebook.thrift.transport.TTransportException;
import com.facebook.thrift.utils.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class THttp2Client
extends TTransport {
    private static final Logger LOGGER = Logger.getLogger(THttp2Client.class.getName());
    private final ByteArrayOutputStream requestBuffer = new ByteArrayOutputStream();
    private InputStream inputStream = null;
    private Map<String, String> customHeaders = null;
    private static final Map<String, String> defaultHeaders = THttp2Client.getDefaultHeaders();
    private OkHttpClient client;
    private final SSLSocketFactory sslFactory;
    private final TrustManager trustManager;
    private final String url;
    private int connectTimeout = 0;
    private int readTimeout = 0;

    public THttp2Client(String url) throws TTransportException {
        this(url, null, null);
    }

    public THttp2Client(String url, SSLSocketFactory sslFactory, TrustManager trustManager) throws TTransportException {
        this.url = url;
        this.sslFactory = sslFactory;
        this.trustManager = trustManager;
    }

    public THttp2Client setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public THttp2Client setReadTimeout(int timeout) {
        this.readTimeout = timeout;
        return this;
    }

    public THttp2Client setCustomHeaders(Map<String, String> headers) {
        this.customHeaders = headers;
        return this;
    }

    public THttp2Client setCustomHeader(String key, String value) {
        if (this.customHeaders == null) {
            this.customHeaders = new HashMap<String, String>();
        }
        this.customHeaders.put(key, value);
        return this;
    }

    @Override
    public void open() {
        this.client = OkHttp3Util.getClient(this.connectTimeout, this.readTimeout, this.sslFactory, this.trustManager);
    }

    @Override
    public void close() {
        try {
            this.requestBuffer.close();
            this.inputStream.close();
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage());
        }
        OkHttp3Util.close();
    }

    @Override
    public boolean isOpen() {
        return this.client != null;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        if (this.inputStream == null) {
            throw new TTransportException("Response buffer is empty, no request.");
        }
        try {
            int ret = this.inputStream.read(buf, off, len);
            if (ret == -1) {
                throw new TTransportException("No more data available.");
            }
            return ret;
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.requestBuffer.write(buf, off, len);
    }

    @Override
    public void flush() throws TTransportException {
        if (null == this.client) {
            throw new TTransportException("Null HttpClient, aborting.");
        }
        byte[] data = this.requestBuffer.toByteArray();
        this.requestBuffer.reset();
        try (Response response = null;){
            Request request;
            Request.Builder requestBuilder = new Request.Builder().url(this.url).post(RequestBody.create((MediaType)MediaType.parse((String)"application/x-thrift"), (byte[])data));
            defaultHeaders.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).header(arg_0, arg_1));
            if (this.customHeaders != null) {
                this.customHeaders.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).header(arg_0, arg_1));
            }
            if (!(response = this.client.newCall(request = requestBuilder.build()).execute()).isSuccessful()) {
                throw new TTransportException("HTTP Response code: " + response.code());
            }
            if (response.body() == null) {
                throw new TTransportException("response body is null");
            }
            this.inputStream = new ByteArrayInputStream(response.body().bytes());
        }
    }

    private static Map<String, String> getDefaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/x-thrift");
        headers.put("Accept", "application/x-thrift");
        headers.put("User-Agent", "Java/THttpClient");
        return headers;
    }
}

