/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.net;

import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.exception.InvalidSessionException;
import com.vesoft.nebula.client.graph.net.Session;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;

public class SessionWrapper
implements Serializable {
    private static final long serialVersionUID = -8128331485649098264L;
    private final Session session;
    private final long sessionID;
    private final AtomicBoolean available = new AtomicBoolean(true);

    public SessionWrapper(Session session) {
        this.session = session;
        this.sessionID = session.getSessionID();
    }

    public ResultSet execute(String stmt) throws IOErrorException {
        if (!this.available()) {
            throw new InvalidSessionException();
        }
        return this.session.execute(stmt);
    }

    public boolean ping() {
        return this.session.pingSession();
    }

    void setNoAvailable() {
        this.available.set(false);
    }

    boolean available() {
        return this.available.get();
    }

    void release() {
        this.session.release();
        this.setNoAvailable();
    }

    Session getSession() {
        return this.session;
    }
}

